from uuid import uuid4

import pytest

from arkindex_cli.commands.export.utils import bounding_box, image_download
from arkindex_export import Image, ImageServer


@pytest.mark.parametrize(
    ["version", "expected_url"],
    [
        (2, "http://example.teklia.com/identifier/full/full/0/default.jpg"),
        (3, "http://example.teklia.com/identifier/full/max/0/default.jpg"),
    ],
)
def test_image_download(responses, tmp_path, samples_dir, version, expected_url):
    """
    Tests correct path is returned by image_download after redirecting input url
    with a response fixture
    """
    responses.add(
        responses.GET,
        url=expected_url,
        status=200,
        body=(samples_dir / "image.jpg").open("rb"),
    )

    image = Image(
        id=uuid4(),
        server=ImageServer(
            id=1,
            url="http://example.teklia.com",
            version=version,
        ),
        url="http://example.teklia.com/identifier",
        width=1000,
        height=1000,
    )

    assert image_download(image, tmp_path) == tmp_path / f"{image.id}.jpg"


def test_bounding_box():
    """
    Tests correct starting coordinates, width and height is return from polygon
    coordinates
    """
    assert bounding_box(
        """[[538, 2307], [694, 2299], [767, 2316], [815, 2371], [1716, 2357],
        [2271, 2348], [2271, 1181], [1718, 1191], [902, 1171], [827, 1169],
        [788, 1192], [583, 1217], [538, 2307]]"""
    ) == (538, 2371, 1733, 1202)
