"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)


DEFINITION = """
query AppInterfaceRoles {
    roles: roles_v1 {
    name
    users {
      org_username
      github_username
    }
    bots {
      openshift_serviceaccount
    }
    access {
      namespace {
        name
        clusterAdmin
        managedRoles
        delete
        cluster {
          name
          auth {
            service
          }
        }
      }
      role
      clusterRole
    }
    expirationDate
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class UserV1(ConfiguredBaseModel):
    org_username: str = Field(..., alias="org_username")
    github_username: str = Field(..., alias="github_username")


class BotV1(ConfiguredBaseModel):
    openshift_serviceaccount: Optional[str] = Field(..., alias="openshift_serviceaccount")


class ClusterAuthV1(ConfiguredBaseModel):
    service: str = Field(..., alias="service")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    auth: list[ClusterAuthV1] = Field(..., alias="auth")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    managed_roles: Optional[bool] = Field(..., alias="managedRoles")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: ClusterV1 = Field(..., alias="cluster")


class AccessV1(ConfiguredBaseModel):
    namespace: Optional[NamespaceV1] = Field(..., alias="namespace")
    role: Optional[str] = Field(..., alias="role")
    cluster_role: Optional[str] = Field(..., alias="clusterRole")


class RoleV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    users: list[UserV1] = Field(..., alias="users")
    bots: list[BotV1] = Field(..., alias="bots")
    access: Optional[list[AccessV1]] = Field(..., alias="access")
    expiration_date: Optional[str] = Field(..., alias="expirationDate")


class AppInterfaceRolesQueryData(ConfiguredBaseModel):
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")


def query(query_func: Callable, **kwargs: Any) -> AppInterfaceRolesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AppInterfaceRolesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AppInterfaceRolesQueryData(**raw_data)
