"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.container_image_mirror import ContainerImageMirror


DEFINITION = """
fragment ContainerImageMirror on ContainerImageMirror_v1 {
  url
  pullCredentials {
    ...VaultSecret
  }
  tags
  tagsExclude
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query GcpDockerRepos {
  apps: apps_v1 {
    gcrRepos {
      project {
        name
      }
      items {
        name
        mirror {
          ...ContainerImageMirror
        }
      }
    }
    artifactRegistryMirrors {
      project {
        name
      }
      items {
        imageURL
        mirror {
          ...ContainerImageMirror
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class GcpProjectV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AppGcrReposItemsV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    mirror: Optional[ContainerImageMirror] = Field(..., alias="mirror")


class AppGcrReposV1(ConfiguredBaseModel):
    project: GcpProjectV1 = Field(..., alias="project")
    items: list[AppGcrReposItemsV1] = Field(..., alias="items")


class AppArtifactRegistryMirrorsV1_GcpProjectV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AppArtifactRegistryMirrorsItemsV1(ConfiguredBaseModel):
    image_url: str = Field(..., alias="imageURL")
    mirror: ContainerImageMirror = Field(..., alias="mirror")


class AppArtifactRegistryMirrorsV1(ConfiguredBaseModel):
    project: AppArtifactRegistryMirrorsV1_GcpProjectV1 = Field(..., alias="project")
    items: list[AppArtifactRegistryMirrorsItemsV1] = Field(..., alias="items")


class AppV1(ConfiguredBaseModel):
    gcr_repos: Optional[list[AppGcrReposV1]] = Field(..., alias="gcrRepos")
    artifact_registry_mirrors: Optional[list[AppArtifactRegistryMirrorsV1]] = Field(..., alias="artifactRegistryMirrors")


class GcpDockerReposQueryData(ConfiguredBaseModel):
    apps: Optional[list[AppV1]] = Field(..., alias="apps")


def query(query_func: Callable, **kwargs: Any) -> GcpDockerReposQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        GcpDockerReposQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return GcpDockerReposQueryData(**raw_data)
