## dbt-adapters 1.0.0 - April 01, 2024

### Features

* Update RelationConfig to capture all fields used by adapters ([#30](https://github.com/dbt-labs/dbt-adapters/issues/30))

### Fixes

* Add field wrapper to BaseRelation members that were missing it. ([#108](https://github.com/dbt-labs/dbt-adapters/issues/108))
* Add "description" and "meta" fields to RelationConfig protocol ([#119](https://github.com/dbt-labs/dbt-adapters/issues/119))
* Ignore adapter-level support warnings for 'custom' constraints ([#90](https://github.com/dbt-labs/dbt-adapters/issues/90))
* Make all adapter zone tests importable by removing "Test" prefix ([#93](https://github.com/dbt-labs/dbt-adapters/issues/93))

### Docs

* Configure `changie` ([#16](https://github.com/dbt-labs/dbt-adapters/issues/16))
* Setup ADR tracking framework ([#11](https://github.com/dbt-labs/dbt-adapters/issues/11))
* Create issue templates ([#12](https://github.com/dbt-labs/dbt-adapters/issues/12))
* Create PR template ([#13](https://github.com/dbt-labs/dbt-adapters/issues/13))

### Under the Hood

* Lazy load agate to improve dbt-core performance ([#125](https://github.com/dbt-labs/dbt-adapters/issues/125))
* add BaseAdapater.MAX_SCHEMA_METADATA_RELATIONS ([#131](https://github.com/dbt-labs/dbt-adapters/issues/131))
* Configure `dependabot` ([#14](https://github.com/dbt-labs/dbt-adapters/issues/14))
* Implement unit testing in CI ([#22](https://github.com/dbt-labs/dbt-adapters/issues/22))
* Allow version to be specified in either __version__.py or __about__.py ([#44](https://github.com/dbt-labs/dbt-adapters/issues/44))
* Remove __init__.py file from dbt.tests ([#96](https://github.com/dbt-labs/dbt-adapters/issues/96))

### Security

* Pin `black>=24.3` in `pyproject.toml` ([#140](https://github.com/dbt-labs/dbt-adapters/issues/140))
