# Changelog

- This file provides a full account of all changes to `dbt-adapters`
- The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie)
- Changes are listed under the (pre-)release in which they first appear
- Subsequent releases include changes from previous releases
- "Breaking changes" listed under a version may require action from end users or external maintainers when upgrading to that version
- Do not edit this file directly. This file is auto-generated using [changie](https://github.com/miniscruff/changie)
- For details on how to document a change, see the [contributing guide](/CONTRIBUTING.md#changelog-entry)

## dbt-adapters 1.17.0 - September 29, 2025

### Features

- Initial framework for UDF support ([#1268](https://github.com/dbt-labs/dbt-adapters/issues/1268))

### Fixes

- Fix duplicates when hard_deletes new_record is used with custom dbt_valid_to_current ([#1240](https://github.com/dbt-labs/dbt-adapters/issues/1240))
- Update function related global macros to use `default__` naming scheme ([#1356](https://github.com/dbt-labs/dbt-adapters/issues/1356))

### Contributors
- [@jeremyyeo](https://github.com/jeremyyeo) ([#1240](https://github.com/dbt-labs/dbt-adapters/issues/1240))


## dbt-adapters 1.16.6 - September 03, 2025

### Under the Hood

- Record adapter.add_query as Available record ([#1285](https://github.com/dbt-labs/dbt-adapters/issues/1285))
- Record adapter.list_relations_without_caching as Available record ([#1308](https://github.com/dbt-labs/dbt-adapters/issues/1308))

### Contributors
- [@jasonlin45](https://github.com/jasonlin45) ([#1308](https://github.com/dbt-labs/dbt-adapters/issues/1308))

## dbt-adapters 1.16.5 - August 19, 2025

### Fixes

- Correct column mapping lookup in unit test macro ([#1273](https://github.com/dbt-labs/dbt-adapters/issues/1273))

## dbt-adapters 1.16.4 - August 15, 2025

### Fixes

- Apply column quoting to unit tests ([#205](https://github.com/dbt-labs/dbt-adapters/issues/205))

### Dependencies

- upgrade protobuf to 6.0 ([#1259](https://github.com/dbt-labs/dbt-adapters/pull/1259))

### Contributors
- [@mpatek](https://github.com/mpatek) ([#205](https://github.com/dbt-labs/dbt-adapters/issues/205))

## dbt-adapters 1.16.3 - July 21, 2025

### Fixes

- Update dbt snapshot staging table creation to handle new source columns when using hard_deletes == 'new_record'  ([#852](https://github.com/dbt-labs/dbt-adapters/issues/852))
- update alter_relation_add_remove_columns to quote column names ([#63](https://github.com/dbt-labs/dbt-adapters/issues/63))

### Under the Hood

- gracefully handle null database in _catalog_filter_schemas ([#1216](https://github.com/dbt-labs/dbt-adapters/issues/1216))

## dbt-adapters 1.16.2 - July 14, 2025

### Fixes

- Fixed hard-coded quoting issue in snapshots. ([#1118](https://github.com/dbt-labs/dbt-adapters/issues/1118))
- Skip cloning objects if the target and defferal are the same ([#1198](https://github.com/dbt-labs/dbt-adapters/issues/1198))

### Contributors
- [@stevetracvc](https://github.com/stevetracvc) ([#1118](https://github.com/dbt-labs/dbt-adapters/issues/1118))

## dbt-adapters 1.16.1 - July 10, 2025

### Fixes

- Fix Snapshot to avoid inserting redundant entries for records already marked as deleted ([#654](https://github.com/dbt-labs/dbt-adapters/issues/654))

### Contributors
- [@lpillmann](https://github.com/lpillmann) ([#654](https://github.com/dbt-labs/dbt-adapters/issues/654))

## dbt-adapters 1.16.0 - June 04, 2025

### Features

- Add constant defining name of logical catalog in model config ([#1134](https://github.com/dbt-labs/dbt-adapters/issues/1134))

### Fixes

- Fix casing issue in snapshot target validation. ([#1101](https://github.com/dbt-labs/dbt-adapters/issues/1101))

### Under the Hood

- populate file_format from top level integration config field ([#1129](https://github.com/dbt-labs/dbt-adapters/issues/1129))

## dbt-adapters 1.15.3 - May 20, 2025

## dbt-adapters 1.15.2 - May 19, 2025

### Under the Hood

- bump dbt-common pin to >=2.0,<3.0 ([#1104](https://github.com/dbt-labs/dbt-adapters/issues/1104))

## dbt-adapters 1.15.1 - May 19, 2025

## dbt-adapters 1.15 - May 19, 2025

### Features

- Overridable default query comment append behavior ([#1065](https://github.com/dbt-labs/dbt-adapters/issues/1065))

### Fixes

- Respect the `limit` config when storing test failures ([#373](https://github.com/dbt-labs/dbt-adapters/issues/373))
- Keep `limit` as a required parameter in `get_test_sql` ([#1051](https://github.com/dbt-labs/dbt-adapters/issues/1051))
- Fix an issue with snapshots in new_record mode when check columns are used. ([#1068](https://github.com/dbt-labs/dbt-adapters/issues/1068))

### Under the Hood

- Keep table and column metadata as strings ([#1056](https://github.com/dbt-labs/dbt-adapters/issues/1056))

## dbt-adapters 1.14.8 - April 25, 2025

## dbt-adapters 1.14.7 - April 24, 2025

### Features

- Add "pointer_table" as a global relation type ([#1012](https://github.com/dbt-labs/dbt-adapters/issues/1012))

## dbt-adapters 1.14.6 - April 14, 2025

### Under the Hood

- Add more robust operation forwarding to record/replay wrappers. ([#990](https://github.com/dbt-labs/dbt-adapters/issues/990))

## dbt-adapters 1.14.5 - April 07, 2025

### Fixes

- Create indexes on the intermediate relation before the swap ([#966](https://github.com/dbt-labs/dbt-adapters/issues/966))
- Create indexes on the intermediate relation before the swap for incremental models ([#966](https://github.com/dbt-labs/dbt-adapters/issues/966))

### Contributors
- [@etx121](https://github.com/etx121) ([#966](https://github.com/dbt-labs/dbt-adapters/issues/966), [#966](https://github.com/dbt-labs/dbt-adapters/issues/966))

## dbt-adapters 1.14.4 - March 31, 2025

### Features

- Make source and target tables able to be referenced via DBT_INTERNAL_DEST and DBT_INTERNAL_SOURCE for the delete/insert incremental strategy ([#910](https://github.com/dbt-labs/dbt-adapters/issues/910))

### Fixes

- Fix the python model empty/sample mode fix to not break when the ref macro has been overridden ([#953](https://github.com/dbt-labs/dbt-adapters/issues/953))

## dbt-adapters 1.14.3 - March 19, 2025

### Features

- Add Base Adapter implementation of Catalog Integration support. ([#790](https://github.com/dbt-labs/dbt-adapters/issues/790))

### Fixes

- Run python models normally instead of breaking when run with `--sample` or `--empty` ([#906](https://github.com/dbt-labs/dbt-adapters/issues/906))

### Under the Hood

- Add node_checksum to NodeInfo in structured logs ([#883](https://github.com/dbt-labs/dbt-adapters/issues/883))
- Make use of new record/replay features to enable recording "available" functions ([#761](https://github.com/dbt-labs/dbt-adapters/issues/761))

## dbt-adapters 1.14.1 - March 04, 2025

### Fixes

- Fix incremental delete+insert SQL ([#150,](https://github.com/dbt-labs/dbt-adapters/issues/150,), [#364](https://github.com/dbt-labs/dbt-adapters/issues/364))

### Contributors
- [@ataft,](https://github.com/ataft,) ([#150,](https://github.com/dbt-labs/dbt-adapters/issues/150,), [#364](https://github.com/dbt-labs/dbt-adapters/issues/364))

## dbt-adapters 1.14.0 - February 07, 2025

## dbt-adapters 1.13.2 - January 22, 2025

## dbt-adapters 1.13.1 - January 10, 2025

### Fixes

- Fix is_replaceable check with wrong variable ([#187](https://github.com/dbt-labs/dbt-adapters/issues/187))
- Fix the snapshot merge query for several adapters in new_record mode. ([#385](https://github.com/dbt-labs/dbt-adapters/issues/385))

### Contributors
- [@rongfengliang](https://github.com/rongfengliang) ([#187](https://github.com/dbt-labs/dbt-adapters/issues/187))

## dbt-adapters 1.13.0 - December 19, 2024

### Features

- Add function to run custom sql for getting freshness info ([#8797](https://github.com/dbt-labs/dbt-adapters/issues/8797))

### Fixes

- Use `sql` instead of `compiled_code` within the default `get_limit_sql` macro ([#372](https://github.com/dbt-labs/dbt-adapters/issues/372))

### Under the Hood

- Adapter tests for new snapshot configs ([#380](https://github.com/dbt-labs/dbt-adapters/issues/380))

## dbt-adapters 1.12.0 - December 18, 2024

## dbt-adapters 1.11.0 - December 17, 2024

### Features

- Add new hard_deletes="new_record" mode for snapshots. ([#317](https://github.com/dbt-labs/dbt-adapters/issues/317))
- Introduce new Capability for MicrobatchConcurrency support ([#359](https://github.com/dbt-labs/dbt-adapters/issues/359))

### Under the Hood

- Add retry logic for retryable exceptions. ([#368](https://github.com/dbt-labs/dbt-adapters/issues/368))

## dbt-adapters 1.10.4 - November 11, 2024

### Features

- Use a behavior flag to gate microbatch functionality (instead of an environment variable) ([#327](https://github.com/dbt-labs/dbt-adapters/issues/327))

### Under the Hood

- Add `query_id` to SQLQueryStatus ([#342](https://github.com/dbt-labs/dbt-adapters/issues/342))

### Contributors
- [@cmcarthur](https://github.com/cmcarthur) ([#342](https://github.com/dbt-labs/dbt-adapters/issues/342))

## dbt-adapters 1.10.3 - October 29, 2024

## dbt-adapters 1.10.2 - October 01, 2024

### Under the Hood

- dbt-tests-adapters: Add required begin to microbatch model config to BaseMicrobatch test ([#315](https://github.com/dbt-labs/dbt-adapters/issues/315))

## dbt-adapters 1.10.1 - September 16, 2024

## dbt-adapters 1.10.0 - September 12, 2024

## dbt-adapters 1.9.0 - November 13, 2024

### Fixes

- Negate the check for microbatch behavior flag in determining builtins ([#349](https://github.com/dbt-labs/dbt-adapters/issues/349))
- Move require_batched_execution_for_custom_microbatch_strategy flag to global ([#351](https://github.com/dbt-labs/dbt-adapters/issues/351))

## dbt-adapters 1.8.0 - October 29, 2024

### Fixes

- Always make behavior flags available for evaluation ([#338](https://github.com/dbt-labs/dbt-adapters/issues/338))

### Under the Hood

- Add adapter telemetry. ([#301](https://github.com/dbt-labs/dbt-adapters/issues/301))

## dbt-adapters 1.7.2 - October 21, 2024

### Breaking Changes

- Drop support for Python 3.8 ([#332](https://github.com/dbt-labs/dbt-adapters/issues/332))

### Features

- Allows unique_key for snapshots to take a list ([#181](https://github.com/dbt-labs/dbt-adapters/issues/181))

### Fixes

- Always validate an incremental model's `incremental_strategy` ([#330](https://github.com/dbt-labs/dbt-adapters/issues/330))

### Contributors
- [@agpapa](https://github.com/agpapa) ([#181](https://github.com/dbt-labs/dbt-adapters/issues/181))

## dbt-adapters 1.7.1 - October 15, 2024

### Features

- Enable setting current value of dbt_valid_to ([#320](https://github.com/dbt-labs/dbt-adapters/issues/320))

## dbt-adapters 1.7.0 - September 19, 2024

### Features

- Allow configuring of snapshot column names ([#289](https://github.com/dbt-labs/dbt-adapters/issues/289))

## dbt-adapters 1.6.1 - September 16, 2024

## dbt-adapters 1.6.0 - September 12, 2024

### Features

- Default microbatch strategy implementation and base tests ([#302](https://github.com/dbt-labs/dbt-adapters/issues/302))

## dbt-adapters 1.5.0 - September 10, 2024

### Features

- Compare 'snapshot_get_time' and snapshot 'updated_at' data types ([#242](https://github.com/dbt-labs/dbt-adapters/issues/242))
- Add Behavior Flag framework ([#281](https://github.com/dbt-labs/dbt-adapters/issues/281))
- Add EventTimeFilter to BaseRelation, which renders a filtered relation when start or end is set ([#294](https://github.com/dbt-labs/dbt-adapters/issues/294))

### Dependencies

- Update dbt-common pin to >=1.8 ([#299](https://github.com/dbt-labs/dbt-adapters/pull/299))

## dbt-adapters 1.4.1 - August 09, 2024

### Fixes

- Use model alias for the CTE identifier generated during ephemeral materialization ([#5273](https://github.com/dbt-labs/dbt-adapters/issues/5273))

### Under the Hood

- Updating changie.yaml to add contributors and PR links ([#219](https://github.com/dbt-labs/dbt-adapters/issues/219))

### Contributors
- [@jeancochrane](https://github.com/jeancochrane) ([#5273](https://github.com/dbt-labs/dbt-adapters/issues/5273))
- [@leahwicz](https://github.com/leahwicz) ([#219](https://github.com/dbt-labs/dbt-adapters/issues/219))

## dbt-adapters 1.4.0 - July 30, 2024

### Features

- render 'to' and 'to_columns' fields on foreign key constraints, and bump dbt-common lower bound to 1.6 ([#271](https://github.com/dbt-labs/dbt-adapters/issues/271))

### Fixes

- Incremental table varchar column definition changed ([#276](https://github.com/dbt-labs/dbt-adapters/issues/276))

### Under the Hood

- Rework record/replay to record at the database connection level. ([#244](https://github.com/dbt-labs/dbt-adapters/issues/244))

## dbt-adapters 1.3.3 - July 09, 2024

### Fixes

* Fix scenario where using the `--empty` flag causes metadata queries to contain limit clauses ([#213](https://github.com/dbt-labs/dbt-adapters/issues/213))

### Under the Hood

* --limit flag no longer subshells the query. This resolves the dbt Cloud experience issue where limit prevents ordering elements.. ([#207](https://github.com/dbt-labs/dbt-adapters/issues/207))

## dbt-adapters 1.3.2 - July 02, 2024

### Under the Hood

* Fix query timer resolution ([#246](https://github.com/dbt-labs/dbt-adapters/issues/246))
* Add optional release_connection parameter to connection_named method ([#247](https://github.com/dbt-labs/dbt-adapters/issues/247))

## dbt-adapters 1.3.1 - June 20, 2024

## dbt-adapters 1.3.0 - June 18, 2024

### Features

* Add get_catalog_for_single_relation macro and capability to enable adapters to optimize catalog generation ([#231](https://github.com/dbt-labs/dbt-adapters/issues/231))

## dbt-adapters 1.2.1 - May 21, 2024

### Features

* Improvement of the compile error message in the get_fixture-sql.sql when the relation or the model not exist ([#203](https://github.com/dbt-labs/dbt-adapters/issues/203))
* Cross-database `date` macro ([#191](https://github.com/dbt-labs/dbt-adapters/issues/191))

### Fixes

* Update Clone test to reflect core change removing `deferred` attribute from nodes ([#194](https://github.com/dbt-labs/dbt-adapters/issues/194))

### Under the Hood

* Add query recording for adapters which use SQLConnectionManager ([#195](https://github.com/dbt-labs/dbt-adapters/issues/195))
* Improve memory efficiency of process_results() ([#217](https://github.com/dbt-labs/dbt-adapters/issues/217))

## dbt-adapters 1.1.1 - May 07, 2024

### Features

* Enable serialization contexts ([#197](https://github.com/dbt-labs/dbt-adapters/issues/197))

## dbt-adapters 1.1.0 - May 01, 2024

### Features

* Debug log when `type_code` fails to convert to a `data_type` ([#135](https://github.com/dbt-labs/dbt-adapters/issues/135))
* Introduce TableLastModifiedMetadataBatch and implement BaseAdapter.calculate_freshness_from_metadata_batch ([#127](https://github.com/dbt-labs/dbt-adapters/issues/127))
* Support for sql fixtures in unit testing ([#146](https://github.com/dbt-labs/dbt-adapters/issues/146))
* Cross-database `cast` macro ([#173](https://github.com/dbt-labs/dbt-adapters/issues/173))
* Allow adapters to opt out of aliasing the subquery generated by render_limited ([#179](https://github.com/dbt-labs/dbt-adapters/issues/179))
* subquery alias generated by render_limited now includes the relation name to mitigate duplicate aliasing ([#179](https://github.com/dbt-labs/dbt-adapters/issues/179))

### Fixes

* Fix adapter-specific cast handling for constraint enforcement ([#165](https://github.com/dbt-labs/dbt-adapters/issues/165))

### Docs

* Use `dbt-adapters` throughout the contributing guide ([#137](https://github.com/dbt-labs/dbt-adapters/issues/137))

### Under the Hood

* Add the option to set the log level of the AdapterRegistered event ([#141](https://github.com/dbt-labs/dbt-adapters/issues/141))
* Update dependabot config to cover GHA ([#161](https://github.com/dbt-labs/dbt-adapters/issues/161))
* Validate that dbt-core and dbt-adapters remain de-coupled ([#174](https://github.com/dbt-labs/dbt-adapters/issues/174))
* remove dbt_version from query comment test fixture ([#184](https://github.com/dbt-labs/dbt-adapters/issues/184))

### Dependencies

* add support for py3.12 ([#185](https://github.com/dbt-labs/dbt-adapters/issues/185))

## dbt-adapters 1.0.0 - April 01, 2024

### Features

* Update RelationConfig to capture all fields used by adapters ([#30](https://github.com/dbt-labs/dbt-adapters/issues/30))

### Fixes

* Add field wrapper to BaseRelation members that were missing it. ([#108](https://github.com/dbt-labs/dbt-adapters/issues/108))
* Add "description" and "meta" fields to RelationConfig protocol ([#119](https://github.com/dbt-labs/dbt-adapters/issues/119))
* Ignore adapter-level support warnings for 'custom' constraints ([#90](https://github.com/dbt-labs/dbt-adapters/issues/90))
* Make all adapter zone tests importable by removing "Test" prefix ([#93](https://github.com/dbt-labs/dbt-adapters/issues/93))

### Docs

* Configure `changie` ([#16](https://github.com/dbt-labs/dbt-adapters/issues/16))
* Setup ADR tracking framework ([#11](https://github.com/dbt-labs/dbt-adapters/issues/11))
* Create issue templates ([#12](https://github.com/dbt-labs/dbt-adapters/issues/12))
* Create PR template ([#13](https://github.com/dbt-labs/dbt-adapters/issues/13))

### Under the Hood

* Lazy load agate to improve dbt-core performance ([#125](https://github.com/dbt-labs/dbt-adapters/issues/125))
* add BaseAdapater.MAX_SCHEMA_METADATA_RELATIONS ([#131](https://github.com/dbt-labs/dbt-adapters/issues/131))
* Configure `dependabot` ([#14](https://github.com/dbt-labs/dbt-adapters/issues/14))
* Implement unit testing in CI ([#22](https://github.com/dbt-labs/dbt-adapters/issues/22))
* Allow version to be specified in either __version__.py or __about__.py ([#44](https://github.com/dbt-labs/dbt-adapters/issues/44))
* Remove __init__.py file from dbt.tests ([#96](https://github.com/dbt-labs/dbt-adapters/issues/96))

### Security

* Pin `black>=24.3` in `pyproject.toml` ([#140](https://github.com/dbt-labs/dbt-adapters/issues/140))
