# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List
from typing_extensions import Literal

from .._models import BaseModel

__all__ = ["Chat", "Choice", "ChoiceMessage"]


class ChoiceMessage(BaseModel):
    content: str
    """The text content produced by the model.

    This field contains the actual output generated, reflecting the model's response
    to the input query or command.
    """

    role: Literal["user", "assistant", "system"]
    """
    Specifies the role associated with the content, indicating whether the message
    is from the 'assistant' or another defined role, helping to contextualize the
    output within the interaction flow.
    """


class Choice(BaseModel):
    finish_reason: Literal["stop", "length", "content_filter"]
    """Describes the condition under which the model ceased generating content.

    Common reasons include 'length' (reached the maximum output size), 'stop'
    (encountered a stop sequence), or 'content_filter' (harmful content filtered
    out).
    """

    message: ChoiceMessage


class Chat(BaseModel):
    id: str
    """A globally unique identifier (UUID) for the response generated by the API.

    This ID can be used to reference the specific operation or transaction within
    the system for tracking or debugging purposes.
    """

    choices: List[Choice]
    """
    An array of objects representing the different outcomes or results produced by
    the model based on the input provided.
    """

    created: int
    """The Unix timestamp (in seconds) when the response was created.

    This timestamp can be used to verify the timing of the response relative to
    other events or operations.
    """

    model: str
    """Identifies the specific model used to generate the response."""
