# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional

from .._models import BaseModel

__all__ = ["Completion", "Choice", "ChoiceLogProbs", "ChoiceLogProbsTopLogProb"]


class ChoiceLogProbsTopLogProb(BaseModel):
    additional_properties: Optional[float] = None
    """For any additional_properties properties in the top_log_probs object"""


class ChoiceLogProbs(BaseModel):
    text_offset: Optional[List[int]] = None
    """
    Positional indices of each token within the original input text, useful for
    analysis and mapping.
    """

    token_log_probs: Optional[List[float]] = None
    """
    Log probabilities for each token, indicating the likelihood of each token's
    occurrence.
    """

    tokens: Optional[List[str]] = None
    """An array of tokens that comprise the generated text."""

    top_log_probs: Optional[List[ChoiceLogProbsTopLogProb]] = None
    """
    An array of mappings for each token to its top log probabilities, showing
    detailed prediction probabilities.
    """


class Choice(BaseModel):
    text: str
    """
    The generated text output from the model, which forms the main content of the
    response.
    """

    log_probs: Optional[ChoiceLogProbs] = None


class Completion(BaseModel):
    choices: List[Choice]
    """
    A list of choices generated by the model, each containing the text of the
    completion and associated metadata such as log probabilities.
    """

    model: Optional[str] = None
    """
    The identifier of the model that was used to generate the responses in the
    'choices' array.
    """
