"""


Object Operators
****************

:func:`add`

:func:`add_named`

:func:`align`

:func:`anim_transforms_to_deltas`

:func:`armature_add`

:func:`assign_property_defaults`

:func:`bake`

:func:`bake_image`

:func:`camera_add`

:func:`collection_add`

:func:`collection_instance_add`

:func:`collection_link`

:func:`collection_objects_select`

:func:`collection_remove`

:func:`collection_unlink`

:func:`constraint_add`

:func:`constraint_add_with_targets`

:func:`constraints_clear`

:func:`constraints_copy`

:func:`convert`

:func:`convert_proxy_to_override`

:func:`correctivesmooth_bind`

:func:`data_instance_add`

:func:`data_transfer`

:func:`datalayout_transfer`

:func:`delete`

:func:`drop_named_image`

:func:`drop_named_material`

:func:`duplicate`

:func:`duplicate_move`

:func:`duplicate_move_linked`

:func:`duplicates_make_real`

:func:`editmode_toggle`

:func:`effector_add`

:func:`empty_add`

:func:`explode_refresh`

:func:`face_map_add`

:func:`face_map_assign`

:func:`face_map_deselect`

:func:`face_map_move`

:func:`face_map_remove`

:func:`face_map_remove_from`

:func:`face_map_select`

:func:`forcefield_toggle`

:func:`geometry_nodes_input_attribute_toggle`

:func:`gpencil_add`

:func:`gpencil_modifier_add`

:func:`gpencil_modifier_apply`

:func:`gpencil_modifier_copy`

:func:`gpencil_modifier_copy_to_selected`

:func:`gpencil_modifier_move_down`

:func:`gpencil_modifier_move_to_index`

:func:`gpencil_modifier_move_up`

:func:`gpencil_modifier_remove`

:func:`hair_add`

:func:`hide_collection`

:func:`hide_render_clear_all`

:func:`hide_view_clear`

:func:`hide_view_set`

:func:`hook_add_newob`

:func:`hook_add_selob`

:func:`hook_assign`

:func:`hook_recenter`

:func:`hook_remove`

:func:`hook_reset`

:func:`hook_select`

:func:`instance_offset_from_cursor`

:func:`isolate_type_render`

:func:`join`

:func:`join_shapes`

:func:`join_uvs`

:func:`laplaciandeform_bind`

:func:`light_add`

:func:`lightprobe_add`

:func:`lineart_bake_strokes`

:func:`lineart_bake_strokes_all`

:func:`lineart_clear`

:func:`lineart_clear_all`

:func:`link_to_collection`

:func:`load_background_image`

:func:`load_reference_image`

:func:`location_clear`

:func:`make_dupli_face`

:func:`make_links_data`

:func:`make_links_scene`

:func:`make_local`

:func:`make_override_library`

:func:`make_single_user`

:func:`material_slot_add`

:func:`material_slot_assign`

:func:`material_slot_copy`

:func:`material_slot_deselect`

:func:`material_slot_move`

:func:`material_slot_remove`

:func:`material_slot_remove_unused`

:func:`material_slot_select`

:func:`meshdeform_bind`

:func:`metaball_add`

:func:`mode_set`

:func:`mode_set_with_submode`

:func:`modifier_add`

:func:`modifier_apply`

:func:`modifier_apply_as_shapekey`

:func:`modifier_convert`

:func:`modifier_copy`

:func:`modifier_copy_to_selected`

:func:`modifier_move_down`

:func:`modifier_move_to_index`

:func:`modifier_move_up`

:func:`modifier_remove`

:func:`modifier_set_active`

:func:`move_to_collection`

:func:`multires_base_apply`

:func:`multires_external_pack`

:func:`multires_external_save`

:func:`multires_higher_levels_delete`

:func:`multires_rebuild_subdiv`

:func:`multires_reshape`

:func:`multires_subdivide`

:func:`multires_unsubdivide`

:func:`ocean_bake`

:func:`origin_clear`

:func:`origin_set`

:func:`parent_clear`

:func:`parent_no_inverse_set`

:func:`parent_set`

:func:`particle_system_add`

:func:`particle_system_remove`

:func:`paths_calculate`

:func:`paths_clear`

:func:`paths_range_update`

:func:`paths_update`

:func:`paths_update_visible`

:func:`pointcloud_add`

:func:`posemode_toggle`

:func:`quadriflow_remesh`

:func:`quick_explode`

:func:`quick_fur`

:func:`quick_liquid`

:func:`quick_smoke`

:func:`randomize_transform`

:func:`rotation_clear`

:func:`scale_clear`

:func:`select_all`

:func:`select_by_type`

:func:`select_camera`

:func:`select_grouped`

:func:`select_hierarchy`

:func:`select_less`

:func:`select_linked`

:func:`select_mirror`

:func:`select_more`

:func:`select_pattern`

:func:`select_random`

:func:`select_same_collection`

:func:`shade_flat`

:func:`shade_smooth`

:func:`shaderfx_add`

:func:`shaderfx_copy`

:func:`shaderfx_move_down`

:func:`shaderfx_move_to_index`

:func:`shaderfx_move_up`

:func:`shaderfx_remove`

:func:`shape_key_add`

:func:`shape_key_clear`

:func:`shape_key_mirror`

:func:`shape_key_move`

:func:`shape_key_remove`

:func:`shape_key_retime`

:func:`shape_key_transfer`

:func:`skin_armature_create`

:func:`skin_loose_mark_clear`

:func:`skin_radii_equalize`

:func:`skin_root_mark`

:func:`speaker_add`

:func:`subdivision_set`

:func:`surfacedeform_bind`

:func:`text_add`

:func:`track_clear`

:func:`track_set`

:func:`transfer_mode`

:func:`transform_apply`

:func:`transform_axis_target`

:func:`transform_to_mouse`

:func:`transforms_to_deltas`

:func:`unlink_data`

:func:`vertex_group_add`

:func:`vertex_group_assign`

:func:`vertex_group_assign_new`

:func:`vertex_group_clean`

:func:`vertex_group_copy`

:func:`vertex_group_copy_to_selected`

:func:`vertex_group_deselect`

:func:`vertex_group_fix`

:func:`vertex_group_invert`

:func:`vertex_group_levels`

:func:`vertex_group_limit_total`

:func:`vertex_group_lock`

:func:`vertex_group_mirror`

:func:`vertex_group_move`

:func:`vertex_group_normalize`

:func:`vertex_group_normalize_all`

:func:`vertex_group_quantize`

:func:`vertex_group_remove`

:func:`vertex_group_remove_from`

:func:`vertex_group_select`

:func:`vertex_group_set_active`

:func:`vertex_group_smooth`

:func:`vertex_group_sort`

:func:`vertex_parent_set`

:func:`vertex_weight_copy`

:func:`vertex_weight_delete`

:func:`vertex_weight_normalize_active_vertex`

:func:`vertex_weight_paste`

:func:`vertex_weight_set_active`

:func:`visual_transform_apply`

:func:`volume_add`

:func:`volume_import`

:func:`voxel_remesh`

:func:`voxel_size_edit`

"""

import typing

def add(radius: float = 1.0, type: str = 'EMPTY', enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an object to the scene

  """

  ...

def add_named(linked: bool = False, name: str = '', matrix: typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]] = ((0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0)), drop_x: int = 0, drop_y: int = 0) -> None:

  """

  Add named object

  """

  ...

def align(bb_quality: bool = True, align_mode: str = 'OPT_2', relative_to: str = 'OPT_4', align_axis: typing.Set[str] = {}) -> None:

  """

  Align objects

  """

  ...

def anim_transforms_to_deltas() -> None:

  """

  Convert object animation for normal transforms to delta transforms

  """

  ...

def armature_add(radius: float = 1.0, enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an armature object to the scene

  """

  ...

def assign_property_defaults(process_data: bool = True, process_bones: bool = True) -> None:

  """

  Assign the current values of custom properties as their defaults, for use as part of the rest pose state in NLA track mixing

  """

  ...

def bake(type: str = 'COMBINED', pass_filter: typing.Set[str] = {}, filepath: str = '', width: int = 512, height: int = 512, margin: int = 16, use_selected_to_active: bool = False, max_ray_distance: float = 0.0, cage_extrusion: float = 0.0, cage_object: str = '', normal_space: str = 'TANGENT', normal_r: str = 'POS_X', normal_g: str = 'POS_Y', normal_b: str = 'POS_Z', target: str = 'IMAGE_TEXTURES', save_mode: str = 'INTERNAL', use_clear: bool = False, use_cage: bool = False, use_split_materials: bool = False, use_automatic_name: bool = False, uv_layer: str = '') -> None:

  """

  Bake image textures of selected objects

  """

  ...

def bake_image() -> None:

  """

  Bake image textures of selected objects

  """

  ...

def camera_add(enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a camera object to the scene

  """

  ...

def collection_add() -> None:

  """

  Add an object to a new collection

  """

  ...

def collection_instance_add(name: str = 'Collection', collection: str = '', align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), session_uuid: int = 0, drop_x: int = 0, drop_y: int = 0) -> None:

  """

  Add a collection instance

  """

  ...

def collection_link(collection: str = '') -> None:

  """

  Add an object to an existing collection

  """

  ...

def collection_objects_select() -> None:

  """

  Select all objects in collection

  """

  ...

def collection_remove() -> None:

  """

  Remove the active object from this collection

  """

  ...

def collection_unlink() -> None:

  """

  Unlink the collection from all objects

  """

  ...

def constraint_add(type: str = '') -> None:

  """

  Add a constraint to the active object

  """

  ...

def constraint_add_with_targets(type: str = '') -> None:

  """

  Add a constraint to the active object, with target (where applicable) set to the selected objects/bones

  """

  ...

def constraints_clear() -> None:

  """

  Clear all the constraints for the active object only

  """

  ...

def constraints_copy() -> None:

  """

  Copy constraints to other selected objects

  """

  ...

def convert(target: str = 'MESH', keep_original: bool = False, angle: float = 1.22173, thickness: int = 5, seams: bool = False, faces: bool = True, offset: float = 0.01) -> None:

  """

  Convert selected objects to another type

  """

  ...

def convert_proxy_to_override() -> None:

  """

  Convert a proxy to a local library override

  """

  ...

def correctivesmooth_bind(modifier: str = '') -> None:

  """

  Bind base pose in Corrective Smooth modifier

  """

  ...

def data_instance_add(name: str = 'Name', type: str = 'ACTION', align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), drop_x: int = 0, drop_y: int = 0) -> None:

  """

  Add an object data instance

  """

  ...

def data_transfer(use_reverse_transfer: bool = False, use_freeze: bool = False, data_type: str = '', use_create: bool = True, vert_mapping: str = 'NEAREST', edge_mapping: str = 'NEAREST', loop_mapping: str = 'NEAREST_POLYNOR', poly_mapping: str = 'NEAREST', use_auto_transform: bool = False, use_object_transform: bool = True, use_max_distance: bool = False, max_distance: float = 1.0, ray_radius: float = 0.0, islands_precision: float = 0.1, layers_select_src: str = 'ACTIVE', layers_select_dst: str = 'ACTIVE', mix_mode: str = 'REPLACE', mix_factor: float = 1.0) -> None:

  """

  Transfer data layer(s) (weights, edge sharp, etc.) from active to selected meshes

  """

  ...

def datalayout_transfer(modifier: str = '', data_type: str = '', use_delete: bool = False, layers_select_src: str = 'ACTIVE', layers_select_dst: str = 'ACTIVE') -> None:

  """

  Transfer layout of data layer(s) from active to selected meshes

  """

  ...

def delete(use_global: bool = False, confirm: bool = True) -> None:

  """

  Delete selected objects

  """

  ...

def drop_named_image(filepath: str = '', relative_path: bool = True, name: str = '', align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an empty image type to scene with data

  """

  ...

def drop_named_material(name: str = 'Material') -> None:

  """

  Undocumented, consider `contributing <https://developer.blender.org/T51061>`_.

  """

  ...

def duplicate(linked: bool = False, mode: str = 'TRANSLATION') -> None:

  """

  Duplicate selected objects

  """

  ...

def duplicate_move(OBJECT_OT_duplicate: OBJECT_OT_duplicate = None, TRANSFORM_OT_translate: TRANSFORM_OT_translate = None) -> None:

  """

  Duplicate selected objects and move them

  """

  ...

def duplicate_move_linked(OBJECT_OT_duplicate: OBJECT_OT_duplicate = None, TRANSFORM_OT_translate: TRANSFORM_OT_translate = None) -> None:

  """

  Duplicate selected objects and move them

  """

  ...

def duplicates_make_real(use_base_parent: bool = False, use_hierarchy: bool = False) -> None:

  """

  Make instanced objects attached to this object real

  """

  ...

def editmode_toggle() -> None:

  """

  Toggle object's edit mode

  """

  ...

def effector_add(type: str = 'FORCE', radius: float = 1.0, enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an empty object with a physics effector to the scene

  """

  ...

def empty_add(type: str = 'PLAIN_AXES', radius: float = 1.0, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an empty object to the scene

  """

  ...

def explode_refresh(modifier: str = '') -> None:

  """

  Refresh data in the Explode modifier

  """

  ...

def face_map_add() -> None:

  """

  Add a new face map to the active object

  """

  ...

def face_map_assign() -> None:

  """

  Assign faces to a face map

  """

  ...

def face_map_deselect() -> None:

  """

  Deselect faces belonging to a face map

  """

  ...

def face_map_move(direction: str = 'UP') -> None:

  """

  Move the active face map up/down in the list

  """

  ...

def face_map_remove() -> None:

  """

  Remove a face map from the active object

  """

  ...

def face_map_remove_from() -> None:

  """

  Remove faces from a face map

  """

  ...

def face_map_select() -> None:

  """

  Select faces belonging to a face map

  """

  ...

def forcefield_toggle() -> None:

  """

  Toggle object's force field

  """

  ...

def geometry_nodes_input_attribute_toggle(prop_path: str = '', modifier_name: str = '') -> None:

  """

  Switch between an attribute and a single value to define the data for every element

  """

  ...

def gpencil_add(radius: float = 1.0, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), type: str = 'EMPTY', use_in_front: bool = True, stroke_depth_offset: float = 0.05, use_lights: bool = False, stroke_depth_order: str = '3D') -> None:

  """

  Add a Grease Pencil object to the scene

  """

  ...

def gpencil_modifier_add(type: str = 'CURVE') -> None:

  """

  Add a procedural operation/effect to the active grease pencil object

  """

  ...

def gpencil_modifier_apply(apply_as: str = 'DATA', modifier: str = '', report: bool = False) -> None:

  """

  Apply modifier and remove from the stack

  """

  ...

def gpencil_modifier_copy(modifier: str = '') -> None:

  """

  Duplicate modifier at the same position in the stack

  """

  ...

def gpencil_modifier_copy_to_selected(modifier: str = '') -> None:

  """

  Copy the modifier from the active object to all selected objects

  """

  ...

def gpencil_modifier_move_down(modifier: str = '') -> None:

  """

  Move modifier down in the stack

  """

  ...

def gpencil_modifier_move_to_index(modifier: str = '', index: int = 0) -> None:

  """

  Change the modifier's position in the list so it evaluates after the set number of others

  """

  ...

def gpencil_modifier_move_up(modifier: str = '') -> None:

  """

  Move modifier up in the stack

  """

  ...

def gpencil_modifier_remove(modifier: str = '', report: bool = False) -> None:

  """

  Remove a modifier from the active grease pencil object

  """

  ...

def hair_add(align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a hair object to the scene

  """

  ...

def hide_collection(collection_index: int = -1, toggle: bool = False) -> None:

  """

  Show only objects in collection (Shift to extend)

  """

  ...

def hide_render_clear_all() -> None:

  """

  Reveal all render objects by setting the hide render flag

  """

  ...

def hide_view_clear(select: bool = True) -> None:

  """

  Reveal temporarily hidden objects

  """

  ...

def hide_view_set(unselected: bool = False) -> None:

  """

  Temporarily hide objects from the viewport

  """

  ...

def hook_add_newob() -> None:

  """

  Hook selected vertices to a newly created object

  """

  ...

def hook_add_selob(use_bone: bool = False) -> None:

  """

  Hook selected vertices to the first selected object

  """

  ...

def hook_assign(modifier: str = '') -> None:

  """

  Assign the selected vertices to a hook

  """

  ...

def hook_recenter(modifier: str = '') -> None:

  """

  Set hook center to cursor position

  """

  ...

def hook_remove(modifier: str = '') -> None:

  """

  Remove a hook from the active object

  """

  ...

def hook_reset(modifier: str = '') -> None:

  """

  Recalculate and clear offset transformation

  """

  ...

def hook_select(modifier: str = '') -> None:

  """

  Select affected vertices on mesh

  """

  ...

def instance_offset_from_cursor() -> None:

  """

  Set offset used for collection instances based on cursor position

  """

  ...

def isolate_type_render() -> None:

  """

  Hide unselected render objects of same type as active by setting the hide render flag

  """

  ...

def join() -> None:

  """

  Join selected objects into active object

  """

  ...

def join_shapes() -> None:

  """

  Copy the current resulting shape of another selected object to this one

  """

  ...

def join_uvs() -> None:

  """

  Transfer UV Maps from active to selected objects (needs matching geometry)

  """

  ...

def laplaciandeform_bind(modifier: str = '') -> None:

  """

  Bind mesh to system in laplacian deform modifier

  """

  ...

def light_add(type: str = 'POINT', radius: float = 1.0, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a light object to the scene

  """

  ...

def lightprobe_add(type: str = 'CUBEMAP', radius: float = 1.0, enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a light probe object

  """

  ...

def lineart_bake_strokes() -> None:

  """

  Bake Line Art for current GPencil object

  """

  ...

def lineart_bake_strokes_all() -> None:

  """

  Bake all Grease Pencil objects that have a line art modifier

  """

  ...

def lineart_clear() -> None:

  """

  Clear all strokes in current GPencil object

  """

  ...

def lineart_clear_all() -> None:

  """

  Clear all strokes in all Grease Pencil objects that have a line art modifier

  """

  ...

def link_to_collection(collection_index: int = -1, is_new: bool = False, new_collection_name: str = '') -> None:

  """

  Link objects to a collection

  """

  ...

def load_background_image(filepath: str = '', filter_image: bool = True, filter_folder: bool = True, view_align: bool = True) -> None:

  """

  Add a reference image into the background behind objects

  """

  ...

def load_reference_image(filepath: str = '', filter_image: bool = True, filter_folder: bool = True, view_align: bool = True) -> None:

  """

  Add a reference image into the scene between objects

  """

  ...

def location_clear(clear_delta: bool = False) -> None:

  """

  Clear the object's location

  """

  ...

def make_dupli_face() -> None:

  """

  Convert objects into instanced faces

  """

  ...

def make_links_data(type: str = 'OBDATA') -> None:

  """

  Transfer data from active object to selected objects

  """

  ...

def make_links_scene(scene: str = '') -> None:

  """

  Link selection to another scene

  """

  ...

def make_local(type: str = 'SELECT_OBJECT') -> None:

  """

  Make library linked data-blocks local to this file

  """

  ...

def make_override_library(collection: str = 'DEFAULT') -> None:

  """

  Make a local override of this library linked data-block

  """

  ...

def make_single_user(type: str = 'SELECTED_OBJECTS', object: bool = False, obdata: bool = False, material: bool = False, animation: bool = False, obdata_animation: bool = False) -> None:

  """

  Make linked data local to each object

  """

  ...

def material_slot_add() -> None:

  """

  Add a new material slot

  """

  ...

def material_slot_assign() -> None:

  """

  Assign active material slot to selection

  """

  ...

def material_slot_copy() -> None:

  """

  Copy material to selected objects

  """

  ...

def material_slot_deselect() -> None:

  """

  Deselect by active material slot

  """

  ...

def material_slot_move(direction: str = 'UP') -> None:

  """

  Move the active material up/down in the list

  """

  ...

def material_slot_remove() -> None:

  """

  Remove the selected material slot

  """

  ...

def material_slot_remove_unused() -> None:

  """

  Remove unused material slots

  """

  ...

def material_slot_select() -> None:

  """

  Select by active material slot

  """

  ...

def meshdeform_bind(modifier: str = '') -> None:

  """

  Bind mesh to cage in mesh deform modifier

  """

  ...

def metaball_add(type: str = 'BALL', radius: float = 2.0, enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add an metaball object to the scene

  """

  ...

def mode_set(mode: str = 'OBJECT', toggle: bool = False) -> None:

  """

  Sets the object interaction mode

  """

  ...

def mode_set_with_submode(mode: str = 'OBJECT', toggle: bool = False, mesh_select_mode: typing.Set[str] = {}) -> None:

  """

  Sets the object interaction mode

  """

  ...

def modifier_add(type: str = 'SUBSURF') -> None:

  """

  Add a procedural operation/effect to the active object

  """

  ...

def modifier_apply(modifier: str = '', report: bool = False) -> None:

  """

  Apply modifier and remove from the stack

  """

  ...

def modifier_apply_as_shapekey(keep_modifier: bool = False, modifier: str = '', report: bool = False) -> None:

  """

  Apply modifier as a new shape key and remove from the stack

  """

  ...

def modifier_convert(modifier: str = '') -> None:

  """

  Convert particles to a mesh object

  """

  ...

def modifier_copy(modifier: str = '') -> None:

  """

  Duplicate modifier at the same position in the stack

  """

  ...

def modifier_copy_to_selected(modifier: str = '') -> None:

  """

  Copy the modifier from the active object to all selected objects

  """

  ...

def modifier_move_down(modifier: str = '') -> None:

  """

  Move modifier down in the stack

  """

  ...

def modifier_move_to_index(modifier: str = '', index: int = 0) -> None:

  """

  Change the modifier's index in the stack so it evaluates after the set number of others

  """

  ...

def modifier_move_up(modifier: str = '') -> None:

  """

  Move modifier up in the stack

  """

  ...

def modifier_remove(modifier: str = '', report: bool = False) -> None:

  """

  Remove a modifier from the active object

  """

  ...

def modifier_set_active(modifier: str = '') -> None:

  """

  Activate the modifier to use as the context

  """

  ...

def move_to_collection(collection_index: int = -1, is_new: bool = False, new_collection_name: str = '') -> None:

  """

  Move objects to a collection

  """

  ...

def multires_base_apply(modifier: str = '') -> None:

  """

  Modify the base mesh to conform to the displaced mesh

  """

  ...

def multires_external_pack() -> None:

  """

  Pack displacements from an external file

  """

  ...

def multires_external_save(filepath: str = '', hide_props_region: bool = True, check_existing: bool = True, filter_blender: bool = False, filter_backup: bool = False, filter_image: bool = False, filter_movie: bool = False, filter_python: bool = False, filter_font: bool = False, filter_sound: bool = False, filter_text: bool = False, filter_archive: bool = False, filter_btx: bool = True, filter_collada: bool = False, filter_alembic: bool = False, filter_usd: bool = False, filter_volume: bool = False, filter_folder: bool = True, filter_blenlib: bool = False, filemode: int = 9, relative_path: bool = True, display_type: str = 'DEFAULT', sort_method: str = '', modifier: str = '') -> None:

  """

  Save displacements to an external file

  """

  ...

def multires_higher_levels_delete(modifier: str = '') -> None:

  """

  Deletes the higher resolution mesh, potential loss of detail

  """

  ...

def multires_rebuild_subdiv(modifier: str = '') -> None:

  """

  Rebuilds all possible subdivisions levels to generate a lower resolution base mesh

  """

  ...

def multires_reshape(modifier: str = '') -> None:

  """

  Copy vertex coordinates from other object

  """

  ...

def multires_subdivide(modifier: str = '', mode: str = 'CATMULL_CLARK') -> None:

  """

  Add a new level of subdivision

  """

  ...

def multires_unsubdivide(modifier: str = '') -> None:

  """

  Rebuild a lower subdivision level of the current base mesh

  """

  ...

def ocean_bake(modifier: str = '', free: bool = False) -> None:

  """

  Bake an image sequence of ocean data

  """

  ...

def origin_clear() -> None:

  """

  Clear the object's origin

  """

  ...

def origin_set(type: str = 'GEOMETRY_ORIGIN', center: str = 'MEDIAN') -> None:

  """

  Set the object's origin, by either moving the data, or set to center of data, or use 3D cursor

  """

  ...

def parent_clear(type: str = 'CLEAR') -> None:

  """

  Clear the object's parenting

  """

  ...

def parent_no_inverse_set() -> None:

  """

  Set the object's parenting without setting the inverse parent correction

  """

  ...

def parent_set(type: str = 'OBJECT', xmirror: bool = False, keep_transform: bool = False) -> None:

  """

  Set the object's parenting

  """

  ...

def particle_system_add() -> None:

  """

  Add a particle system

  """

  ...

def particle_system_remove() -> None:

  """

  Remove the selected particle system

  """

  ...

def paths_calculate(start_frame: int = 1, end_frame: int = 250) -> None:

  """

  Calculate motion paths for the selected objects

  """

  ...

def paths_clear(only_selected: bool = False) -> None:

  """

  Clear path caches for all objects, hold Shift key for selected objects only

  """

  ...

def paths_range_update() -> None:

  """

  Update frame range for motion paths from the Scene's current frame range

  """

  ...

def paths_update() -> None:

  """

  Recalculate motion paths for selected objects

  """

  ...

def paths_update_visible() -> None:

  """

  Recalculate all visible motion paths for objects and poses

  """

  ...

def pointcloud_add(align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a point cloud object to the scene

  """

  ...

def posemode_toggle() -> None:

  """

  Enable or disable posing/selecting bones

  """

  ...

def quadriflow_remesh(use_mesh_symmetry: bool = True, use_preserve_sharp: bool = False, use_preserve_boundary: bool = False, preserve_paint_mask: bool = False, smooth_normals: bool = False, mode: str = 'FACES', target_ratio: float = 1.0, target_edge_length: float = 0.1, target_faces: int = 4000, mesh_area: float = -1, seed: int = 0) -> None:

  """

  Create a new quad based mesh using the surface data of the current mesh. All data layers will be lost

  """

  ...

def quick_explode(style: str = 'EXPLODE', amount: int = 100, frame_duration: int = 50, frame_start: int = 1, frame_end: int = 10, velocity: float = 1.0, fade: bool = True) -> None:

  """

  Make selected objects explode

  """

  ...

def quick_fur(density: str = 'MEDIUM', view_percentage: int = 10, length: float = 0.1) -> None:

  """

  Add fur setup to the selected objects

  """

  ...

def quick_liquid(show_flows: bool = False) -> None:

  """

  Make selected objects liquid

  """

  ...

def quick_smoke(style: str = 'SMOKE', show_flows: bool = False) -> None:

  """

  Use selected objects as smoke emitters

  """

  ...

def randomize_transform(random_seed: int = 0, use_delta: bool = False, use_loc: bool = True, loc: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), use_rot: bool = True, rot: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), use_scale: bool = True, scale_even: bool = False, scale: typing.Tuple[float, float, float] = (1.0, 1.0, 1.0)) -> None:

  """

  Randomize objects location, rotation, and scale

  """

  ...

def rotation_clear(clear_delta: bool = False) -> None:

  """

  Clear the object's rotation

  """

  ...

def scale_clear(clear_delta: bool = False) -> None:

  """

  Clear the object's scale

  """

  ...

def select_all(action: str = 'TOGGLE') -> None:

  """

  Change selection of all visible objects in scene

  """

  ...

def select_by_type(extend: bool = False, type: str = 'MESH') -> None:

  """

  Select all visible objects that are of a type

  """

  ...

def select_camera(extend: bool = False) -> None:

  """

  Select the active camera

  """

  ...

def select_grouped(extend: bool = False, type: str = 'CHILDREN_RECURSIVE') -> None:

  """

  Select all visible objects grouped by various properties

  """

  ...

def select_hierarchy(direction: str = 'PARENT', extend: bool = False) -> None:

  """

  Select object relative to the active object's position in the hierarchy

  """

  ...

def select_less() -> None:

  """

  Deselect objects at the boundaries of parent/child relationships

  """

  ...

def select_linked(extend: bool = False, type: str = 'OBDATA') -> None:

  """

  Select all visible objects that are linked

  """

  ...

def select_mirror(extend: bool = False) -> None:

  """

  Select the mirror objects of the selected object e.g. "L.sword" and "R.sword"

  """

  ...

def select_more() -> None:

  """

  Select connected parent/child objects

  """

  ...

def select_pattern(pattern: str = '*args', case_sensitive: bool = False, extend: bool = True) -> None:

  """

  Select objects matching a naming pattern

  """

  ...

def select_random(ratio: float = 0.5, seed: int = 0, action: str = 'SELECT') -> None:

  """

  Set select on random visible objects

  """

  ...

def select_same_collection(collection: str = '') -> None:

  """

  Select object in the same collection

  """

  ...

def shade_flat() -> None:

  """

  Render and display faces uniform, using Face Normals

  """

  ...

def shade_smooth() -> None:

  """

  Render and display faces smooth, using interpolated Vertex Normals

  """

  ...

def shaderfx_add(type: str = 'FX_BLUR') -> None:

  """

  Add a visual effect to the active object

  """

  ...

def shaderfx_copy(shaderfx: str = '') -> None:

  """

  Duplicate effect at the same position in the stack

  """

  ...

def shaderfx_move_down(shaderfx: str = '') -> None:

  """

  Move effect down in the stack

  """

  ...

def shaderfx_move_to_index(shaderfx: str = '', index: int = 0) -> None:

  """

  Change the effect's position in the list so it evaluates after the set number of others

  """

  ...

def shaderfx_move_up(shaderfx: str = '') -> None:

  """

  Move effect up in the stack

  """

  ...

def shaderfx_remove(shaderfx: str = '', report: bool = False) -> None:

  """

  Remove a effect from the active grease pencil object

  """

  ...

def shape_key_add(from_mix: bool = True) -> None:

  """

  Add shape key to the object

  """

  ...

def shape_key_clear() -> None:

  """

  Clear weights for all shape keys

  """

  ...

def shape_key_mirror(use_topology: bool = False) -> None:

  """

  Mirror the current shape key along the local X axis

  """

  ...

def shape_key_move(type: str = 'TOP') -> None:

  """

  Move the active shape key up/down in the list

  """

  ...

def shape_key_remove(all: bool = False) -> None:

  """

  Remove shape key from the object

  """

  ...

def shape_key_retime() -> None:

  """

  Resets the timing for absolute shape keys

  """

  ...

def shape_key_transfer(mode: str = 'OFFSET', use_clamp: bool = False) -> None:

  """

  Copy the active shape key of another selected object to this one

  """

  ...

def skin_armature_create(modifier: str = '') -> None:

  """

  Create an armature that parallels the skin layout

  """

  ...

def skin_loose_mark_clear(action: str = 'MARK') -> None:

  """

  Mark/clear selected vertices as loose

  """

  ...

def skin_radii_equalize() -> None:

  """

  Make skin radii of selected vertices equal on each axis

  """

  ...

def skin_root_mark() -> None:

  """

  Mark selected vertices as roots

  """

  ...

def speaker_add(enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a speaker object to the scene

  """

  ...

def subdivision_set(level: int = 1, relative: bool = False) -> None:

  """

  Sets a Subdivision Surface level (1 to 5)

  """

  ...

def surfacedeform_bind(modifier: str = '') -> None:

  """

  Bind mesh to target in surface deform modifier

  """

  ...

def text_add(radius: float = 1.0, enter_editmode: bool = False, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a text object to the scene

  """

  ...

def track_clear(type: str = 'CLEAR') -> None:

  """

  Clear tracking constraint or flag from object

  """

  ...

def track_set(type: str = 'DAMPTRACK') -> None:

  """

  Make the object track another object, using various methods/constraints

  """

  ...

def transfer_mode(use_flash_on_transfer: bool = True) -> None:

  """

  Switches the active object and assigns the same mode to a new one under the mouse cursor, leaving the active mode in the current one

  """

  ...

def transform_apply(location: bool = True, rotation: bool = True, scale: bool = True, properties: bool = True) -> None:

  """

  Apply the object's transformation to its data

  """

  ...

def transform_axis_target() -> None:

  """

  Interactively point cameras and lights to a location (Ctrl translates)

  """

  ...

def transform_to_mouse(name: str = '', matrix: typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]] = ((0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0, 0.0)), drop_x: int = 0, drop_y: int = 0) -> None:

  """

  Snap selected item(s) to the mouse location

  """

  ...

def transforms_to_deltas(mode: str = 'ALL', reset_values: bool = True) -> None:

  """

  Convert normal object transforms to delta transforms, any existing delta transforms will be included as well

  """

  ...

def unlink_data() -> None:

  """

  Undocumented, consider `contributing <https://developer.blender.org/T51061>`_.

  """

  ...

def vertex_group_add() -> None:

  """

  Add a new vertex group to the active object

  """

  ...

def vertex_group_assign() -> None:

  """

  Assign the selected vertices to the active vertex group

  """

  ...

def vertex_group_assign_new() -> None:

  """

  Assign the selected vertices to a new vertex group

  """

  ...

def vertex_group_clean(group_select_mode: str = '', limit: float = 0.0, keep_single: bool = False) -> None:

  """

  Remove vertex group assignments which are not required

  """

  ...

def vertex_group_copy() -> None:

  """

  Make a copy of the active vertex group

  """

  ...

def vertex_group_copy_to_selected() -> None:

  """

  Replace vertex groups of selected objects by vertex groups of active object

  """

  ...

def vertex_group_deselect() -> None:

  """

  Deselect all selected vertices assigned to the active vertex group

  """

  ...

def vertex_group_fix(dist: float = 0.0, strength: float = 1.0, accuracy: float = 1.0) -> None:

  """

  Modify the position of selected vertices by changing only their respective groups' weights (this tool may be slow for many vertices)

  """

  ...

def vertex_group_invert(group_select_mode: str = '', auto_assign: bool = True, auto_remove: bool = True) -> None:

  """

  Invert active vertex group's weights

  """

  ...

def vertex_group_levels(group_select_mode: str = '', offset: float = 0.0, gain: float = 1.0) -> None:

  """

  Add some offset and multiply with some gain the weights of the active vertex group

  """

  ...

def vertex_group_limit_total(group_select_mode: str = '', limit: int = 4) -> None:

  """

  Limit deform weights associated with a vertex to a specified number by removing lowest weights

  """

  ...

def vertex_group_lock(action: str = 'TOGGLE', mask: str = 'ALL') -> None:

  """

  Change the lock state of all or some vertex groups of active object

  """

  ...

def vertex_group_mirror(mirror_weights: bool = True, flip_group_names: bool = True, all_groups: bool = False, use_topology: bool = False) -> None:

  """

  Mirror vertex group, flip weights and/or names, editing only selected vertices, flipping when both sides are selected otherwise copy from unselected

  """

  ...

def vertex_group_move(direction: str = 'UP') -> None:

  """

  Move the active vertex group up/down in the list

  """

  ...

def vertex_group_normalize() -> None:

  """

  Normalize weights of the active vertex group, so that the highest ones are now 1.0

  """

  ...

def vertex_group_normalize_all(group_select_mode: str = '', lock_active: bool = True) -> None:

  """

  Normalize all weights of all vertex groups, so that for each vertex, the sum of all weights is 1.0

  """

  ...

def vertex_group_quantize(group_select_mode: str = '', steps: int = 4) -> None:

  """

  Set weights to a fixed number of steps

  """

  ...

def vertex_group_remove(all: bool = False, all_unlocked: bool = False) -> None:

  """

  Delete the active or all vertex groups from the active object

  """

  ...

def vertex_group_remove_from(use_all_groups: bool = False, use_all_verts: bool = False) -> None:

  """

  Remove the selected vertices from active or all vertex group(s)

  """

  ...

def vertex_group_select() -> None:

  """

  Select all the vertices assigned to the active vertex group

  """

  ...

def vertex_group_set_active(group: str = '') -> None:

  """

  Set the active vertex group

  """

  ...

def vertex_group_smooth(group_select_mode: str = '', factor: float = 0.5, repeat: int = 1, expand: float = 0.0) -> None:

  """

  Smooth weights for selected vertices

  """

  ...

def vertex_group_sort(sort_type: str = 'NAME') -> None:

  """

  Sort vertex groups

  """

  ...

def vertex_parent_set() -> None:

  """

  Parent selected objects to the selected vertices

  """

  ...

def vertex_weight_copy() -> None:

  """

  Copy weights from active to selected

  """

  ...

def vertex_weight_delete(weight_group: int = -1) -> None:

  """

  Delete this weight from the vertex (disabled if vertex group is locked)

  """

  ...

def vertex_weight_normalize_active_vertex() -> None:

  """

  Normalize active vertex's weights

  """

  ...

def vertex_weight_paste(weight_group: int = -1) -> None:

  """

  Copy this group's weight to other selected vertices (disabled if vertex group is locked)

  """

  ...

def vertex_weight_set_active(weight_group: int = -1) -> None:

  """

  Set as active vertex group

  """

  ...

def visual_transform_apply() -> None:

  """

  Apply the object's visual transformation to its data

  """

  ...

def volume_add(align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Add a volume object to the scene

  """

  ...

def volume_import(filepath: str = '', directory: str = '', files: typing.Union[typing.Sequence[OperatorFileListElement], typing.Mapping[str, OperatorFileListElement], bpy.types.bpy_prop_collection] = None, hide_props_region: bool = True, filter_blender: bool = False, filter_backup: bool = False, filter_image: bool = False, filter_movie: bool = False, filter_python: bool = False, filter_font: bool = False, filter_sound: bool = False, filter_text: bool = False, filter_archive: bool = False, filter_btx: bool = False, filter_collada: bool = False, filter_alembic: bool = False, filter_usd: bool = False, filter_volume: bool = True, filter_folder: bool = True, filter_blenlib: bool = False, filemode: int = 9, relative_path: bool = True, display_type: str = 'DEFAULT', sort_method: str = '', use_sequence_detection: bool = True, align: str = 'WORLD', location: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), rotation: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0), scale: typing.Tuple[float, float, float] = (0.0, 0.0, 0.0)) -> None:

  """

  Import OpenVDB volume file

  """

  ...

def voxel_remesh() -> None:

  """

  Calculates a new manifold mesh based on the volume of the current mesh. All data layers will be lost

  """

  ...

def voxel_size_edit() -> None:

  """

  Modify the mesh voxel size interactively used in the voxel remesher

  """

  ...
