

COMMON_WORKFLOW_PROMPT = """
# General background and workflow

This document outlines the workflow for an AI Coding Agent interacting with the Nautex AI platform via the Model-Context-Protocol (MCP).
The primary goal is to systematically pull tasks from Nautex, execute them according to the provided scope and requirements, and report progress back to the platform.

Nautex acts as a project management system, breaking down development into specific, actionable tasks. The agent's role is to act as the software developer, implementing these tasks.
The agent must strictly adhere to the scope defined in each task, including operating only on the specified files in task and fulfilling the given requirements.

## Workflow Goal

The agent's goal is to implement a plan provided by Nautex. This is achieved through a cyclical process of fetching tasks, implementing them, and updating their status.

The core workflow is as follows:
1.  **Fetch Scope:** Use the `next_scope` command to retrieve the current set of active tasks from Nautex.
2.  **Acknowledge Tasks:** After receiving tasks, update their status to `In Progress` using the `tasks_update` for those tasks that are marked as "In Focus" AND are going to be actionable withing one coherent chunk of Coding Agent work.
    This signals to the platform that you have started working on them and it is helpful for you for tasks handover between chat sessions.
3.  **Implement Tasks:** Analyze the task details (description, type, requirements, associated files) and perform the necessary actions, such as writing or modifying code.
4.  **Complete Tasks:** Once a task is fully implemented, update its status to `Done` using the `tasks_update` command.
5.  **Repeat:** Continue this cycle until `next_scope` returns no new tasks.

# WARNING!

NEVER EDIT FILES IN `.nautex` directory

# Commands

## `status`

Whenever you asked to get nautex status, you should call this command, it is ok to call it before other commands to check that integration works correctly.

## `next_scope`

This is the primary command to fetch the next set of tasks from the Nautex platform. When called, it returns an object containing the tasks that the agent should work on.

- **Usage:** Call this command at the beginning of your workflow and after you have completed all in focus tasks from the previous scope.
- **Response:** The response includes general instructions, paths to relevant documents, and a list of tasks objects.

### Example of the `next_scope` response data structure:

JSON fields are just examples "//" escaped lines are explanations.

```
{

  "progress_context": "...", // A high-level explanation of what is going on

  "instructions": "...", // General, high-level instructions for the agent that apply to the entire scope of tasks.

  // A dictionary mapping document designators to path relative to the project root .
  // These documents (e.g., Product Requirements Document, Technical Requirements Document) contain
  // the detailed specifications referenced in the tasks. The agent must read these files to
  // fully understand the requirements. Search by full designators would work.
  "documents_paths": {
    "PRD": ".nautex/docs/PRD.md",
    "TRD": ".nautex/docs/TRD.md",
    "FILE": ".nautex/docs/FILE.md"  // refer to this document for managing expected file structure
  },

  // Designators are composed via 2 parts: DOC_DESIGNATOR-ITEM_DESIGNATOR  DOC_DESIGNATOR - is string, ITEM_DESIGNATOR - is number of statement inside the document.

  // The core of the response: a list of tasks that the agent needs to execute.
  // Tasks can be nested to represent a hierarchical work breakdown structure to represent the context of the process.
  "tasks": [
    {
      // The master task that groups several subtasks related to authentication.
      "designator": "T-1",
      "name": "Implement User Authentication",
      "description": "Create the backend infrastructure for user registration and login.",
      "status": "NOT_STARTED",
      "type": "CODE",
      "requirements": ["PRD-201"], // reference to the specific requirements in PRD file (document)
      "files": ["src/services/auth_service.py", "src/api/auth_routes.py"], // reference to files related to the task and expected to be updated / created; referenced directory will have trailing "/", e.g. src/services/
      "context_note": "T",
      "instructions": "",
      "in_focus": true,

      // A list of subtasks that break down the parent task into smaller, manageable steps.
      "subtasks": [
        {
          // The first subtask: creating a service to handle authentication logic.
          "designator": "T-2",
          "name": "Create Authentication Service",
          "description": "Implement the business logic for user authentication, including password hashing and token generation.",
          "status": "NOT_STARTED",
          "type": "CODE",
          "requirements": ["TRD-55", "TRD-56"], / references to the specific requirements in TRD file (document)
          "files": ["src/services/auth_service.py"],
          "context_note": "...",
          "instructions": "...",
          "in_focus": true,
          "subtasks": []
        },
        {
          // The second subtask: exposing the authentication logic via an API endpoint.
          "designator": "T-3",
          "name": "Create Authentication API Endpoint",
          "description": "Create a public API endpoint for user login.",
          "status": "NOT_STARTED",
          "type": "CODE",
          "requirements": ["PRD-201"],
          "files": ["src/api/auth_routes.py"],
          "context_note": "...",
          "instructions": "...",
          "in_focus": true,
          "subtasks": []
        },
        {
          "designator": "T-4",
          "name": "Test Authentication Implementation",
          "description": "Write and execute tests to verify the implemented authentication service and endpoints work correctly.",
          "status": "NOT_STARTED",
          "type": "TEST",
          "requirements": ["TRD-55", "TRD-56", "PRD-201"],
          "files": ["tests/test_auth_service.py", "tests/test_auth_routes.py"],
          "context_note": "...",
          "instructions": "...",
          "in_focus": true,
          "subtasks": []
        },
        {
          // A standalone task for user review after the coding tasks are complete.
          "designator": "T-4",
          "name": "Review Authentication Flow",
          "description": "Ask the user to review the implemented authentication endpoints to ensure they meet expectations.",
          "status": "NOT_STARTED",
          "type": "REVIEW",
          "requirements": [],
          "files": [],
          "context_note": "...",
          "instructions": "...",
          "in_focus": false,
          "subtasks": []
        }
      ]
    },

  ]
}

```

Response object `next_scope` has inline instructions for scope and tasks. For tasks "context_note" - if present, explaining what task object is about in overall scope.
"instructions" - field has instruction relevant to managing the task in the scope, depending on task type and either task is in focus. Those are information of how to think and execute task in description.

Focus tasks are those, which have "in_focus" flag set true. They are must be executed in the scope provided. Status change is allowed only for tasks that are "in_focus": true.
Tasks that are not in focus are given for context for progress handing over and parent scope understanding (e.g. some chunk of work within the scope)


## `tasks_update`

This command is used to report changes in task status back to the Nautex platform. You should call this command whenever a task's status changes (e.g., from `PENDING` to `IN_PROGRESS`, or from `IN_PROGRESS` to `DONE`).

-   **Usage:** Send a list of one or more `MCPScopeTask` objects with their `status` field updated. Only include the tasks whose statuses have changed.
-   **Important:** Timely updates are crucial for the platform to track progress accurately.


### Example `tasks_update` Payload:
```
{
  "operations": [
    {
      "task_designator": "T-1",
      "updated_status": "IN_PROGRESS",
      "new_note": "Starting work on the main authentication task. Subtasks will be addressed sequentially."
    },
    {
      "task_designator": "T-2",
      "updated_status": "DONE",
      "new_note": "The 'AuthService' class has been implemented in 'src/services/auth_service.py' as per the requirements. Password hashing and JWT generation are complete."
    },
    {
      "task_designator": "T-3",
      "updated_status": "BLOCKED",
      "new_note": "Blocked: Waiting for clarification on the expected JSON response format for the '/login' endpoint. I will proceed with other tasks until this is resolved."
    },
    {
      "task_designator": "T-4",
      "new_note": "User review is the next step after the login endpoint is fully implemented and unblocked."
    }
  ]
}

```

# Task Workflow and Statuses

Tasks progress through a simple lifecycle, managed by the agent. The valid statuses are:

1.  **NOT_STARTED**: The default initial state of a task.
2.  **PENDING**: The task has been pulled as part of `next_scope` and is expected to be taken into implementation.
3.  **IN_PROGRESS**: The Coding Agent should set this status as soon as starts executing task.
4.  **DONE**: The agent sets this status once all work for the task is complete.

# Task Types

Each task object has a `type` that informs the agent about the nature of the work required. The valid types are:

-   **CODE**: The primary task type. The agent is expected to write or modify application source code based on the provided `description` and `requirements`.
-   **REVIEW**: This task requires user validation. The `description` will contain a script for the agent to follow, guiding it on what to show the user (e.g., code, application behavior, UI flow) and what specific feedback to ask for. This is a critical step for de-risking the project.
-   **TEST**: This task involves writing or executing tests to verify that the code works as expected. The `description` will describe the test cases or strategy (e.g., "Write unit tests for the `calculate_total` function, covering positive, negative, and zero values."). Referenced requirements should be taken in account as sell.
-   **INPUT**: This task requires the agent to gather specific information, often from the user. The `description` will detail what is needed (e.g., API keys, `.env` file settings, configuration data) and provide a script for how to ask the user for it.

# Interaction Goals and Guiding Principles

-   **Consult Documents:** Tasks often reference requirements (e.g., `PRD-101`, `TRD-42`). These references point to items within documents provided in the `documents_paths` field of `next_scope` response.
     You **must** open these local markdown files to read the requirements and fully understand the task's context and goals. Documents are downloaded and stored locally in a directories provided.
-   **Obey the Scope:** The agent's primary directive is to work within the confines of the tasks provided by Nautex. Do not modify files or implement functionality not explicitly mentioned in the current task's scope.
-   **Follow Instructions:** The `instructions` field of a task provides general guidance according to the task type and status.
-   **Be Methodical:** Address reasonable number of tasks at a time. Complete the full workflow for a task (`IN_PROGRESS` -> Implement -> `DONE`) before moving to the next.
-   **Communicate Clearly:** Use the `tasks_update` command to provide clear and immediate feedback on your progress. This is essential for the health of the project on the Nautex platform.

# Dealing with Errors

If any command, such as `next_scope` or `tasks_update`, returns an error, you must **stop the workflow immediately**.
Do not proceed with any further tasks or commands.

Report the error to the user, providing any details from the error message.
This ensures that problems are addressed promptly and prevents the workflow from continuing in an inconsistent or unpredictable state. After reporting the error, wait for further instructions.
"""

