# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2018-07-10 16:37
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('serialbox', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='RandomizedRegion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True, db_index=True, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, unique=True, verbose_name='Readable Name')),
                ('machine_name', models.CharField(help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, unique=True, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('order', models.IntegerField(blank=True, help_text='The order in which this region will be consumed as numbers are issued from the pool overall', null=True, verbose_name='Order')),
                ('min', models.BigIntegerField(default=1, help_text='The minimum value in the randomized region.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Minimum')),
                ('max', models.BigIntegerField(default=9223372036854775807, help_text='The maximum value in the randomized region.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Maximum')),
                ('start', models.BigIntegerField(blank=True, help_text='The start number will fall somewhere in between the minimum and maximum numbers.  This number will be randomly selected by the system to assure the most randomized range possible', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Start Number')),
                ('current', models.BigIntegerField(blank=True, help_text='The current number represents the next number in the generator.  The current number is used by the system as a state variable that, along with the start, can be used to re-position the random number generator where it left off.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Current')),
                ('remaining', models.BigIntegerField(blank=True, help_text='The number of remaining serial numbers in this randomized region.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Remaining')),
                ('pool', models.ForeignKey(blank=True, help_text='The Number Pool this region will belong to.', null=True, on_delete=django.db.models.deletion.CASCADE, to='serialbox.Pool', verbose_name='Number Pool')),
            ],
            options={
                'verbose_name_plural': 'Randomized Regions',
                'verbose_name': 'Randomized Region',
            },
        ),
    ]
