/*
 * FFMPEG HDF5 filter
 *
 * Author: Bin Duan <bduan2@hawk.iit.edu>
 * Created: 2022
 *
 */

#ifndef FFMPEG_H5FILTER_H
#define FFMPEG_H5FILTER_H

#define H5Z_class_t_vers 2

#include "hdf5.h"

#define FFMPEG_H5FILTER 32030 /* filter id here */

#define PUSH_ERR(func, minor, str) \
    H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, H5E_ERR_CLS, H5E_PLINE, minor, str)

herr_t raise_ffmpeg_h5_error(const char *msg);

H5_DLLVAR H5Z_class_t ffmpeg_H5Filter[1];

/* ---- ffmpeg_register_h5filter ----
 *
 * Register the ffmpeg HDF5 filter within the HDF5 library.
 *
 * Important: Call this before using the ffmpeg HDF5 filter from C
 * unless dynamically loaded filters.
 *
 */
int ffmpeg_register_h5filter(void);

/* Define enums */
enum EncoderCodecEnum
{
    FFH5_ENC_MPEG4 = 0,
    FFH5_ENC_XVID = 1,
    FFH5_ENC_X264 = 2,
    FFH5_ENC_H264_NV = 3,
    FFH5_ENC_X265 = 4,
    FFH5_ENC_HEVC_NV = 5,
    FFH5_ENC_SVTAV1 = 6,
    FFH5_ENC_RAV1E = 7,
    FFH5_ENC_AV1_NV = 8,
    FFH5_ENC_AV1_QSV = 9,
};
enum DecoderCodecEnum
{
    FFH5_DEC_MPEG4 = 0,
    FFH5_DEC_H264 = 1,
    FFH5_DEC_H264_CUVID = 2,
    FFH5_DEC_HEVC = 3,
    FFH5_DEC_HEVC_CUVID = 4,
    FFH5_DEC_AOMAV1 = 5,
    FFH5_DEC_DAV1D = 6,
    FFH5_DEC_AV1_CUVID = 7,
    FFH5_DEC_AV1_QSV = 8,
};
enum PresetIDEnum
{
    /* no preset
     * means default preset is using depends on codecs
     */
    FFH5_PRESET_NONE = 0,
    /* libx264 */
    FFH5_PRESET_X264_ULTRAFAST = 10,
    FFH5_PRESET_X264_SUPERFAST = 11,
    FFH5_PRESET_X264_VERYFAST = 12,
    FFH5_PRESET_X264_FASTER = 13,
    FFH5_PRESET_X264_FAST = 14,
    FFH5_PRESET_X264_MEDIUM = 15,
    FFH5_PRESET_X264_SLOW = 16,
    FFH5_PRESET_X264_SLOWER = 17,
    FFH5_PRESET_X264_VERYSLOW = 18,
    /* h264_nvenc */
    FFH5_PRESET_H264NV_FASTEST = 100,
    FFH5_PRESET_H264NV_FASTER = 101,
    FFH5_PRESET_H264NV_FAST = 102,
    FFH5_PRESET_H264NV_MEDIUM = 103,
    FFH5_PRESET_H264NV_SLOW = 104,
    FFH5_PRESET_H264NV_SLOWER = 105,
    FFH5_PRESET_H264NV_SLOWEST = 106,
    /* x265 */
    FFH5_PRESET_X265_ULTRAFAST = 200,
    FFH5_PRESET_X265_SUPERFAST = 201,
    FFH5_PRESET_X265_VERYFAST = 202,
    FFH5_PRESET_X265_FASTER = 203,
    FFH5_PRESET_X265_FAST = 204,
    FFH5_PRESET_X265_MEDIUM = 205,
    FFH5_PRESET_X265_SLOW = 206,
    FFH5_PRESET_X265_SLOWER = 207,
    FFH5_PRESET_X265_VERYSLOW = 208,
    /* hevc_nvenc */
    FFH5_PRESET_HEVCNV_FASTEST = 300,
    FFH5_PRESET_HEVCNV_FASTER = 301,
    FFH5_PRESET_HEVCNV_FAST = 302,
    FFH5_PRESET_HEVCNV_MEDIUM = 303,
    FFH5_PRESET_HEVCNV_SLOW = 304,
    FFH5_PRESET_HEVCNV_SLOWER = 305,
    FFH5_PRESET_HEVCNV_SLOWEST = 306,
    /* svtav1 */
    FFH5_PRESET_SVTAV1_ULTRAFAST = 400,
    FFH5_PRESET_SVTAV1_SUPERFAST = 401,
    FFH5_PRESET_SVTAV1_VERYFAST = 402,
    FFH5_PRESET_SVTAV1_MUCHFASTER = 403,
    FFH5_PRESET_SVTAV1_FASTER = 404,
    FFH5_PRESET_SVTAV1_FAST = 405,
    FFH5_PRESET_SVTAV1_LESSFAST = 406,
    FFH5_PRESET_SVTAV1_MEDIUM = 407,
    FFH5_PRESET_SVTAV1_LESSSLOW = 408,
    FFH5_PRESET_SVTAV1_SLOW = 409,
    FFH5_PRESET_SVTAV1_SLOWER = 410,
    FFH5_PRESET_SVTAV1_MUCHSLOWER = 411,
    FFH5_PRESET_SVTAV1_VERYSLOW = 412,
    FFH5_PRESET_SVTAV1_SUPERSLOW = 413,
    /* rav1e */
    FFH5_PRESET_RAV1E_MUCHFASTER = 500,
    FFH5_PRESET_RAV1E_FASTER = 501,
    FFH5_PRESET_RAV1E_FAST = 502,
    FFH5_PRESET_RAV1E_LESSFAST = 503,
    FFH5_PRESET_RAV1E_MEDIUM = 504,
    FFH5_PRESET_RAV1E_LESSSLOW = 505,
    FFH5_PRESET_RAV1E_SLOW = 506,
    FFH5_PRESET_RAV1E_SLOWER = 507,
    FFH5_PRESET_RAV1E_MUCHSLOWER = 508,
    FFH5_PRESET_RAV1E_VERYSLOW = 509,
    FFH5_PRESET_RAV1E_SUPERSLOW = 510,
    /* av1_nvenc */
    FFH5_PRESET_AV1NV_FASTEST = 600,
    FFH5_PRESET_AV1NV_FASTER = 601,
    FFH5_PRESET_AV1NV_FAST = 602,
    FFH5_PRESET_AV1NV_MEDIUM = 603,
    FFH5_PRESET_AV1NV_SLOW = 604,
    FFH5_PRESET_AV1NV_SLOWER = 605,
    FFH5_PRESET_AV1NV_SLOWEST = 606,
    /* av1 intel qsv */
    FFH5_PRESET_AV1QSV_FASTEST = 700,
    FFH5_PRESET_AV1QSV_FASTER = 701,
    FFH5_PRESET_AV1QSV_FAST = 702,
    FFH5_PRESET_AV1QSV_MEDIUM = 703,
    FFH5_PRESET_AV1QSV_SLOW = 704,
    FFH5_PRESET_AV1QSV_SLOWER = 705,
    FFH5_PRESET_AV1QSV_SLOWEST = 706,
};
enum TuneTypeEnum
{
    /* no tune
     * means default tune is using depends on codecs
     */
    FFH5_TUNE_NONE = 0,
    /* libx264 */
    FFH5_TUNE_X264_PSNR = 10,
    FFH5_TUNE_X264_SSIM = 11,
    FFH5_TUNE_X264_GRAIN = 12,
    FFH5_TUNE_X264_FASTDECODE = 13,
    FFH5_TUNE_X264_ZEROLATENCY = 14,
    FFH5_TUNE_X264_ANIMATION = 15,
    FFH5_TUNE_X264_FILM = 16,
    FFH5_TUNE_X264_STILLIMAGE = 17,
    /* h264_nvenc */
    FFH5_TUNE_H264NV_HQ = 100,
    FFH5_TUNE_H264NV_LL = 101,
    FFH5_TUNE_H264NV_ULL = 102,
    FFH5_TUNE_H264NV_LOSSLESS = 103,
    /* x265 */
    FFH5_TUNE_X265_PSNR = 200,
    FFH5_TUNE_X265_SSIM = 201,
    FFH5_TUNE_X265_GRAIN = 202,
    FFH5_TUNE_X265_FASTDECODE = 203,
    FFH5_TUNE_X265_ZEROLATENCY = 204,
    FFH5_TUNE_X265_ANIMATION = 205,
    /* hevc_nvenc */
    FFH5_TUNE_HEVCNV_HQ = 300,
    FFH5_TUNE_HEVCNV_LL = 301,
    FFH5_TUNE_HEVCNV_ULL = 302,
    FFH5_TUNE_HEVCNV_LOSSLESS = 303,
    /* svtav1 */
    FFH5_TUNE_SVTAV1_VQ = 400,
    FFH5_TUNE_SVTAV1_PSNR = 401,
    FFH5_TUNE_SVTAV1_FASTDECODE = 402,
    /* rav1e */
    FFH5_TUNE_RAV1E_PSNR = 500,
    FFH5_TUNE_RAV1E_PSYCHOVISUAL = 501,
    /* av1_nvenc */
    FFH5_TUNE_AV1NV_HQ = 600,
    FFH5_TUNE_AV1NV_LL = 601,
    FFH5_TUNE_AV1NV_ULL = 602,
    FFH5_TUNE_AV1NV_LOSSLESS = 603,
    /* av1_qsv */
    FFH5_TUNE_AV1QSV_UNKNOWN = 700,
    FFH5_TUNE_AV1QSV_DISPLAYREMOTING = 701,
    FFH5_TUNE_AV1QSV_VIDEOCONFERENCE = 702,
    FFH5_TUNE_AV1QSV_ARCHIVE = 703,
    FFH5_TUNE_AV1QSV_LIVESTREAMING = 704,
    FFH5_TUNE_AV1QSV_CAMERACAPTURE = 705,
    FFH5_TUNE_AV1QSV_VIDEOSURVEILLANCE = 706,
    FFH5_TUNE_AV1QSV_GAMESTREAMING = 707,
    FFH5_TUNE_AV1QSV_REMOTEGAMING = 708,
};

#endif // FFMPEG_H5FILTER_H