#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Author: 钉钉或微信pythontesting 钉钉群21734177
# CreateDate: 2019-2-21

import collections

from bidict import bidict
from ganzhi import *

xingxius = {
    0: ("角", ""),
    1: ("亢", ""),
    2: ("氐", ""),
    3: ("房", ""),
    4: ("心", ""),
    5: ("尾", ""),
    6: ("箕", ""),
    7: ("斗", ""),
    8: ("牛", ""),
    9: ("女", ""),
    10: ("虚", ""),
    11: ("危", ""),
    12: ("室", ""),
    13: ("壁", ""),
    14: ("奎", ""),
    15: ("娄", ""),
    16: ("胃", ""),
    17: ("昴", ""),
    18: ("毕", ""),
    19: ("觜", ""),
    20: ("参", ""),
    21: ("井", ""),
    22: ("鬼", ""),
    23: ("柳", ""),
    24: ("星", ""),
    25: ("张", ""),
    26: ("翼", ""),
    27: ("轸", ""),
}

jianchus = {
    0: (
        "建",
        "气专而强，宜官府公事等。 宜：赴任、祈福、求嗣、求财、交涉、出行。 忌：上梁、嫁娶、安葬。",
    ),
    1: (
        "除",
        "除旧布新的日子。 宜：祭祀、祈福、嫁娶、出行、入宅、动土、开光、交易。 忌：嫁娶、探病。",
    ),
    2: ("满", "丰收之意。 宜：嫁娶、祈福、出行、安床、求财、裁衣、祭祀。 忌：造葬、赴任、求医。"),
    3: ("平", "普通的日子。 宜：修造、粉刷墙壁、修补。 忌：出行。"),
    4: ("定", "月令三合的日子。 宜：祭祀、祈福、嫁娶、造屋、求嗣、纳财。 忌：诉讼、出行、交涉。"),
    5: ("执", "守成之意。 宜：纳采、嫁娶、动土、入殓。 忌：入宅、开市。"),
    6: ("破", "日月相冲，曰大耗，诸事不宜。 宜：破屋坏垣 忌：不宜诸吉事。"),
    7: ("危", "吉事不取的日子。 宜：入殓、破土、火化、进塔、安葬。 忌：入宅嫁娶诸吉事。"),
    8: (
        "成",
        "月支的三合日，吉神的日子。 宜：结婚、开市、修造、动土、安床、破土、安葬、搬迁、交易、求财、出行、立契、竖柱、裁种、牧养。 忌：诉讼。",
    ),
    9: (
        "收",
        "收成、收获的日子。 宜：祈福、求嗣、赴任、嫁娶、安床、修造、动土、求学、开市、交易、买卖、立契。 忌：破土、安葬。",
    ),
    10: (
        "开",
        "重新开展的好日子。 宜：祭祀、祈福、开光、入宅、嫁娶、上任、修造、动土、开市、安床、交易、出行、竖柱。 忌：诉讼、安葬。",
    ),
    11: ("闭", "闭藏的日子 宜：安门、伐木、修造、动土。 忌：出行、嫁娶。"),
}


nayins = {
    ("甲", "子"): "海中金",
    ("乙", "丑"): "海中金",
    ("壬", "寅"): "金泊金",
    ("癸", "卯"): "金泊金",
    ("庚", "辰"): "白蜡金",
    ("辛", "巳"): "白蜡金",
    ("甲", "午"): "砂中金",
    ("乙", "未"): "砂中金",
    ("壬", "申"): "剑锋金",
    ("癸", "酉"): "剑锋金",
    ("庚", "戌"): "钗钏金",
    ("辛", "亥"): "钗钏金",
    ("戊", "子"): "霹雳火",
    ("己", "丑"): "霹雳火",
    ("丙", "寅"): "炉中火",
    ("丁", "卯"): "炉中火",
    ("甲", "辰"): "覆灯火",
    ("乙", "巳"): "覆灯火",
    ("戊", "午"): "天上火",
    ("己", "未"): "天上火",
    ("丙", "申"): "山下火",
    ("丁", "酉"): "山下火",
    ("甲", "戌"): "山头火",
    ("乙", "亥"): "山头火",
    ("壬", "子"): "桑柘木",
    ("癸", "丑"): "桑柘木",
    ("庚", "寅"): "松柏木",
    ("辛", "卯"): "松柏木",
    ("戊", "辰"): "大林木",
    ("己", "巳"): "大林木",
    ("壬", "午"): "杨柳木",
    ("癸", "未"): "杨柳木",
    ("庚", "申"): "石榴木",
    ("辛", "酉"): "石榴木",
    ("戊", "戌"): "平地木",
    ("己", "亥"): "平地木",
    ("庚", "子"): "壁上土",
    ("辛", "丑"): "壁上土",
    ("戊", "寅"): "城头土",
    ("己", "卯"): "城头土",
    ("丙", "辰"): "砂中土",
    ("丁", "巳"): "砂中土",
    ("庚", "午"): "路旁土",
    ("辛", "未"): "路旁土",
    ("戊", "申"): "大驿土",
    ("己", "酉"): "大驿土",
    ("丙", "戌"): "屋上土",
    ("丁", "亥"): "屋上土",
    ("丙", "子"): "涧下水",
    ("丁", "丑"): "涧下水",
    ("甲", "寅"): "大溪水",
    ("乙", "卯"): "大溪水",
    ("壬", "辰"): "长流水",
    ("癸", "巳"): "长流水",
    ("丙", "午"): "天河水",
    ("丁", "未"): "天河水",
    ("甲", "申"): "井泉水",
    ("乙", "酉"): "井泉水",
    ("壬", "戌"): "大海水",
    ("癸", "亥"): "大海水",
}

empties = {
    ("甲", "子"): ("戌", "亥"),
    ("乙", "丑"): ("戌", "亥"),
    ("丙", "寅"): ("戌", "亥"),
    ("丁", "卯"): ("戌", "亥"),
    ("戊", "辰"): ("戌", "亥"),
    ("己", "巳"): ("戌", "亥"),
    ("庚", "午"): ("戌", "亥"),
    ("辛", "未"): ("戌", "亥"),
    ("壬", "申"): ("戌", "亥"),
    ("癸", "酉"): ("戌", "亥"),
    ("甲", "戌"): ("申", "酉"),
    ("乙", "亥"): ("申", "酉"),
    ("丙", "子"): ("申", "酉"),
    ("丁", "丑"): ("申", "酉"),
    ("戊", "寅"): ("申", "酉"),
    ("己", "卯"): ("申", "酉"),
    ("庚", "辰"): ("申", "酉"),
    ("辛", "巳"): ("申", "酉"),
    ("壬", "午"): ("申", "酉"),
    ("癸", "未"): ("申", "酉"),
    ("甲", "申"): ("午", "未"),
    ("乙", "酉"): ("午", "未"),
    ("丙", "戌"): ("午", "未"),
    ("丁", "亥"): ("午", "未"),
    ("戊", "子"): ("午", "未"),
    ("己", "丑"): ("午", "未"),
    ("庚", "寅"): ("午", "未"),
    ("辛", "卯"): ("午", "未"),
    ("壬", "辰"): ("午", "未"),
    ("癸", "巳"): ("午", "未"),
    ("甲", "午"): ("辰", "己"),
    ("乙", "未"): ("辰", "己"),
    ("丙", "申"): ("辰", "己"),
    ("丁", "酉"): ("辰", "己"),
    ("戊", "戌"): ("辰", "己"),
    ("己", "亥"): ("辰", "己"),
    ("庚", "子"): ("辰", "己"),
    ("辛", "丑"): ("辰", "己"),
    ("壬", "寅"): ("辰", "己"),
    ("癸", "卯"): ("辰", "己"),
    ("甲", "辰"): ("寅", "卯"),
    ("乙", "巳"): ("寅", "卯"),
    ("丙", "午"): ("寅", "卯"),
    ("丁", "未"): ("寅", "卯"),
    ("戊", "申"): ("寅", "卯"),
    ("己", "酉"): ("寅", "卯"),
    ("庚", "戌"): ("寅", "卯"),
    ("辛", "亥"): ("寅", "卯"),
    ("壬", "子"): ("寅", "卯"),
    ("癸", "丑"): ("寅", "卯"),
    ("甲", "寅"): ("子", "丑"),
    ("乙", "卯"): ("子", "丑"),
    ("丙", "辰"): ("子", "丑"),
    ("丁", "巳"): ("子", "丑"),
    ("戊", "午"): ("子", "丑"),
    ("己", "未"): ("子", "丑"),
    ("庚", "申"): ("子", "丑"),
    ("辛", "酉"): ("子", "丑"),
    ("壬", "戌"): ("子", "丑"),
    ("癸", "亥"): ("子", "丑"),
}


emptie4s = {
    ("甲", "子"): "水",
    ("乙", "丑"): "水",
    ("丙", "寅"): "水",
    ("丁", "卯"): "水",
    ("戊", "辰"): "水",
    ("己", "巳"): "水",
    ("庚", "午"): "水",
    ("辛", "未"): "水",
    ("壬", "申"): "水",
    ("癸", "酉"): "水",
    ("甲", "申"): "金",
    ("乙", "酉"): "金",
    ("丙", "戌"): "金",
    ("丁", "亥"): "金",
    ("戊", "子"): "金",
    ("己", "丑"): "金",
    ("庚", "寅"): "金",
    ("辛", "卯"): "金",
    ("壬", "辰"): "金",
    ("癸", "巳"): "金",
    ("甲", "午"): "水",
    ("乙", "未"): "水",
    ("丙", "申"): "水",
    ("丁", "酉"): "水",
    ("戊", "戌"): "水",
    ("己", "亥"): "水",
    ("庚", "子"): "水",
    ("辛", "丑"): "水",
    ("壬", "寅"): "水",
    ("癸", "卯"): "水",
    ("甲", "寅"): "金",
    ("乙", "卯"): "金",
    ("丙", "辰"): "金",
    ("丁", "巳"): "金",
    ("戊", "午"): "金",
    ("己", "未"): "金",
    ("庚", "申"): "金",
    ("辛", "酉"): "金",
    ("壬", "戌"): "金",
    ("癸", "亥"): "金",
}

minggongs = {
    "子": "天贵星、志气不凡、富裕清吉。",
    "丑": "天厄星、先难后吉、离祖劳心、晚年吉。",
    "寅": "天权星、聪明大器、中年有权柄。",
    "卯": "天赦星、慷慨疏财、得权时须谦逊。",
    "辰": "天如星、事多翻覆、机谋多能。",
    "巳": "天文星、文章振发、女命有好夫。",
    "午": "天福星、荣华吉命。",
    "未": "天驿星、一生劳碌、离祖始安。",
    "申": "天孤星、不宜早婚、女命妨夫。",
    "酉": "天秘星、性情刚直、时有是非。",
    "戌": "天艺星、心性平和、艺道有名。",
    "亥": "天寿星、心慈明悟、克己助人。",
}

rizhus = {
    "甲子": "虽坐沐浴，若四往有禄，看印，冬生不作妻败",
    "乙丑": "身坐财官，有乙庚合最吉",
    "丙寅": "金绝水死，财官俱背，但丙火长生食神独旺，主有寿，己亥、辛卯、癸巳时贵",
    "丁卯": "财官俱背，须合气、禄、火扶",
    "戊辰": "壬庚入墓，乙木自坐财官",
    "己巳": "水绝木病，丙寅时贵",
    "庚午": "庚金坐死但午上自坐官、印，虽败不困",
    "辛未": "身旺，丙申时贵",
    "壬申": "水辰生位，聪明秀丽",
    "癸酉": "财官无气，要用旺者吉",
    "甲戌": "身坐旺官，临火库，心怀慈善，丙寅时贵",
    "乙亥": "日坐木局，丙壬、壬午、甲申时贵",
    "丙子": "身坐财啊．癸巳时",
    "丁丑": "金库荣丰，见辛亥时贵",
    "戊寅": "甲木当局，官杀者吉",
    "己卯": "身坐杀地，须身杀力停者吉",
    "庚辰": "魁罡，忌于刑冲",
    "辛巳": "金局坐死不妨，戊子时贵",
    "壬午": "财官双美，伶俐有谋，壬寅时贵",
    "癸未": "身坐杀位须身力二停",
    "甲申": "坐绝，四柱俱绝者吉",
    "乙酉": "坐杀四乙酉或有化杀则吉，辛巳时，为化气金局贵",
    "丙戌": "夏生则财官无气",
    "丁亥": "日贵，壬寅时，乙巳时皆贵",
    "戊子": "自坐财，乙卯时，丁巳时贵",
    "己丑": "有财无官，丙寅时贵",
    "庚寅": "坐绝反主吉昌",
    "辛卯": "财衰无妨，见戊子时贵",
    "壬辰": "魁罡、不喜冲刑，遇建禄反卑",
    "癸巳": "财官双美最吉祥，丁已时贵",
    "甲午": "夏生大吉",
    "乙未": "逢财伤官格",
    "丙申": "身坐财，庚寅时贵，癸巳时亦吉",
    "丁酉": "临财学精，壬寅时贵",
    "戊戌": "魁罡，忌冲刑",
    "己亥": "自坐财官得高名，丙寅时贵",
    "庚子": "有丁火则吉",
    "辛丑": "食神荣昌，主寿",
    "壬寅": "水火既济，见壬寅时大吉",
    "癸卯": "日贵，衰神旺吉",
    "甲辰": "身坐财库水气，性善良，丙寅时吉",
    "乙巳": "男女妨家室，有壬者轻",
    "丙午": "日刃喜刑冲，男、女妨家室，见乙、癸者轻",
    "丁未": "坐印小吉",
    "戊申": "甲绝有财无官",
    "己酉": "财禄一背，皆须生扶",
    "庚戌": "魁罡，忌火旺地支之运及冲刑",
    "辛亥": "财生，官绝",
    "壬子": "日刃喜刑冲",
    "癸丑": "喜冲不作灾论",
    "甲寅": "财官二背，见辛未时贵",
    "乙卯": "财官无气，见庚辰时贵",
    "丙辰": "冬生不吉，庚寅时贵",
    "丁巳": "男、女妨家室．有戊者重，甲、寅者轻",
    "戊午": "日刃喜刑冲，四、五月在刑地亦吉",
    "己未": "丙寅时贵（无水大吉）",
    "庚申": "日德、日禄、寿",
    "辛酉": "日禄、戊子、丙申时贵",
    "壬戌": "元武当权．等作财官双美",
    "癸亥": "得癸亥时夫贵",
}

# ges = {
# ('庚', '子'):'飞天禄马', ('壬', '子'):'飞天禄马',
# ('辛', '亥'):'飞天禄马', ('癸', '亥'):'飞天禄马',
# }

# ge_descs = {
#'飞天禄马':'''
# 若逢伤官月建,如凶处,未必为凶,内有倒禄飞冲,忌官星,亦嫌羁绊。
# 柱无财官,方用。又须月时或年与日同支,方能并冲。
#'''
# }

up_down_hes = (("戊", "子"), ("辛", "巳"), ("壬", "午"), ("丁", "亥"))

lu_types = {
    "甲": {
        ("丙", "寅"): "福星禄 名位禄 吉",
        ("戊", "寅"): "伏马禄 吉",
        ("庚", "寅"): "破禄，半吉半凶",
        ("壬", "寅"): "正禄，带截路空亡，必为僧道 不吉",
        ("甲", "寅"): "长生禄，大吉",
        ("乙", "卯"): "生成禄，大吉",
    },
    "乙": {
        ("乙", "卯"): "喜神旺禄 吉",
        ("丁", "卯"): "截路空亡 凶",
        ("己", "卯"): "进神禄 吉",
        ("辛", "卯"): "破禄，又为交神，半吉半凶",
        ("癸", "卯"): "死禄 虽贵终贫 凶",
    },
    "丙": {
        ("己", "巳"): "九天库禄 吉",
        ("辛", "巳"): "截路空亡 凶",
        ("乙", "巳"): "旺马禄 吉",
        ("丁", "巳"): "库禄 吉",
        ("癸", "巳"): "伏贵神禄，半吉半凶",
    },
    "丁": {
        ("庚", "午"): "截路空亡 凶",
        ("壬", "午"): "德合禄 吉",
        ("甲", "午"): "进神禄 吉",
        ("丙", "午"): "喜神禄，交羊刃，半吉",
        ("戊", "午"): "伏羊刃 禄，多凶",
    },
    "戊": {
        ("己", "巳"): "九天库禄，吉",
        ("辛", "巳"): "截路空亡 凶",
        ("癸", "巳"): "贵神禄，戊癸化合，有官位重 吉",
        ("乙", "巳"): "驿马同乡禄 吉",
        ("戊", "巳"): "旺库禄 吉",
    },
    "己": {
        ("庚", "午"): "截路空亡 凶",
        ("壬", "午"): "死鬼禄 凶",
        ("甲", "午"): "进神合禄 显达之象 吉",
        ("丙", "午"): "喜神禄 半吉",
        ("戊", "午"): "伏神羊刃禄，凶",
    },
    "庚": {
        ("壬", "申"): "大败禄 凶",
        ("甲", "申"): "截路空亡禄 凶",
        ("丙", "申"): "大败禄，多成败 半吉",
        ("戊", "申"): "伏马禄，多滞，若值福星，贵吉",
        ("庚", "申"): "长生禄，大吉",
    },
    "辛": {
        ("癸", "酉"): "伏神禄，水火相犯，凶",
        ("乙", "酉"): "破禄 成败 凶",
        ("丁", "酉"): "空亡贵神禄 丁木受气，辛水沐浴，主奸淫事；值喜神，吉。",
        ("己", "酉"): "进神禄 吉",
        ("辛", "酉"): "正禄 吉",
    },
    "壬": {
        ("丁", "亥"): "贵神合禄 吉",
        ("乙", "亥"): "天德禄 吉",
        ("己", "亥"): "旺禄 大吉",
        ("辛", "亥"): "同马乡禄 大吉",
        ("癸", "亥"): "大败禄，贫薄 凶",
    },
    "癸": {
        ("甲", "子"): "进神禄，主登科进达 吉",
        ("丙", "子"): "交羊刃禄，带福星，贵有权。 吉",
        ("戊", "子"): "伏羊刃合贵禄 半吉",
        ("庚", "印禄"): "进神禄 吉",
        ("壬", "子"): "正羊刃禄，凶",
    },
}


wenxing = {
    "甲": "午",
    "乙": "巳",
    "丙": "申",
    "丁": "酉",
    "戊": "申",
    "己": "酉",
    "庚": "戌",
    "辛": "亥",
    "壬": "寅",
    "癸": "卯",
}
tianyin = {
    "甲": "寅",
    "乙": "亥",
    "丙": "戌",
    "丁": "酉",
    "戊": "申",
    "己": "未",
    "庚": "午",
    "辛": "巳",
    "壬": "辰",
    "癸": "卯",
}
xuetangs = {
    "金": ("辛", "巳"),
    "木": ("己", "亥"),
    "水": ("甲", "申"),
    "火": ("丙", "寅"),
    "土": ("戊", "申"),
}

# 天乙贵人，有两种分法
tianyis = {
    "甲": "未",
    "乙": "申",
    "丙": "酉",
    "丁": "亥",
    "戊": "丑",
    "己": "子",
    "庚": "丑",
    "辛": "寅",
    "壬": "卯",
    "癸": "巳",
}

# 玉堂贵人，有两种分法
yutangs = {
    "甲": "丑",
    "乙": "子",
    "丙": "亥",
    "丁": "酉",
    "戊": "未",
    "己": "申",
    "庚": "未",
    "辛": "午",
    "壬": "巳",
    "癸": "卯",
}

wangs = {
    "子": "亥",
    "丑": "申",
    "寅": "巳",
    "卯": "寅",
    "辰": "亥",
    "巳": "申",
    "午": "巳",
    "未": "寅",
    "申": "亥",
    "酉": "申",
    "戌": "巳",
    "亥": "寅",
}
jieshas = {
    "子": "巳",
    "丑": "寅",
    "寅": "亥",
    "卯": "申",
    "辰": "巳",
    "巳": "寅",
    "午": "亥",
    "未": "申",
    "申": "巳",
    "酉": "寅",
    "戌": "亥",
    "亥": "申",
}

ma_zhus = {
    ("甲", "申"): "截路空日马",
    ("丙", "申"): "截路空日马",
    ("戊", "申"): "福星伏马",
    ("庚", "申"): "逢天关马",
    ("壬", "申"): "大败马",
    ("甲", "寅"): "正禄文星马",
    ("丙", "寅"): "福星马",
    ("戊", "寅"): "伏马",
    ("庚", "寅"): "破禄马",
    ("壬", "寅"): "截路马",
    ("乙", "亥"): "天德马",
    ("丁", "亥"): "天乙马",
    ("己", "亥"): "旺禄马",
    ("辛", "亥"): "正禄马",
    ("癸", "亥"): "大败马",
    ("乙", "巳"): "正禄马",
    ("丁", "巳"): "旺气马",
    ("己", "巳"): "九天禄库马",
    ("辛", "巳"): "截路马",
    ("癸", "巳"): "天乙伏马",
}


jianlu_desc = """

================  建禄格 ================  比例 1/12
喜: 财、官和印绶  忌: 忌伤官和劫财；  杀不可太旺。
颇宜时带偏官、偏财或食神，更看年时上露者取用，若略见财官，反争夺不吉。
难招祖业，必主平生见财不聚，却病少寿长，行运再见比，克妻妨父损子，或官非破财，或因妻孥财帛争夺。
有财官，引旺得地，官星有助，运临官星有气之地，亦贵；财星有助，运临财旺之地，亦富；财官俱旺，乃富贵之命。
若时逢财库，运至财乡，必主晚年大富。年上财官有助，必享祖荫。
若四柱元无财官，纵运行财官之地，亦止虚花而已。命无财官，岁运又行比，一生贫蹇。
"""

jianlus = {
    ("甲", "寅"): "柱中乙卯未字多，主无祖财，[劫财]克妻，一世孤贫，作事虚诈，为人大模样",
    (
        "乙",
        "卯",
    ): """
    柱有庚辛巳酉丑申及戊己巳午辰戌等字，财官多则贵，壬癸申子辰亥水印成局亦佳，更运逢之尤妙""",
    ("丙", "巳"): "岁时干支水金成局，运历财官旺地，亦主富贵。",
    (
        "丁",
        "午",
    ): """
    金败水绝，财[庚-沐浴]官[壬-胎]俱背，顺运克妻，逆运克三妻，若柱有巳酉丑庚辛壬癸亥申子辰，
    运临财官旺地亦发，用煞或印，以多为贵，若止建禄，亦同前断。""",
    (
        "戊",
        "巳",
    ): """年日时无水，主克妻[癸-胎]，无祖业，子[病]多不肖，柱中多有官则吉，如见偏官，主尊贵，
    岁月若是火多及或印绶，虽无财官，主吉，若柱内隐显壬癸亥申子辰水局，晚子一二，
    有甲寅乙卯亥未木局，运至财官旺地亦发。""",
    (
        "己",
        "午",
    ): """
    以壬水为财，五月水囚[壬-胎]，主无祖业，克妻，子[乙-长生]亦不多，
    岁时透出寅甲为正官，五月甲死，官必卑小，喜见亥卯未乙，身旺见官煞为妙，偏财亦美。""",
    (
        "庚",
        "申",
    ): """
    上旬生，近木余气，略无祖财，虽节气临水绝之乡，尚有三四分库财为福，运至丙戌，财尽矣，
    若年日时多带财，好命看，见丙丁巳午寅戌火局则有官，以煞化官也，官小亦不清显，怕壬癸亥子，克官不成。""",
    (
        "戊",
        "巳",
    ): """年日时无水，主克妻[癸-胎]，无祖业，子[病]多不肖，柱中多有官则吉，如见偏官，主尊贵，
    岁月若是火多及或印绶，虽无财官，主吉，若柱内隐显壬癸亥申子辰水局，晚子一二，
    有甲寅乙卯亥未木局，运至财官旺地亦发。""",
    (
        "己",
        "午",
    ): """
    以壬水为财，五月水囚[壬-胎]，主无祖业，克妻，子[乙-长生]亦不多，
    岁时透出寅甲为正官，五月甲死，官必卑小，喜见亥卯未乙，身旺见官煞为妙，偏财亦美。""",
    (
        "庚",
        "申",
    ): """
    上旬生，近木余气，略无祖财，虽节气临水绝之乡，尚有三四分库财为福，运至丙戌，财尽矣，
    若年日时多带财，好命看，见丙丁巳午寅戌火局则有官，以煞化官也，官小亦不清显，怕壬癸亥子，克官不成。""",
    (
        "辛",
        "酉",
    ): """
    无祖财，柱中多见分夺，孤贫[甲-胎]无妻，或克妻无财，若带木火生旺，又当富贵，原无财官，
    又行生地，其劫祸尤重，或见辛酉则为专禄，更有财官印食之神岁运再逢尤好，逆运南方则吉，
    顺运北方，百事无成，若辛卯、辛未日身自坐财，可许衣禄，辛巳日有贵，官禄亦轻。""",
    (
        "壬",
        "亥",
    ): """
    无祖业，柱中多见火土，主自成立有官，如见水多泛滥，无成、克妻、贫薄。""",
    (
        "癸",
        "子",
    ): """
    无祖业，柱中多见火土，主自成立有官，如见水多泛滥，无成、克妻、贫薄。""",
}

shang_guans = {"火": "伤尽。", "金": "要见官", "木": "官要旺", "土": "伤尽。", "水": "伤官木也要土"}

tianyuans = {
    "火": "主兵权，为将镇三边。",
    "金": "有重权，防御刺史臣",
    "木": "伤衰化煞，为权势若雷",
    "土": "正禄八座三台福。",
    "水": "入官局，可沾侍郎禄",
}

lu_ku_cai = {
    "甲": "丑",
    "乙": "丑",
    "丙": "午",
    "丁": "午",
    "戊": "辰",
    "己": "辰",
    "庚": "未",
    "辛": "未",
    "壬": "戌",
    "癸": "戌",
}
self_zuo = {
    "官": """""",
    "杀": """天元坐杀：喜旺，忌明现食伤。无官煞复克，喜印化煞，财旺身旺。为人心多性急，阴险怀毒，僭伪谋害，不近人情.
    如无助化，再行煞旺运，或再见煞克，为人必面目瘢痕，侏儒跛鳖，骈指瘤赘，奸贪猛暴，恃强不惮，累犯宪章。克重多夭，合格为武贵。""",
    "财": """""",
    "才": """""",
    "印": """""",
    "枭": """""",
    "食": """""",
    "伤": """""",
    "比": """""",
    "劫": """""",
}


year_shens = {
    "孤辰": {
        "子": "寅",
        "丑": "寅",
        "寅": "巳",
        "卯": "巳",
        "辰": "巳",
        "巳": "申",
        "午": "申",
        "未": "申",
        "申": "亥",
        "酉": "亥",
        "戌": "亥",
        "亥": "寅",
    },
    "寡宿": {
        "子": "戌",
        "丑": "戌",
        "寅": "丑",
        "卯": "丑",
        "辰": "丑",
        "巳": "辰",
        "午": "辰",
        "未": "辰",
        "申": "未",
        "酉": "未",
        "戌": "未",
        "亥": "戌",
    },
    "大耗": {
        "子": "巳未",
        "丑": "午申",
        "寅": "未酉",
        "卯": "申戌",
        "辰": "酉亥",
        "巳": "戌子",
        "午": "亥丑",
        "未": "子寅",
        "申": "丑卯",
        "酉": "寅辰",
        "戌": "卯巳",
        "亥": "辰午",
    },
}

month_shens = {
    "天德": {
        "子": "巳",
        "丑": "庚",
        "寅": "丁",
        "卯": "申",
        "辰": "壬",
        "巳": "辛",
        "午": "亥",
        "未": "甲",
        "申": "癸",
        "酉": "寅",
        "戌": "丙",
        "亥": "乙",
    },
    "月德": {
        "子": "壬",
        "丑": "庚",
        "寅": "丙",
        "卯": "甲",
        "辰": "壬",
        "巳": "庚",
        "午": "丙",
        "未": "甲",
        "申": "壬",
        "酉": "庚",
        "戌": "丙",
        "亥": "甲",
    },
}


day_shens = {
    "将星": {
        "子": "子",
        "丑": "酉",
        "寅": "午",
        "卯": "卯",
        "辰": "子",
        "巳": "酉",
        "午": "午",
        "未": "卯",
        "申": "子",
        "酉": "酉",
        "戌": "午",
        "亥": "卯",
    },
    "华盖": {
        "子": "辰",
        "丑": "丑",
        "寅": "戌",
        "卯": "未",
        "辰": "辰",
        "巳": "丑",
        "午": "戌",
        "未": "未",
        "申": "辰",
        "酉": "丑",
        "戌": "戌",
        "亥": "未",
    },
    "驿马": {
        "子": "寅",
        "丑": "亥",
        "寅": "申",
        "卯": "巳",
        "辰": "寅",
        "巳": "亥",
        "午": "申",
        "未": "巳",
        "申": "寅",
        "酉": "亥",
        "戌": "申",
        "亥": "巳",
    },
    "劫煞": {
        "子": "巳",
        "丑": "寅",
        "寅": "亥",
        "卯": "申",
        "辰": "巳",
        "巳": "寅",
        "午": "亥",
        "未": "申",
        "申": "巳",
        "酉": "寅",
        "戌": "亥",
        "亥": "申",
    },
    "亡神": {
        "子": "亥",
        "丑": "申",
        "寅": "巳",
        "卯": "寅",
        "辰": "亥",
        "巳": "申",
        "午": "巳",
        "未": "寅",
        "申": "亥",
        "酉": "申",
        "戌": "巳",
        "亥": "寅",
    },
    "桃花": {
        "子": "酉",
        "丑": "午",
        "寅": "卯",
        "卯": "子",
        "辰": "酉",
        "巳": "午",
        "午": "卯",
        "未": "子",
        "申": "酉",
        "酉": "午",
        "戌": "卯",
        "亥": "子",
    },
}

g_shens = {
    "天乙": {
        "甲": "未丑",
        "乙": "申子",
        "丙": "酉亥",
        "丁": "酉亥",
        "戊": "未丑",
        "己": "申子",
        "庚": "未丑",
        "辛": "寅午",
        "壬": "卯巳",
        "癸": "卯巳",
    },
    "文昌": {
        "甲": "巳",
        "乙": "午",
        "丙": "申",
        "丁": "酉",
        "戊": "申",
        "己": "酉",
        "庚": "亥",
        "辛": "子",
        "壬": "寅",
        "癸": "丑",
    },
    "阳刃": {
        "甲": "卯",
        "乙": "",
        "丙": "午",
        "丁": "",
        "戊": "午",
        "己": "",
        "庚": "酉",
        "辛": "",
        "壬": "子",
        "癸": "",
    },
    "红艳": {
        "甲": "午",
        "乙": "午",
        "丙": "寅",
        "丁": "未",
        "戊": "辰",
        "己": "辰",
        "庚": "戌",
        "辛": "酉",
        "壬": "子",
        "癸": "申",
    },
}

shens_infos = {
    "孤辰": "孤僻、孤独：月支容易不合群、容易30岁以后才结婚。女命官杀月干坐顾辰、独居概率大，时支则有阴道之心。",
    "寡宿": "类似孤辰，同柱有天月德没关系。男怕孤，女怕寡。",
    "大耗": "意外破损，单独没关系。与桃花或驿马之类同柱则危险。",
    "天德": "先天有福，日干终生有福。忌讳冲克，不怕合。女命与夫星同干更佳。",
    "月德": "先天有福，日干终生有福。忌讳冲克，不怕合。女命与夫星同干更佳。",
    "将星": "有理想、气度、即从容不迫。",
    "华盖": "有艺术、水准与命格相关。",
    "驿马": "多迁移、水准与命格相关。女驿马合贵人，终沦落风尘。",
    "劫煞": "与贵人同柱没关系、与亡神对冲。会三刑不佳，其他情况还好。为日主所克无大碍。",
    "亡神": "与贵人同柱没关系、与劫煞对冲。会三刑不佳，其他情况还好。为日主所克无大碍。",
    "桃花": "凶居多、女正官坐桃花吉。",
    "天乙": "后天解难、女命不适合多",
    "文昌": "诗书佳，未必有福，女命多参考李清照。",
    "阳刃": "性格刚强，女命未必佳。",
    "红艳": "爱得执著，不顾及地位差异。",
}

tiaohous = {
    "甲寅": "1丙2_癸",
    "甲卯": "1庚2戊丙3己丁",
    "甲辰": "1庚2壬丁",
    "甲巳": "1癸2庚丁",
    "甲午": "1癸2庚丁",
    "甲未": "1癸2庚丁",
    "甲申": "1庚2壬丁",
    "甲酉": "1庚2丙丁",
    "甲戌": "1庚2壬甲3癸丁",
    "甲亥": "1庚2戊丁3_丙",
    "甲子": "1丁2丙庚",
    "甲丑": "1丁2丙庚",
    "乙寅": "1丙2_癸",
    "乙卯": "1丙2_癸",
    "乙辰": "1癸2戊丙",
    "乙巳": "1癸",
    "乙午": "1癸2_丙",
    "乙未": "1癸2_丙",
    "乙申": "1庚2己癸",
    "乙酉": "1癸2丁丙",
    "乙戌": "1癸2_辛",
    "乙亥": "1丙2_戊",
    "乙子": "1丙",
    "乙丑": "1丙",
    "丙寅": "1壬2_庚",
    "丙卯": "1壬2_己",
    "丙辰": "1壬2_甲",
    "丙巳": "1壬2癸庚",
    "丙午": "1壬2_庚",
    "丙未": "1壬2_庚",
    "丙申": "1壬2_戊",
    "丙酉": "1壬2_癸",
    "丙戌": "1甲2_壬",
    "丙亥": "1甲2庚戊3壬",
    "丙子": "1壬2己戊",
    "丙丑": "1壬2_甲",
    "丁寅": "1甲2_庚",
    "丁卯": "1庚2_甲",
    "丁辰": "1甲2_庚",
    "丁巳": "1甲2_庚",
    "丁午": "1壬2癸庚",
    "丁未": "1甲2庚壬",
    "丁申": "1甲2丙庚3戊",
    "丁酉": "1甲2丙庚3戊",
    "丁戌": "1甲2戊庚",
    "丁亥": "1甲2_庚",
    "丁子": "1丙",
    "丁丑": "1甲2_庚",
    "戊寅": "1丙2癸甲",
    "戊卯": "1丙2癸甲",
    "戊辰": "1甲2癸丙",
    "戊巳": "1甲2癸丙",
    "戊午": "1壬2丙甲",
    "戊未": "1癸2甲丙",
    "戊申": "1丙2甲癸",
    "戊酉": "1丙2_癸",
    "戊戌": "1甲2癸丙",
    "戊亥": "1甲2_丙",
    "戊子": "1丙2_甲",
    "戊丑": "1丙2_甲",
    "己寅": "1丙2甲庚",
    "己卯": "1甲2癸丙",
    "己辰": "1丙2甲癸",
    "己巳": "1癸2_丙",
    "己午": "1癸2_丙",
    "己未": "1癸2_丙",
    "己申": "1丙2_癸",
    "己酉": "1丙2_癸",
    "己戌": "1甲2癸丙",
    "己亥": "1丙2戊甲",
    "己子": "1丙2戊甲",
    "己丑": "1丙2戊甲",
    "庚寅": "1戊2丙甲3丁壬",
    "庚卯": "1丁2丙甲3_庚",
    "庚辰": "1甲2壬丁3癸",
    "庚巳": "1壬2丙戊3丁",
    "庚午": "1壬2_癸",
    "庚未": "1丁2_甲",
    "庚申": "1丁2_甲",
    "庚酉": "1丁2丙甲",
    "庚戌": "1甲2_壬",
    "庚亥": "1丁2_丙",
    "庚子": "1丁2丙甲",
    "庚丑": "1丙2甲丁",
    "辛寅": "1己2庚壬",
    "辛卯": "1壬2_甲",
    "辛辰": "1壬2_甲",
    "辛巳": "1壬2癸甲",
    "辛午": "1壬2癸巳",
    "辛未": "1壬2甲庚",
    "辛申": "1壬2戊甲",
    "辛酉": "1壬2_申",
    "辛戌": "1壬2_甲",
    "辛亥": "1壬2_丙",
    "辛子": "1丙2壬戊3甲",
    "辛丑": "1丙2戊壬3己",
    "壬寅": "1庚2戊丙",
    "壬卯": "1戊2庚辛",
    "壬辰": "1甲2_庚",
    "壬巳": "1壬2庚辛3癸",
    "壬午": "1癸2辛庚",
    "壬未": "1辛2_甲",
    "壬申": "1戊2_丁",
    "壬酉": "1甲2_庚",
    "壬戌": "1甲2_丙",
    "壬亥": "1戊2庚丙",
    "壬子": "1戊2_丙",
    "壬丑": "1丙2甲丁",
    "癸寅": "1辛2_丙",
    "癸卯": "1庚2_辛",
    "癸辰": "1丙2甲辛",
    "癸巳": "1辛",
    "癸午": "1庚2癸壬",
    "癸未": "1庚2壬辛3癸",
    "癸申": "1丁",
    "癸酉": "1辛2_丙",
    "癸戌": "1辛2壬甲3癸",
    "癸亥": "1庚2戊辛3丁",
    "癸子": "1丙3_辛",
    "癸丑": "1丙2夜生贵丁",
}

jins = {
    "甲": "辰戌丑未入墓库运；巳未申酉亥月有夭折运；申酉戌亥月调候待改进！",
    "乙": "辰未亥有夭寿运；寅辰午申酉调候待改进！",
    "丙": "子酉亥有夭折运；午未亥调候待改进！",
    "丁": "子辰午亥有夭折运；寅巳午酉戌调候待改进！",
    "戊": "卯亥有夭折运；未辰戌调候待改进！",
    "己": "子寅卯酉亥有夭损运；寅卯辰巳亥子丑调候待改进！",
    "庚": "子卯辰巳午戌有损寿运；寅卯辰巳午申调候待改进！",
    "辛": "丑寅有夭折运；寅卯巳午酉戌亥调候待改进！",
    "壬": "巳未申有损寿运；寅卯巳午亥调候待改进！",
    "癸": "丑寅午戌亥有损寿运；子丑辰巳午未亥调候待改进！",
}

jinbuhuan = {
    # 2级次P64 余氏P59
    "甲子": "调候：喜丁 忌壬癸  大运：喜逆行水木 忌午未  备注：喜官杀",
    "甲丑": "调候：喜丁 忌壬辛癸  大运：喜寅卯申酉 忌午未",
    "甲寅": "调候：喜丙癸 忌戊己  大运：喜逆行金水 忌午未  备注：财、杀",
    "甲卯": "调候：喜庚  忌壬癸  大运：不拘顺逆 忌申酉",
    "甲辰": "调候：喜庚  忌丁癸  大运：喜申酉 忌寅卯巳午 备注：正官根深",
    "甲巳": "调候：喜癸 忌戊己  大运：喜寅卯  忌午未(夭) 备注：根深财官",
    "甲午": "调候：喜癸 忌戊己  大运：喜亥子寅卯  忌申酉 ",
    "甲未": "调候：喜癸 忌戊乙己  大运：喜亥子寅  忌申酉(夭) 备注：根深财官",
    "甲申": "调候：喜丙 忌壬癸  大运：喜亥子寅  忌午巳(夭) 备注：忌无根杀旺",
    "甲酉": "调候：喜甲壬 忌丁  大运：喜亥子  忌午(夭) 备注：正官",
    "甲戌": "调候：喜辛壬 忌丁  大运：喜顺亥未  忌辰 备注：财官",
    "甲亥": "调候：喜丁 忌壬癸  大运：喜顺寅卯  忌午未(夭) 备注：七杀",
    "乙子": "调候：喜丙 忌壬  大运：喜戌申酉 忌亥丑  备注：忌官杀成局",
    "乙丑": "调候：喜丙 忌辛壬  大运：喜巳午未寅卯 ",
    "乙寅": "调候：喜丙 忌壬  大运：喜巳午申酉 忌丑亥子  备注：财官",
    "乙卯": "调候：喜丙癸  忌壬己  大运：喜巳午申酉 忌卯子亥",
    "乙辰": "调候：喜丙  忌癸  大运：喜申酉 忌戌(夭) ",
    "乙巳": "调候：喜癸 忌戊己  大运：喜亥子卯寅  忌申酉(寿损) 备注：忌无根",
    "乙午": "调候：喜癸 忌戊己  大运：喜辰卯寅  忌申酉(灾疾)  备注：忌身轻",
    "乙未": "调候：喜癸丙 忌乙壬己  大运：喜巳午寅卯  忌申酉子(夭) 备注：官杀",
    "乙申": "调候：喜丙癸 忌壬  大运：喜未午巳  忌戊亥子 备注：忌身柔",
    "乙酉": "调候：喜癸丁 忌己壬  大运：喜未午巳  忌日主无根 备注：忌无根",
    "乙戌": "调候：喜癸辛 忌丁  大运：  忌酉亥(灾疾) ",
    "乙亥": "调候：喜丙戊 忌壬甲  大运：喜逆申酉  忌辰(夭) 备注：喜官杀",
    "丙子": "调候：喜壬 忌己  大运：喜寅卯巳午 忌亥申酉(夭)  备注：印重",
    "丙丑": "调候：喜壬甲 忌辛己  大运：喜申酉戌 忌寅卯巳午(灾)  备注：喜印忌根浅 ",
    "丙寅": "调候：喜壬庚 忌己  大运：喜申酉戌 忌卯 ",
    "丙卯": "调候：喜壬己  忌甲  大运：喜巳午未 忌寅辰 备注：忌无官",
    "丙辰": "调候：喜壬  忌癸  大运：喜戌丑 忌巳午亥子 备注：喜戊己",
    "丙巳": "调候：喜壬庚 忌丁  大运：喜申酉寅卯  忌戌(灾) 备注：喜官杀",
    "丙午": "调候：喜壬 忌己丁  大运：喜申酉亥丑  忌寅卯  备注：喜杀",
    "丙未": "调候：喜癸庚 忌乙  大运：喜申酉亥子  忌寅卯 备注：忌杀喜官",
    "丙申": "调候：喜丙 忌壬癸  大运：喜寅卯巳午  忌亥子 备注：喜从化",
    "丙酉": "调候：喜壬癸 忌戊己  大运：喜亥子  忌寅卯(夭) 备注：忌比劫",
    "丙戌": "调候：喜甲壬 忌丁己  大运：喜寅卯  忌亥子辰 备注：喜杀忌官",
    "丙亥": "调候：喜甲壬 忌己  大运：喜寅卯巳午  忌申酉(夭)",
    "丁子": "调候：喜甲庚 忌己丙  大运：喜寅卯辰 忌申酉戌(夭)  备注：七杀",
    "丁丑": "调候：喜甲庚 忌辛己丙  大运：喜寅卯辰 忌巳午未  备注：大忌土多 ",
    "丁寅": "调候：喜壬庚 忌己丁  大运：喜巳午未亥子 忌申酉(灾祸) 备注：喜水忌土多 ",
    "丁卯": "调候：喜庚甲  忌丙  大运：喜巳午亥子 忌寅卯申酉 备注：无官独杀",
    "丁辰": "调候：喜甲庚 忌癸丙  大运：喜巳午未 巳戌亥(夭) ",
    "丁巳": "调候：喜庚甲  忌丙  大运：喜庚甲  忌丙",
    "丁午": "调候：喜壬癸庚 忌丁  大运：喜亥子  忌戌未  备注：忌无水(夭)",
    "丁未": "调候：喜甲壬庚 忌乙丁  大运：喜申酉  忌巳午 备注：喜金财",
    "丁申": "调候：喜甲庚丙 忌壬  大运：喜巳午未  忌亥子 备注：身强根深",
    "丁酉": "调候：喜辛甲丙 忌丁  大运：喜申未午巳  忌戌丑 备注：喜官杀",
    "丁戌": "调候：喜甲庚 忌丁  大运：喜寅卯巳午  忌亥子(夭) ",
    "丁亥": "调候：喜甲庚 忌丙  大运：喜寅卯巳午  忌申酉(夭) 备注：喜官忌杀混",
    "戊子": "调候：喜丙甲 忌辛  大运：喜辰戌 忌寅卯申酉  备注：喜辰戌坐支",
    "戊丑": "调候：喜丙甲 忌辛庚  大运：喜寅卯亥子 忌巳午申酉  备注：喜财杀 ",
    "戊寅": "调候：喜丙甲癸 忌壬  大运：喜巳午未 忌亥子甲 ",
    "戊卯": "调候：喜丙甲癸 忌辛  大运：喜巳午未 忌酉(夭) 备注：喜火",
    "戊辰": "调候：喜甲丙壬 忌癸  大运：喜申酉巳午 忌戌 备注：喜水木财官",
    "戊巳": "调候：喜甲丙癸 忌戊  大运：喜寅卯亥子  忌申酉巳午 备注：喜财杀",
    "戊午": "调候：喜壬甲丙 忌癸  大运：喜寅卯  忌子  ",
    "戊未": "调候：喜壬丙甲 忌乙  大运：喜寅卯辰  忌亥子",
    "戊申": "调候：喜丙甲癸 忌庚  大运：喜巳午未  忌亥子丑(灾) 备注：喜财杀",
    "戊酉": "调候：喜丙癸 忌壬  大运：喜巳午  忌亥子卯 备注：喜身强",
    "戊戌": "调候：喜甲癸 忌丁  大运：忌辰 备注：喜财杀",
    "戊亥": "调候：喜甲丙 忌辛  大运：喜巳午未  忌酉卯辰",
    "己子": "调候：喜丙甲 忌戊  大运：喜巳未戌 忌寅卯(夭)  备注：忌身弱官杀混",
    "己丑": "调候：喜丙甲 忌辛己  大运：子亥申酉 忌未  备注：忌比肩",
    "己寅": "调候：喜丙癸 忌壬  大运：喜巳午未 忌丑子(夭)  备注：忌身柔",
    "己卯": "调候：喜甲癸 忌己  大运：喜巳午未 忌寅(夭) 备注：忌官杀会",
    "己辰": "调候：喜丙壬 忌癸  大运：喜巳午未 忌卯寅丑戌 ",
    "己巳": "调候：喜癸丙辛 忌戊  大运：喜亥子寅卯  忌申酉 ",
    "己午": "调候：喜癸丙 忌己庚  大运：喜未申寅卯  忌亥子  ",
    "己未": "调候：喜癸丙 忌乙  大运： 忌丑  备注：喜七杀",
    "己申": "调候：喜丙癸 忌甲  大运：喜巳午未  忌寅卯(夭) 备注：身强",
    "己酉": "调候：喜丙癸 忌辛  大运：喜寅巳午  忌申戌 备注：忌无根(夭)",
    "己戌": "调候：喜甲丙癸 忌丁庚  大运：忌戌 ",
    "己亥": "调候：喜丙甲 忌己  大运：喜子丑  忌寅卯(夭)  备注：忌无根",
    "庚子": "调候：喜丁丙甲 忌癸  大运：喜寅卯辰 忌午(夭)  备注：喜财杀",
    "庚丑": "调候：喜丙甲丁 忌辛  大运：喜寅卯巳午 忌未  备注：喜木火 ",
    "庚寅": "调候：喜丙甲 忌癸  大运：喜卯巳酉 忌子丑午(灾) 备注：喜透土",
    "庚卯": "调候：喜丁甲 忌癸  大运：喜申酉 忌午(夭) 备注：喜身旺",
    "庚辰": "调候：喜甲丁戌 忌癸  大运：喜卯寅亥 忌子(夭) ",
    "庚巳": "调候：喜壬戊丙 忌丁  大运：喜申酉亥子  忌午(夭) 备注：忌无根，缺水夭",
    "庚午": "调候：喜壬 忌丁  大运：喜寅卯辰巳  忌子(夭)  ",
    "庚未": "调候：喜丁甲 忌乙戊己  大运：喜寅卯辰巳  忌戌辰丑(凶)",
    "庚申": "调候：喜甲丁 忌辛  大运：喜寅卯巳午  忌酉 备注：忌过旺",
    "庚酉": "调候：喜丁酉 忌癸  大运：喜巳午  忌申 备注：喜七杀",
    "庚戌": "调候：喜甲壬 忌丁  大运：喜巳午未  忌子辰(夭) ",
    "庚亥": "调候：喜丁丙 忌癸  大运：喜辰巳午  忌卯寅(凶)  备注：喜土",
    "辛子": "调候：喜丙壬 忌癸  大运：喜寅卯巳午 忌亥子  备注：喜丙丁",
    "辛丑": "调候：喜丙 忌辛  大运：喜巳午未 忌辰戌(夭)  备注：喜丁、土多夭 ",
    "辛寅": "调候：喜己壬 忌丁  大运：喜寅卯辰 忌巳午(夭) 备注：无木则夭",
    "辛卯": "调候：喜壬 忌庚  大运：喜巳午未 忌申酉(凶) 备注：喜支坐土",
    "辛辰": "调候：喜壬 忌癸  大运：忌戌 ",
    "辛巳": "调候：喜壬 忌丁  大运：喜寅卯  忌午子亥 备注：忌水多",
    "辛午": "调候：喜壬 忌丁巳  大运：喜亥子寅卯  忌申酉  备注：喜根深",
    "辛未": "调候：喜壬庚 忌乙  大运：喜寅卯辰  忌申 备注：喜金印",
    "辛申": "调候：喜壬甲 忌己  大运：喜寅卯巳午  忌酉 备注：忌支坐酉",
    "辛酉": "调候：喜壬 忌己  大运：喜巳午未  忌申戌子 备注：喜财杀",
    "辛戌": "调候：喜壬甲 忌丁  大运：忌巳辰 ",
    "辛亥": "调候：喜壬丙 忌癸  大运：喜巳午未  忌子丑  备注：喜丙官",
    "壬子": "调候：喜丙壬 忌己  大运：喜巳午未 忌亥丑(凶)  备注：喜财杀",
    "壬丑": "调候：喜丙壬 忌辛己  大运：喜亥子巳午 忌寅卯  备注：喜财 ",
    "壬寅": "调候：喜辛丙 忌丁  大运：喜巳午未 忌申亥子 ",
    "壬卯": "调候：喜庚辛 忌丙  大运：喜辰巳午未 忌丑亥子 ",
    "壬辰": "调候：喜丙辛 忌癸  大运：喜寅卯 忌申酉  备注：甲乙",
    "壬巳": "调候：喜辛壬 忌丁  大运：喜申酉  忌午(夭) 备注：忌日主无根",
    "壬午": "调候：喜庚辛壬 忌丁  大运：喜亥申酉  忌戌未  备注：喜从财 ",
    "壬未": "调候：喜庚辛壬 忌乙丁  大运：忌卯(凶夭)",
    "壬申": "调候：喜丁 忌壬癸  大运：巳午未  忌卯(凶夭) 备注：喜财",
    "壬酉": "调候：喜丙辛 忌乙  大运：忌卯 备注：喜杀忌官",
    "壬戌": "调候：喜辛甲 忌丁  大运：喜巳午  忌寅卯辰",
    "壬亥": "调候：喜丙 忌辛癸  大运：喜寅卯巳午  忌子丑  备注：喜财出干",
    "癸子": "调候：喜丙壬 忌辛  大运：喜寅卯巳午 忌申酉  备注：喜财官",
    "癸丑": "调候：喜丙 忌辛  大运：喜寅卯巳午 忌申酉(夭)  备注：喜财印 ",
    "癸寅": "调候：喜辛丙 忌庚  大运：喜巳午未 忌申(夭)  备注：忌官杀混",
    "癸卯": "调候：喜庚辛 忌癸  大运：喜巳午未 忌申酉(夭)   备注：忌官杀混",
    "癸辰": "调候：喜丙辛 忌癸  大运：喜申酉 忌巳午(灾凶)  备注：忌无根",
    "癸巳": "调候：喜辛壬 忌丁  大运：喜寅卯辰  忌申酉(灾凶) 备注：喜有根忌七杀",
    "癸午": "调候：喜庚壬辛 忌丁  大运：喜从火财  忌申(无根夭)  备注：忌日主无根 ",
    "癸未": "调候：喜庚壬辛 忌乙  大运：喜寅卯辰 忌刃忌官",
    "癸申": "调候：喜丁 忌癸  大运：亥子丑  忌寅 备注：忌无财局",
    "癸酉": "调候：喜丙辛 忌癸  大运：喜申未巳午  忌亥子",
    "癸戌": "调候：喜辛甲 忌丁壬  大运：喜寅卯巳午  忌亥(夭凶)",
    "癸亥": "调候：喜丙 忌乙壬  大运：喜巳午未  忌卯(夭凶) ",
}


ges = {
    "木": {
        "寅": "食伤生财：最佳  财格：      印格：无用     杀印相生：夭寿或多疾 官杀：平常   伤官配印：",
        "卯": "食伤生财：最佳  财格：      印格：无用     杀印相生：夭寿或多疾 官杀：佳     伤官配印：",
        "辰": "食伤生财：最佳  财格：较佳  印格：         杀印相生：           官杀：       伤官配印：",
        "巳": "食伤生财：      财格：      印格；婚姻不佳 杀印相生：           官杀：是非多 伤官配印：",
        "午": "食伤生财：体弱多病  财格：        印格：     杀印相生：    官杀：     伤官配印：",
        "未": "食伤生财：体弱多病  财格：佳      印格：     杀印相生：    官杀：     伤官配印：",
        "申": "食伤生财：无用      财格：佳      印格：最佳 杀印相生：佳  官杀：     伤官配印：",
        "酉": "食伤生财：贫困      财格：佳      印格；最佳 杀印相生：    官杀：最佳  伤官配印：",
        "戌": "食伤生财：贫困疾    财格：        印格：         杀印相生：    官杀：最佳 伤官配印：",
        "亥": "食伤生财：最佳      财格：        印格：         杀印相生：佳  官杀：     伤官配印：",
        "子": "食伤生财：最佳      财格：        印格：体弱多病 杀印相生：    官杀：     伤官配印：",
        "丑": "食伤生财：最佳      财格：        印格；体弱多病 杀印相生：    官杀：六亲稀少 伤官配印：",
    },
    "火": {
        "寅": "食伤生财：       财格：      		印格：      杀印相生：富而有体  官杀：体弱夭疾   伤官配印：",
        "卯": "食伤生财：       财格：      		印格：      杀印相生：最佳 		官杀：体弱夭疾   伤官配印：",
        "辰": "食伤生财：       财格：      		印格：      杀印相生：最佳      官杀：体弱       伤官配印：",
        "巳": "食伤生财：       财格：最佳  		印格；		杀印相生：          官杀：体弱		 伤官配印：",
        "午": "食伤生财：       财格：      		印格：     	杀印相生：    		官杀：     		 伤官配印：最佳",
        "未": "食伤生财：       财格：      		印格：     	杀印相生：    		官杀：			 伤官配印：最佳",
        "申": "食伤生财：       财格：佳    		印格：佳 	杀印相生：			官杀：最佳       伤官配印：",
        "酉": "食伤生财：       财格：无印困财引祸  印格；最佳 	杀印相生：    		官杀：是非	     伤官配印：",
        "戌": "食伤生财：       财格：无印困财引祸  印格：最佳  杀印相生：    		官杀：是非		 伤官配印：",
        "亥": "食伤生财：无用   财格：        		印格：		杀印相生：			官杀：无印凶有印贵     伤官配印：",
        "子": "食伤生财：无用   财格：        		印格：		杀印相生：    		官杀：无印凶有印贵     伤官配印：",
        "丑": "食伤生财：头面疾 财格：        		印格； 		杀印相生：    		官杀： 			伤官配印：",
    },
    "土": {
        "寅": "食伤生财：       财格：无用    		印格：最佳 	杀印相生： 官杀：无用   伤官配印：",
        "卯": "食伤生财：       财格：无用      	印格：最佳 	杀印相生： 官杀：    伤官配印：",
        "辰": "食伤生财：       财格：      		印格：最佳 	杀印相生： 官杀：体弱或夭折       伤官配印：",
        "巳": "食伤生财：       财格：最佳  		印格；佳 	杀印相生： 官杀：体弱多病		 伤官配印：",
        "午": "食伤生财：       财格：大富  		印格：无用  杀印相生： 官杀：聪明     		 伤官配印： ",
        "未": "食伤生财：       财格：大富  		印格：无用  杀印相生： 官杀：聪明		 伤官配印： ",
        "申": "食伤生财：       财格：独喜   		印格：  	杀印相生： 官杀：           伤官配印：",
        "酉": "食伤生财：富寿   财格：平常          印格；平常 	杀印相生： 官杀： 	     伤官配印：",
        "戌": "食伤生财：       财格：              印格：独印  杀印相生： 官杀： 		 伤官配印：",
        "亥": "食伤生财：孤寒   财格：        		印格：独印	杀印相生： 官杀：      伤官配印：",
        "子": "食伤生财：       财格：多疾夭病 		印格：独印  杀印相生： 官杀：无用   伤官配印：",
        "丑": "食伤生财：贫孤疾 财格：无用    		印格；独印  杀印相生： 官杀：无用   伤官配印：",
    },
    "金": {
        "寅": "食伤生财：无用   财格：     印格：    	杀印相生：   官杀：婚姻不佳   伤官配印：无用",
        "卯": "食伤生财：       财格：     印格：独印 	杀印相生：   官杀：不贫则多病    伤官配印：",
        "辰": "食伤生财：       财格：     印格：独印 	杀印相生：   官杀：不贫则多病       伤官配印：",
        "巳": "食伤生财：孤贫劳 财格：     印格；最佳 	杀印相生：佳   官杀：体弱多病		 伤官配印：",
        "午": "食伤生财：孤贫劳 财格：     印格：最佳   杀印相生：佳   官杀：体弱多病     		 伤官配印： ",
        "未": "食伤生财：无用   财格：     印格：佳     杀印相生：佳   官杀：身体有疾		 伤官配印： ",
        "申": "食伤生财：最佳   财格：     印格：  	    杀印相生：   官杀：           伤官配印：",
        "酉": "食伤生财：最佳   财格：     印格；    	杀印相生：   官杀： 	     伤官配印：",
        "戌": "食伤生财：       财格：无用 印格：       杀印相生：   官杀： 		 伤官配印：",
        "亥": "食伤生财：       财格：     印格：独喜夜生 杀印相生  ： 官杀：忌书生      伤官配印：",
        "子": "食伤生财：       财格：     印格：独印  杀印相生：佳  官杀：佳   伤官配印：",
        "丑": "食伤生财：       财格：佳   印格；独印  杀印相生：佳  官杀：佳   伤官配印：",
    },
    "水": {
        "寅": "食伤生财：    财格：最佳     印格：    	杀印相生：   官杀：无用   伤官配印：",
        "卯": "食伤生财：       财格：是非多     印格：无用 	杀印相生：   官杀：最佳    伤官配印：",
        "辰": "食伤生财：       财格：是非多     印格：无用 	杀印相生：   官杀：最佳       伤官配印：",
        "巳": "食伤生财：  财格：     印格；无印夭 	杀印相生：    官杀： 		 伤官配印：",
        "午": "食伤生财：  财格：体弱多病     印格：亲属孤单   杀印相生：    官杀：最佳     		 伤官配印： ",
        "未": "食伤生财：    财格：体弱多病     印格：亲属孤单     杀印相生：    官杀：最佳		 伤官配印： ",
        "申": "食伤生财：    财格：无用     印格：佳  	    杀印相生：   官杀：佳           伤官配印：",
        "酉": "食伤生财：    财格：     印格；无用    	杀印相生：   官杀： 	     伤官配印：最佳",
        "戌": "食伤生财：       财格： 印格： 无用      杀印相生：   官杀： 		 伤官配印：最佳",
        "亥": "食伤生财： 无用      财格：最佳     印格：  杀印相生  ： 官杀：忌书生      伤官配印：",
        "子": "食伤生财：无用       财格：最佳     印格：   杀印相生：   官杀：佳   伤官配印：",
        "丑": "食伤生财：食神制杀贵       财格：佳   印格；   杀印相生：   官杀：佳   伤官配印：",
    },
}

siling = {
    "寅": "立春后戊土7日，丙火7日，甲木16日 立春、雨水。",
    "卯": "惊蛰后甲木10日，乙木20日。 惊蛰、春分。",
    "辰": "清明后乙木9日，癸水3日，戊土18日。清明、谷雨。",
    "巳": "立夏后戊土5日，庚金9日，丙火16日。立夏、小满。",
    "午": "芒种后丙火10日，己9日，丁火11日 芒种、夏至。 ",
    "未": "小暑后丁火9日，乙木3日，己土18日。小暑、大署。 ",
    "申": "立秋后戊己土10日，壬水3日，庚金17日。立秋、处暑。",
    "酉": "白露后庚金10日，辛金20日。 白露、秋分。",
    "戌": "寒露后辛金10日，丁火3日，戊土18日。寒露、霜降。",
    "亥": "立冬后戊土7日，甲木5日，壬水18日。立冬、小雪。",
    "子": "大雪后壬水10日，癸水20日。 大雪、冬至。",
    "丑": "小寒后癸水9日，辛金3日，己土18日。小寒、大寒。",
}

xiuqius = {
    "寅": {"金": "囚", "木": "旺", "水": "休", "火": "相", "土": "死"},
    "卯": {"金": "囚", "木": "旺", "水": "休", "火": "相", "土": "死"},
    "辰": {"金": "相", "木": "囚", "水": "死", "火": "休", "土": "旺"},
    "巳": {"金": "死", "木": "休", "水": "囚", "火": "旺", "土": "相"},
    "午": {"金": "死", "木": "休", "水": "囚", "火": "旺", "土": "相"},
    "未": {"金": "相", "木": "囚", "水": "死", "火": "休", "土": "旺"},
    "申": {"金": "旺", "木": "死", "水": "相", "火": "囚", "土": "休"},
    "酉": {"金": "旺", "木": "死", "水": "相", "火": "囚", "土": "休"},
    "戌": {"金": "相", "木": "囚", "水": "死", "火": "休", "土": "旺"},
    "亥": {"金": "休", "木": "相", "水": "旺", "火": "死", "土": "囚"},
    "子": {"金": "休", "木": "相", "水": "旺", "火": "死", "土": "囚"},
    "丑": {"金": "相", "木": "囚", "水": "死", "火": "休", "土": "旺"},
}

days60 = {
    "甲子": "天德贵人日。坐子、沐浴，逢官临桃花。\n白玉仙子捧印来，一举成名天门开。\n贵人不向西方去，烽火空负旷世才。\n辛为正官，庚为偏官，戊己为财，见甲乙为破财，丙丁伤名利艰难，生在子月，无丑合，离祖自立，亥卯辰月主贵，巳月平常之命，午月甲死子神冲，他乡立业。申月，子嗣难有。辰月，移根换叶。亥月，文章显达。",
    "甲寅": "天禄贵人日。坐比肩，食神，临官禄。\n禄到人间最为奇，千秋功业酬白帝。\n田园风光好福气，春江月夜柳丝垂。\n双木并排，见寅月，孤克，二三妻，见申酉月大贵，卯月，身太旺破财，巳月，犯刑，亥月，早步帝阙，子月拱丑，贵。午月，会东方火局，才华超群，辰月，广置阡陌。",
    "甲辰": "龙守财库日。坐偏财库，临衰。\n身坐财库一世荣，慷慨风流人多情。\n财团公司善交际，官星透显管万民。\n子月，水多木飘，主移根换叶。申月、贵，酉月，富贵双显。午戌月，主富，卯月，羊刃主败财。丑月富厚有财，亥月透官，最贵。寅月，龙虎拱月，叫龙吟虎啸。",
    "甲午": "龙马奔驰日。坐死、伤官、财地、进贵日。\n龙马交弛好福气，娇妻美女喜北地。\n八月桂花香千里，春风丽日相依依。\n子月，冲午，鸳鸯难合。亥卯未月，贵显。午月，自刑，见亥子，主富。丑月，身弱，见火贫。寅月，得申酉吉，火月劳碌贫夭；卯月，财不聚；申酉月，武职得权。",
    "甲申": "龙虎夺魁日。坐绝，临杀化印。\n跃马横戈驰天涯，秦山楚国帅府家。\n儿女手足喜相逢，斩将夺关壮士夸。\n生于子月，印化煞，贵。亥卯未月，都贵，申月申时，死，夭命。丑月，带疾，辰月，孤独或僧道。巳月，清贫，敦厚聪明，且有刑。午月，艺业成名，酉月，先贵有疾，一成一败，亥月，文章显达。",
    "甲戌": "青龙献艺日。坐养，临偏财，伤官。\n一世荣华走他乡，千般艺技样样强。\n官星印星来捧上，风流多情歌舞场。\n子月，书海成名。丑未月，冲刑灾，多病。寅月贵，工作好，对妻不利，丑月，大富，巳月名利两全。午月，富而贵。辰月，僧道清高。亥月，艺人，功名不遂。戌月，背禄逐马，鸡鸭同鸣。甲临戌，财库，富贵双全日。",
    "乙丑": "玉女佩珠日（丁为玉女，丑为珠）。临衰，坐枭与偏财，将星。\n身坐金库财福秀，衣禄荣华样样有。\n金水相涵好文章，东方西方对面谈。\n生于子月，丑合，贵，丑月，带疾；寅月，寅中丙火克庚金官星，不禄。申酉月，无火，寿长。寅卯月败财。辰戌月，富贵。亥子月，诗文扬。巳午月，福寿。戌月，清秀厚道，财富丰盈。",
    "乙卯": "风云相会日。坐禄，临比肩，爵位，天乙贵人。\n身坐爵位人称羡，功名显达列朝班。\n苍海珠玉会雨露，青山白云流水远。\n子月，偏印，文笔命，喜食伤生财，土月富，亥月，辛官，武职勋业。寅卯月，财绝，僧道有缘。巳午月，破财，申酉月显赫。戌月福而寿。未月财富丰盈。",
    "乙巳": "木火生辉日。交贵，驿马，正财，成名。\n刚愎自用又聪明，财官同见公候命。\n文才武略怕青龙，兴旺成败一刻中。\n子月，文才出众，一生劳碌。申月，官得生，近臣。丑月，武职建奇。亥卯月，通根见官杀贵。未月，有福，营商发财。巳午月，妻病或离别。申酉月，带疾，肝胆病。亥月，文章出奇。戌月，入墓，富而寿短。",
    "乙未": "财福日。临财，坐养。也叫福贵目。\n天元坐福人聪颖，得官逢比赛富翁。\n丝绸路上愁石榴，春色秋花雨蒙蒙。\n子月，平常命。未月，孤刑，申酉月，肾病，阳痿，女姓有妇科病，亥月，大贵。辰戌丑月，福商巨贾。午月，声名天下，夏月生，平常，冬生，寿长。巳月，功名难遂，艺业生涯。",
    "乙酉": "龙凤呈祥日。（生于酉月为贵为蒙难日）坐绝，将星。\n春花江水落凤霞，南北扬名匡天下。\n南方一去坐金殿，玉石翡翠泪花花。\n子月，生身，逢财星，吉。寅卯月，显贵。午月，艺名生涯。申月，贫命，劳碌。酉月，自刑，伤禄破命目疾，主灾，行印运时吉。亥月，喜财星，田园丰盛，巳月败散祖业，乙酉，多伤残。",
    "乙亥": "名利双成日。坐死，临正印，劫财，文星贵人。\n玉兔月桂喜官星，亲姻朋辈重友情。\n青竹流水郁葱葱，太阳投江重复行。\n子月，主有富，喜官杀显贵。亥月，自刑。午月，贵命，千荷夏日鲜。寅卯月，财星透，富寿。申月，得官。巳月，天涯风尘。戌月，艺道成名，干戈阵前之命。酉月，伤官，贵，死于非命。",
    "丙子": "漓江照彩日。临胎，正官，喻文曲星，天官贵人。\n彩照山川凤呈祥，年少成名坐华堂。\n日落江河人堪伤，东彩西虹任君想。\n子月，逢印，贵。土月，企业财团。寅卯月，学业有成。午月，贫，自立家业，兄弟难依。申酉月，经济有方。亥月，有疾，夭。子月，不禄，心脏疾患。丑月，透财贵。巳月，刑灾，大肠患疾。辰月，官星暗藏，超群出众。",
    "丙寅": "红日东升日，坐长生，枭印，食神。\n山川秀丽柳丝青，人生最喜烟霞景。\n莫向离情虎山行，西南一去幽幽命。\n酉月，正财，透财贵显。寅月，贵而不长久。卯，见财星福，官星显贵。申月，财官双显。未月，主福。戌月，衣禄平常。亥子月，六品之贵，巳午月，肠胃或肺疾。",
    "丙辰": "火照龙潭日。临官，食神旺，正印。\n日坐福神受皇恩，高官厚禄子孙兴。\n平生享尽人间福，女命穿金又戴银。\n戌月，冲，财门开，富命。辰月，僧道或孤。寅卯月，贵。丑未月，富厚。亥子月，贵格。申酉月，行火运，官至二三品。午月，两三妻，福禄两全。",
    "丙午": "天河落彩日。坐劫地，伤官，羊刃。\n人逢帝座爵士身，功名仕途显达人。\n苍龙水火多有厄，细雨蒙蒙入燕门。\n巳午月，平常命。亥子月，武官，功名挫蹬。午月，贫，倒冲子贵。寅月，三合局，文上显赫。卯月，喜行财星，贵而富。戌月合伙，商人。辰月，实业主。申酉月，财富商贾。",
    "丙申": "火照金城日。病地，偏财，临杀。\n身临财官显声名，且防比刃杀伤临。\n马逢帝旺临官处，堆金积玉立大功。\n子丑月，血疾，申月，文章有名。酉月，妻妾有情。子辰月，带疾，亥月，喜财。午月，一生吉庆无病，长寿。寅卯月，官荣身。未月，虽富肠胃有病。丙申日，遇岁运刑冲，必生灾祸。",
    "丙戌": "天厨贵人日，坐墓，福神财地。\n玉堂厚禄寒门出，金银珠宝西方路。\n日落深潭闯鬼门，金榜题名显双亲。\n生于子月，福寿延，有名有利，地支巳午戌月，富贵双全。申酉月，大富，财团。辰月冲，少年名显。亥月，武职，六品。丑月，一般经济人。辰月，身旺得职，身弱贫*。",
    "丁丑": "玉女守库日，坐墓，临财。\n一轮满月彩画鲜，金银满库禄高迁。\n丽人不行东南地，洁肤玉身受熬煎。\n丑月，财透干，富。寅卯月，印，学士命。巳午月，妻迟，二婚，破财，一生辛劳。申酉月，金银满贯，戌月刑灾，财去财散两空空。亥月，喜行南方火运，名利有望。子月见火，戎马空忽。",
    "丁卯": "月照蟾宫日。临偏印，坐病。（虚名虚利）\n日坐偏印身自强，西风不吹日惆怅。\n驿马交驰到财乡，山斗文章盖一方。\n寅卯月，印绶，喜行官运，寒门将相。辰戌丑未月、孤星，妻不顺，财不聚。巳午月，夫妻缘份薄，艰苦。午月多婚，贫，夭，申酉月，名利双贵。子月，武职。亥月，文职显耀。",
    "丁巳": "朱雀跃辉日。坐帝旺，劫财，伤官，正财。\n谢女才高满词馆，等闲平步出少年。\n旌旗蔽日入凤阕，火焰马疲怨高山。\n午月，长生，文章显奇。巳月，禄贵。寅卯月，透官星，一品大贵。辰月，商海有名。未月，贵格，申酉月富命。戌月，无福，见癸水，伤目近视。亥月，常常外出。",
    "丁未": "人立画桥日，坐冠带，食神，比肩，偏印。\n食神生旺胜财官，天河画桥拜金殿。\n巽风相伴云雨水，太阳夺辉苦贫寒。\n子月，沙场立功。丑月，外出经商，妻多离别。寅卯月，金堂玉马。巳午月，破祖业，自立家门。申月，财官双美，酉月，大富。辰月，杂气官旺。亥月，将相。丁未，性强，人贵，凶险多。",
    "丁酉": "玉女乘凤日。坐长生，临偏财。\n朱雀乘凤显英豪，金车玉凤福寿高。\n贵人龙马东方起，太阳升时漫徒劳。\n亥月，贵人捧印，酉戌月，犯刑，骨肉无情，因财分张。子月，杀旺，喜行土运，午月，干强，财旺，未月，衣禄平常，申月，财多身弱，富室贫人，戌月，技术生涯。",
    "丁亥": "月照天门日。坐胎，临正印，正官。\n词馆文章早荣身，驿马七杀风尘人。\n最喜荷花并蒂开，金水文章佐朝君。\n亥月，贵且富。子月，行木运，金戈铁马。戌月，冲，技艺精湛。寅卯月，贵而显耀。巳午月，自刑，小商。申酉月，利路绵绵。子月，带疾。辰月，专业技术成名。",
    "戊子": "山环水抱日，临胎，坐正财。\n水绕山环明月光，烟花影中福高享。\n勿贪关城槐山梦，江海浮云一空束。\n子月，喜行火运，福。丑月，聪明，主富贵。寅卯月，弱，病或夭亡，喜火土。巳午月，巳禄，印，午刃，喜行食伤富贵。申月，食旺，贵。酉月，伤名望。土月得才，富贵。亥月，虚秀，财帛不聚。",
    "戊寅": "虎啸山谷日，临长生，坐杀，偏印。\n将星入命立武功，猛虎纵风显英雄。\n印绶财官悬天门，南征北战旅马行。\n卯月，寅月，鬼旺，多疾或夭。巳、午月，印，诗文会海，兵权万里。申酉月，不禄，伤功名，土月，富。亥月，子月，商贾大富。",
    "戊辰": "苍龙出海日。临冠带，正才，比肩，正官。\n月洒高山江山秀，平生最喜东南游。\n一生辛勤贵不显，为人热心福气厚。\n子月，财旺，目盲，无火，虚而不实。丑月，财少，人聪明。寅卯月，官星，身荣。辰月，财不聚，孤克。巳午月，学业二次成名。申酉月，艺名四方。戌月，冲，少年出众。亥月，多疾，子月，无根，漂荡，技艺超群。",
    "戊午": "马奔午门日。临羊刃，正印。\n日月分秀福气隆，杀官相见主武功。\n平川一去前程远，戎马西洲比陶公。\n子月，名利双收，丑月，财旺。寅卯月透干，朝野重臣。午未月印，锦绣文字，透官显贵。申酉月，企业财团董事。戌月财少，平常，孤克。子月，外乡立实。祖业无*，六亲冷落，亥月，大富，刃旺，性强，人虽贵，凶险多。",
    "戊申": "霞落花簇日。临病，食神，偏财。\n日坐福星声名显，万卷诗书朝天关。\n骑驴走马炉中火，风云雷雨步金殿。\n寅月，冲禄，财旺。子月，财旺，印旺，贵，丑月福，爱酒色，固执。卯月，合食，名利双显。辰戌未月，土气专旺，不聚财，肾病。巳午月，事业沉浮不定多变动。申酉月，专业致富。亥子月，大富。",
    "戊戌": "溪绕画亭日，坐墓，临正印，比劫。\n热情憨厚心似海，白帝玉女捧印来。\n溪绕画亭芳香名，田园平川云天外。\n子月，显贵聚财。丑未戌月，刑灾，有破。寅卯月合印，诗文成章。申酉月，堆金积玉。亥月，冲，心神不定，异地创业。",
    "己丑": "金牛拜金殿。临墓，坐比肩，食神，偏财。\n一柱佛香拜金殿，艮山流水芳名显。\n金匙开得丑戈库，富贵荣华醉管弦。\n亥月，伤官尽，贵，有权威。寅月，贵显。卯月，兵权显赫。申月，庚为背禄。甲绝未月，冲，发迹，肾病。午月，冲，妻有厄。巳月合金，商贾巨富。辰月，孤身。子月，仓库充盈。",
    "己卯": "武跨将坛日，临衰，坐七杀将星。\n将士佩弓跨战马，暮雨风月渡年华。\n文星福禄若有情，北国回首似到家。\n酉月：卯酉冲，一生多迁移，妻离。申月，早发迹。亥月，贵。未月，合，五谷丰登。午月：诗满乾坤。巳月，文秀。辰月，能建功立业。子月，无礼，凶暴。",
    "己巳": "马跃平川日，临帝旺，坐偏印，比劫。\n南朝天子绶玉印，千里长江醉游人。\n雪山草地马难行，春风得意座上宾。\n巳为印，旺，巳月，金神，忌财，喜食伤。午月，显贵。土月，候伯命。申酉月，喜印运，伤尽为武职。亥月，一品贵，有兵权。子月，食伤运大富，辰月，先贫后发。己巳日，人贵。",
    "己未": "丹桂漂香日，临冠带，坐比肩，枭印。\n月中桂子秋飘香，江河日月交相映，\n莫道高山芳气散，二月春风论短长。\n亥月，文章夸跃，清高，酉月，大贵。辰月，小职，近卫。申月，财福充盈，未月，财金散失，午月，合，清贫儒雅。巳月，喜官显贵。辰月，寒门将士。",
    "己酉": "凤飞绿洲日。临长生，坐支食神。\n一轮满月出苍海，金凤展翅飞天外，\n秦山昆仑雪皑皑，龙凤呈祥玉珠来。\n亥月，身弱，贫，寅卯月，有火，武职，酉月，高贵之命，酉多游方术士。申月，无官显贵。未月，大富。巳月，富贵陶朱。子月，食破，贫寒。",
    "己亥": "平川流水日。临胎，坐支正财，正官。\n禄马同乡拜玉堂，天堑通途文星扬。\n沉影不随流水去，杀星冲动马无疆。\n亥月，财显，官旺，贵。酉月，食神，财旺，申月，干透印，大贵。未月合武职。已月，冲，外迹发愤。子月，多病，血疾。寅卯月，支中鬼旺，一生难成大事。印透大贵。",
    "庚子": "金玉出海日，临死，坐支，伤官。\n能歌善舞笔和墨，犹如白虎戏江水。\n冲在禄马登科甲，斑竹细雨伤情泪。\n子月，衰，伤官，无土运，鬼旺，风烛夭*。丑月，虚名，轻财。寅月，偏财，不禄。卯月，合财，金玉满目。辰月，利路经商。巳月，武职显跃。午月，文官近卫。四季月，印旺富而有名，亥月，漂蓬，僧侣。",
    "庚寅": "白虎镇山日，临绝，坐支偏财，七杀，偏印。\n平川猛虎归山林，秋风落叶时不宁。\n最喜大雪封山时，三夏浓荫卧孔明。\n子月，食旺，身衰，比劫扶吉。寅月，清秀，命高。卯月，富不长久。辰月，富而贵。巳月，鬼暗藏，有印，职荣。申酉月，钱财聚散浮沉，戌亥月，董事财团。",
    "庚辰": "福德贵人日，临养，坐支偏印，食神。\n命带魁罡性刚强，不信鬼神在身旁。\n玉佩娇阳入命来，执戈跨马佐高皇。\n丑月，富而有名。子丑，文才出众。寅卯月，财福寿促，午月，发迹有疾患。巳月，一生艰辛，未申月，财运发迹。酉月合，透官星，荣显。亥子月，食神旺发迹难寿。庚辰，贵而风流，名重利轻。",
    "庚午": "火铸金印日，临沐浴，支坐正官印。\n铁笔一只水为墨，淡彩浓云笔下绘。\n学苑将士两般命，山野朱雀衔玉翠。\n丑月有名声，辰月，自刑，富而有刑。寅月，火旺，带残疾，肺有疾患。卯月，财旺，大富之人。子月冲，天涯艺海。申酉月，日贵，垂手青云。",
    "庚申": "双虎奔驰日。临官禄，坐支比肩，食神，偏印，又叫虎恋玉女日。\n白虎交驰向南行，雀跃江河早成名。\n禄到长生官得地，九重露雨沐朱衣。\n庚月，透火，大贵之命。亥子月，诗词清畅流韵。申酉月，无官星。贫而*。寅卯月，财满三峡。已午月，官至侍郎，七杀，金戈铁马。",
    "庚戌": "禄马贵人日，临衰，坐支正官，偏印。\n将军百战不论功，高山流水又出征。\n西去阳关知音少，前禄后福两三重。\n辰月，冲，平常之命。卯月，合，因妻发福。寅月，候王之命。丑月，财旺官升。巳月，火官，武职操权，有惊险。午月文职。难善终。申酉月，财来财散，散聚两依依。亥子月，文笔超群。",
    "辛丑": "白玉生辉日，临养，支坐偏印，食神，比肩。\n白玉生辉金门客，高山得贵子为墨。\n身入平川多愁叹，干弋影里勋业垂。\n子月，食神，荣华。丑月，伏吟，鸳鸯难合。寅卯月，财聚官旺。巳月，早遂名香，辰月显达，有名利。午月，凶。申酉月，逢官星，贵，少年坎坷。土月，平常。亥月伤官，一文鸣天下。",
    "辛卯": "凤阙早步日，临绝，支坐财，伤官，驿马，冲禄。\n高山起程水流长，边塞迢迢雪满霜。\n佛山玉女岂有情，雪山日照花海棠。\n辰月，伤官伤尽，自立自成，技艺，卜相，医生。寅卯月，合，财丰。巳月，冲，文星出众。午月，自刑，先荣后刑。未月，富。申月，贫，人生不定。酉月，多争论。子月，食旺，福旺。亥月，伤官。技业成名。辛卯，偏财，为福贵双全日。",
    "辛巳": "金马登殿日，临死，坐支正官，正印，劫财，驿马。\n金马临官号嘶风，玉堂拜相翰苑名。\n最喜高山水环绕，娇阳日出漫消魂。\n子月，食旺，名显。丑月，合，妻少缘，财淡。寅月，因财有刑。卯月，横财。巳月，金长生，化水名显。午月，暗鬼有疾。申酉月，贵中有失。亥月，冲，双贵。",
    "辛未": "冰河解冻日，临衰，支坐枭印，偏官，多情忘义。\n身入西国佛香地，漫歌轻舞管弦醉。\n玉女传送风流人，高山日出彩画新。\n申月，在贵人门下得富。酉月，又贵又富。辰月，库印，冲，清雅儒士。巳月，文月，武操重权，子月，富门贵显。丑月，经济商，云游。亥月，双贵。",
    "辛酉": "凤卧金山日，临禄，支坐比肩，天乙贵人。\n禄马贵人世少有，凤卧金山将帅候。\n日出朝阳横天行，月圆金门寻石榴。\n申月，劫财，一生财不聚。酉月，比肩，财逢劫。子月，福寿名高，巳月，损妻。寅卯月，财气通门户。巳月，合，名扬四海。午月干弋剑影，未戌月，清贫，亥月，富而有刑。",
    "辛亥": "虎行天门日。临沐浴，支坐伤官，正财，驿马。\n一去天门遥遥远，长亭驿路关山寒。\n倒骑毛驴东行去，高山丽日花团团。\n申月，发福。带疾。酉月。破禄，多磨。寅月，富商。卯月财团。巳月，冲，天涯游客。午月，武功建奇。土月，有官职。亥月，误入商海。",
    "壬子": "马奔天河日，临帝旺。支坐劫财。\n壬水浩浩漫天下，行入东方福到家。\n江南平川鱼米乡，云雨湖海镜中花。\n子月，平常人。丑月，官星，人清秀。寅月，大富贵。卯月，刑，妻离。辰月，官库，无冲不发。巳月，午月，利路经商。申酉月，文章璀灿。戌月，权重。亥月，贫。",
    "壬寅": "福禄日，临病，支坐食神，偏财偏官。\n虎跃天河威名扬，犹如箕豹出山岗。\n禄到长生官得地，九重雨露沐朱衣。\n卯月，破财，有成有败。土月，吉。午月，正官，荣华显贵。申月，冲身弧，奔波人。酉月，风流才子。戌月，财旺。亥月，财有根富命。子月，因财有破。壬见寅为食神，号富贵双全日。",
    "壬辰": "山流水长日，临墓，，支坐偏官，劫财，库地，虚名虚利。\n江水流芳美如画，杜鹃啼血巫山峡。\n月下骑马走平川，一日尝尽牡丹花。\n子月，成中有败，多凶。丑月辰戌未月，俱贵。寅月，食旺，人骑龙背，名流，财旺。卯月，清雅人。巳、午月，广置庄园。申月，奔劳，走乡串野。酉月，合，文上有名，才子。亥月，主掌权。",
    "壬午": "花红柳绿日，临胎，支坐财，正官，驿马。\n禄马相邀入帝乡，花红柳绿掩高堂。\n出阕最喜函玉关，千里迢迢雁北上。\n子月，月日冲，外乡立家，难团园。丑月，禄旺，贵。寅月，贵而多疾。卯月，富贵双显，巳月，财旺，喜印地，午月自刑，夭疾，比劫扶，吉。未月，大富。申、酉月，状元及第。土旺四季，主权。亥月，身旺，财旺。",
    "壬申": "白虎渡江日。临长生。支坐偏印，偏官，劫财，驿马。\n命似白虎渡长江，最怕风雨江水涨。\n丽日跨入平川地，金枝玉叶陪身旁。\n子月，劫财，合水，一生奔波，贫。酉月，偏旺，带疾，弧身。亥月，刑，破财，见官星，大富。丑月，官星，行财运，清秀，禄贵。寅、卯月，食旺，富贵双全。巳、午月，身坐学堂，名利驰驱。申、酉月财帛进退。土月，贵。",
    "壬戌": "龙出苍海日，临冠带，支坐正财，偏官，正印，火库。\n身坐火库水得福，西行东邀人间苦。\n壮士难酬青云志，醉看少女漫歌舞。\n子月，有疾。丑月，人贵显。申月，枭印，劫财，亲姻难全。酉月，印绶，文印齐来。寅月，合，滋生荣茂；卯月，伤名，异路乘凤。巳月，英豪透发，午月，贵显双亲。辰月，青龙飞跃。亥月，兰蕙不禄。",
    "癸丑": "桑柳成荫日，临冠带，支坐偏官，印，比肩。\n池塘桑柳满园色，二月春风柳絮飞。\n莫怨高山运来迟，干戈影里是翡翠。\n午月，冲，财旺，福。未月，主贵。子月，合，功名显达。丑月异常出仕。寅卯月，伤食旺，艺海生涯。巳午月利路经商。四季土月，平平，残疾。申酉月，科场功名，亥子月，决战千里。",
    "癸卯": "天姿文秀日，临长生，支坐食神。\n学堂词馆贵人命，天姿文秀人多情。\n最喜三星相拱照，诗琴歌乐官弦声。\n子月，刑，无礼德，对妻不利，但平步青云。丑月，贵，奇显。寅月，艰难人生。卯月，人生富庶。辰月，财帛富月，父母难*。巳月富而有残，午月，一生财丰。申月，书香早遂，酉月刀笔成名，冲，鸳鸯离合。土月主贵，亥月，名利双全。",
    "癸巳": "彩霞佩玉日。临胎，支坐正财正官，驿马，文星。\n贵人玉堂来拜相，墨池泉涌好文章。\n武士跨马走天下，王公皇候似平常。\n巳月，财官双美，诗书琴画。午月，中年大富。申酉月，终生劳累，透官。丑月，秀气。辰月，山明水秀，红粉生涯。",
    "癸未": "贵人佩玉日。临墓，支坐偏官，偏财。\n日临官库将相命，男子英勇女贵荣。\n西方一去福禄地，花园翠亭马不行。\n子月，青云得路，贵。丑月，暗鬼冲伤。婚有变。寅月，秀贵，一生顺利。卯月，武职平常。辰月，富而秀贵，巳月，富而且有肺疾。未月，男女无子女，阳痿。申酉月，文字生发。亥月，财发。",
    "癸酉": "天福日，临病，支坐偏印。\n潇洒功名起一方，一冲一合异寻常。\n江湖花洒安享福。南去高山势莫档。\n亥月，生涯遂心，风流。戌月，平常，善智谋。酉月，得祖业，破财。申月，印旺，文上出仕。寅月，艺技生涯。卯月，冲，印破，大富。巳月，富商。午月，生意人。申酉月，金水相涵，文秀。子月，印破，不禄，平常命。",
    "癸亥": "天门悬彩日，临帝旺。支坐伤官。劫财，驿马。\n九华山上天门开，日行东方花似海。\n若去西方昆仑地，边塞将士恋故国。\n未月，合木，贵。在外终。子月，妻离异，财分张；亥月，劫财，一生无正业，散业。四季土月，有作为，决战沙场。寅卯月，财团经营，或艺名天涯。巳午月，大富。癸亥，命薄，多贫。",
}

chens = {
    "子": "子时初\n值此运如何，作事进退多，初年财未至，末限足财宝。\n子时初先克母，为人性急，首妻难招，长子有克，六亲冷淡，兄弟不和，作事进退，初年不济，末限好，宜手艺吉。\n\n子时中\n衣禄自然兴，一生近贵人，为官作宰相，富贵大家声。\n子时中父母在，为人一生快乐清闲，衣禄不亏，兄弟有分，子息可招，六亲大旺，不能登祖业，出外主有大财。\n\n子时末\n生逢子时末，初年运未通，六亲无倚靠，兄弟两西东。\n子时末先克父，为人性宽，六亲兄弟无力，子息两硬，初年辛苦，作事有头无尾，主离祖过房，重拜爹娘。",
    "丑": "丑时初\n生逢初丑时，衣禄积有余，为人官职分，田产福安居。\n丑时初父母双全，二十前无刑克，二十后进田庄，文武皆通，为人近贵，有头目分，六亲得力，兄弟有权，好子息。\n\n丑时中\n生来发达迟，为人最辛苦，财禄随时进，逢喜又逢吉。\n丑时中先克父，衣禄平平，为人心行公道，早年辛苦，末运好，三十八九后发财，兄弟难为，六亲冷淡，离祖可白手兴家。\n\n丑时末\n先克母，为人辛苦，一生大事成，六亲兄弟无力，子息得力，衣禄中平，初年辛苦，四十后发财，末限胜前。\n为人丑时末，一生好风光，财来无克破，学术手艺成。",
    "寅": "寅时初\n生来遇大耗，二女皆刑吊，床头十文钱，床尾鬼来叫。\n寅时初先克父，为人近贵，凶事成吉，早年劳苦，三十年奔波，三十七岁后好，六亲冷淡，兄弟清疏，子息大用，有子送老。\n\n寅时中\n宅舍好风光，生来大吉祥，一生常快乐，把笔作文章。\n寅时中父母具全，为人作事有权柄，衣禄不亏，六亲有分，兄弟施为，子息二三，为人有志诚不苟。\n\n寅时末\n寅时末事多，身安心又劳，一生多疾厄，小船水上漂。\n寅时末先克母，六亲无力，头子难招，兄弟不和，初年辛苦，三十六岁过发财，末限胜前，衣禄平平，作事进退。",
    "卯": "卯时初\n卯时初刻生，为人最苦辛，衣食随时度，悲喜送相生。\n卯时初先克母，为人作事有始无终，兄弟少力，六亲难为，宜离祖过房，初年奔波，刑克子息，不真不假送老。\n\n卯时中\n住居大高堂，兄弟有主张，一生享富贵，文武近君王。\n卯时中父母双全，三十年父母在，男人居官，女人有福，一生近贵，女人益夫，六亲兄弟有力，子息不亏，衣禄有余。\n\n卯时末\n时末走途程，辛苦又劳神，晚年时运至，财禄积门庭。\n卯时末先克父，作事本分，初年不遂劳碌奔波，离祖过房，兄弟无靠，自整门风，六亲冷淡，骨肉情疏，末限胜前。",
    "辰": "辰时初\n衣禄自然来，兄弟六亲林，父母难刑克，晚景更无忧。\n辰时初父母在，为人性急，六亲有力，长子难招，兄弟不和，心慈善，宜手艺营生，初限平平，四十二岁后渐好。\n\n辰时中\n衣禄得人抬，先忧后吉来，六亲虽冷淡，末限足钱财。\n辰时中先克父，为人心行公道，性急直燥，出入有贵人扶持，离祖成家，六亲兄弟情疏，初年不济，末限胜前。\n\n辰时末\n衣禄自然有，朱紫作朝郎，一朝命发达，富贵有名声。\n辰时末先克母，为人聪明，衣禄丰盈，大有声名，六亲大旺，兄分有顾盼，为官头目之称，女命益夫，旺子福禄双全。",
    "巳": "巳时初\n宅舍好风光，宜早学文章，女命有权柄，男命作朝郎。\n巳时初先克母，为人衣禄有，六亲小力，兄弟难靠，长子难招，夫妻有克，初年奔波，末限大利，女命益夫。\n\n巳时中\n时中无克破，一生积钱财，因公得财物，出外好安排。\n巳时中父母俱全，一生近贵，财禄足用，兄弟有分，子息和顺，作朝郎，师术，头目之分，大事成小，慷慨之命。\n\n巳时末\n要行千里路，心急马行迟，围棋如天火，放下不能知。\n巳时末先克父，为人近贵，做事一成一败，子息难为，六亲冷淡，早年灾晦，辛苦奔波，末限胜前。",
    "午": "午时初\n午时自有威，出入有人随，一生常受用，上马贵人超。\n午时初父母双全，为人利害近贵，六亲和，兄弟有靠，子息三五枝，衣禄无亏，为官作吏之命。\n\n午时中\n生来不自由，衣禄财少求，奔波忧恼至，浪子度春秋。\n午时中先克父，衣禄平平，辛苦奔波，三十岁后渐渐好，女命益夫，男命先难后易，六亲少力，一成一败之命。\n\n午时末\n妻儿父母忧，财帛不能求，前程虽有分，必是苦中求。\n午时末先克母，为人性急，六亲无靠，兄弟少力，头子难招，聪明伶俐，早年晦气，奔波，末限荣华。",
    "未": "未时初\n出世好良时，威权自有余，命中身带贵，必到凤凰池。\n未时初父母双全，为人近贵，一生安乐，六亲得意，兄弟无亏，男子头目之命，女人益夫，知轻识重。\n\n未时中\n衣禄自然随，风光小事为，文章须有贵，眼下要维持。\n未时中先克父，一生性宽近贵，六亲少力，兄弟有情，衣禄平平，初年奔波，克首妻，子息难为，末限胜前。\n\n未时末\n财禄随时求，人情好便休，悲忧连一喜，慷慨汝为头。\n未时末先克母，为人一生近贵，衣禄平平，一成一败，初年辛苦，六亲少力，兄弟不和，子息俱硬，末限胜前。",
    "申": "申时初\n生来命运高，家中多富豪，早登科甲第，麻衣换锦袍。\n申时初父母双全，为人聪明近贵，文武皆通，六亲有禄，兄弟子息有得力，田产广置，女命益夫旺子。\n\n申时中\n却是有名人，亲疏弟没情，自来时运至，依旧败家声。\n申时中先克父，六亲不和，兄弟少力，一忧一喜，初年劳碌奔波晦气，早婚刑克，晚景好，离祖吉。\n\n申时末\n衣禄自然兴，机谋件件能，为人多计较，作事有谋成。\n申时末先克母，兄弟六亲冷淡，早年辛苦，主招破相，三十岁平平，四十后方好，胜前。",
    "酉": "酉时初\n家舍是光辉，朝中着紫衣，度民连夜喜，文武贵人提。\n酉时初父母双全，一生利官近贵，文武皆知，六亲有靠，兄弟难为，子息可为，头目官之命。\n\n酉时中\n衣禄不为亏，声名报晓鸡，朝夕惭惶泪，且做别人儿。\n酉时中先克父，为人性宽，兄弟不利，长子难招，早年不遂，末限好，男刑妻，女克夫，离祖过房。\n\n酉时末\n衣禄好安排，人情事可谐，为人心性好，作事有时来。\n酉时末先克母，衣禄平常，兄弟少力，初年晦气辛苦，三十七岁发财，夫妻刑克，男子迟能，女子淫乱，克子。",
    "戌": "戌时初\n慈心行公道，浮财入手来，且有自作力，常得贵人抬。\n戌时初先克母，为人性急心慈，手足不得力，作事有权柄，六亲平常，初年奔波辛苦，三十七八岁发财，衣食好。\n\n戌时中\n平等心无漏，生来本有防，胆有天来大，开口作颠狂。\n戌时中先克父，六亲兄弟少力，夫妻刑克，长子难招，早年奔波劳苦，四十二后渐好，衣禄平平，晚景有旺。\n\n戌时末\n衣禄自安然，平生福自宽，凡事如心意，福享泰锦人。\n戌时末父母双全，为人性急，文武皆通，六亲兄弟有靠，只宜手艺，学术精巧，夫妻偕老，离祖则吉。",
    "亥": "亥时初\n命带自然有，初运未通，一朝时运至，白手整家风。\n亥时初先克母，为人性宽，六亲少力，手足情疏，子息二三，一生近贵，衣禄平常，初年欠遂，末限胜前。\n\n亥时中\n有事会谋施，生来福自余，心好存公道，衣禄更无亏。\n亥时中父母俱全，为人聪明性急，亲戚平和，兄弟子息有分，女秉男权，末限胜前，兴家之命。\n\n亥时末\n衣禄自难量，男女带克伤，夫妇无良德，二姓子相当\n亥时末先克父，为人性燥心慈，六亲少力，兄弟难为，早年劳苦，男克二妻，女刑三夫，末限好。",
}
