"""Model deployment constants for Fiddler AI platform.

This module defines constants for model deployment and artifact management in Fiddler.
"""

from __future__ import annotations

import enum


@enum.unique
class DeploymentType(str, enum.Enum):
    """Model deployment types for explainability services."""

    BASE_CONTAINER = 'BASE_CONTAINER'
    """Base container deployment with standard environment."""

    MANUAL = 'MANUAL'
    """Manual deployment configuration."""


@enum.unique
class ArtifactType(str, enum.Enum):
    """Model artifact types for deployment."""

    SURROGATE = 'SURROGATE'
    """Surrogate model artifact generated by Fiddler."""

    PYTHON_PACKAGE = 'PYTHON_PACKAGE'
    """User-provided Python package artifact."""
