# Fides module

The Fides module is an essential component of the Global P2P system in Slips.


Traditional network defense systems depend on centralized threat intelligence, which has limitations like single points of failure, inflexibility, and reliance on trust in centralized authorities. Peer-to-peer networks offer an alternative for sharing threat intelligence but face challenges in verifying the trustworthiness of participants, including potential malicious actors.

The Fides Module, based on [Master Theses](https://github.com/stratosphereips/fides/tree/bfac47728172d3a4bbb27a5bb53ceef424e45e4f) on CTU FEL by Lukáš Forst. The goal of this module is to address the challenge of trustworthiness of peers in peer-to-peer networks by providing several trust evaluation models. It evaluates peer behavior, considers membership in trusted organizations, and assesses incoming threat data to determine reliability. Fides aggregates and weights data to enhance intrusion prevention systems, even in adversarial scenarios. Experiments show that Fides can maintain accurate threat intelligence even when 75% of the network is controlled by malicious actors, assuming the remaining 25% are trusted.

The whole architecture is thoroughly documented in the thesis itself, which can be downloaded from the link above.

## Docker direct use
You can use Slips with Fides Module by allowing it in the Slips config file or by using the following commands.

```
docker pull stratosphereips/slips
docker run -it --rm --net=host --cap-add=NET_ADMIN stratosphereips/slips
```

To be able to use the fides module you should use ```--cap-add=NET_ADMIN```

## Installation:

```
docker pull stratosphereips/slips
docker run -it --rm --net=host --use_fides=True stratosphereips/slips
```

***NOTE***

If you plan on using the Fides Module, lease be aware that it is used only
if Slips is running on an interface. The `--use_fides=True` is ignored when Slips is run on a file.

### Configuration
Evaluation model, evaluation thrash-holds and other configuration is located in fides.conf.yml

**Possible threat intelligence evaluation models**

| **Model Name**         | **Description**                                                  |
|:-----------------------|--------------------------------------------------------------|
| `average`              | Average Confidence Trust Intelligence Aggregation            |
| `weightedAverage`      | Weighted Average Confidence Trust Intelligence Aggregation   |
| `stdevFromScore`       | Standard Deviation From Score Trust Intelligence Aggregation |

## Usage in Slips

Fides is inactive by default in Slips.

To enable it, change ```use_fides=False``` to ```use_fides=True``` in ```config/slips.yaml```.

And start slips on your interface.

## Project sections

The project is built into Slips as a module and uses Redis for communication. Integration with Slips
is seamless, and it should be easy to adjust the module for use with other IPSs.

 - Slips, the Intrusion Prevention System
 - Fides Module the trust evaluation module for global p2p interaction


## How it works:

Slips interacts with other slips peers for the following purposes:

### Sharing opinion on peers

If a peers A is asked for its opinion on peer B by peer C, peer A sends the aggregated opinion on peer B to peer C, if there is any.

### Asking for an opinion

Newly connected peer will create a base trust by asking ather peers for opinion.

### Dispatching alerts

If a threat so great it may impact whole network, one or more groups, threat alert is
dispatched to peers, without regard to trust level accumulated on them.

### Answering and receiving requests form global P2P module.

## Logs

Slips contains a minimal log file for reports received by other peers and peer updates in
```output``` directory if not manually specified using the appropriate slips parameter upon start.
Custom logger ```modules/fidesModule/utils/logger.py``` is used by Fide Module for internal logging.  Either Slips' logging is used, or the custom logger is defaulted to logging via Python's printing function.

## Limitations

For now, slips supports the trust intelligence evaluation, global p2p is to be implemented.

## Implementation notes and credit
The mathematical models for trust evaluation were written by Lukáš Forst as part of his theses and can be accessed [here](https://github.com/LukasForst/fides/commits?author=LukasForst).


## TLDR;

Slips (meaning Fides Module here) only shares trust level and confidence (numbers) generated by slips about IPs to the network,
no private information is shared.
