# Fides: Trust Model for Collaborative Network Defence

This project is funded by [NlNet NGI Zero Entrust](https://nlnet.nl/project/Iris-P2P/)

Most network defense systems only rely on evidence-based knowledge about past cyberattacks, known as threat intelligence. Firewalls and
intrusion prevention systems rely on the shared threat intelligence generated by other systems to prevent attacks before is too late.
Such threat intelligence is usually shared via centralized public and private blocklists, where a single centralized authority, hopefully,
has complete control over what is published. Such centralized systems have many issues: single point of failure both technically and in
trust, lack of flexibility on new data and providers, and manual trust in the providers.

To mitigate these problems, peer-to-peer networks can be used to share threat intelligence. However, because these networks are open to
anyone, including malicious actors, and peers need to be able to determine who to trust and which data is better to discard.

Fides is a generic trust model fine-tuned for sharing security threat intelligence in highly adversarial
global peer-to-peer networks of intrusion prevention agents.
We design and build Fides taking into account the problems and limitations of previous state-of-the-art trust models, optimizing them for a
broad spectrum of peer-to-peer networks where peers can join and leave at any time.


The direct contributions are the computational model of the trust model Fides, the reference implementation of the model in
Python, the simulation framework for modeling peers' behavior in the network including the implementation of the framework and the
implementation of the Fides module for reference intrusion prevention system.


## How it works

![Screenshot_20240423_171706](https://github.com/stratosphereips/fides/assets/41242896/94f645c7-e064-4ca4-9264-c66bb611a07b)

Fides evaluates the behavior of peers in the network, including their membership in pre-trusted organizations, and uses this knowledge to
compute the trust.
Fides continually assesses received data from the peers, and by weighting and comparing them with each other as well as with the existing
knowledge, Fides is able to determine which peer provides better threat intelligence and which peers are more reliable. The received threat
intelligence is always aggregated and weighted and then provided to the underlying intrusion prevention system.
Among many results, our experiments show that in _the worst possible scenario_, when 75% of the network is _completely
controlled by malicious actors_ Fides is still able to 
provide the correct values of the threat intelligence data under the assumption that
the other part of the network, the remaining 25%, are peers that are part of trusted organizations.

## Repository

* [files](fides) is the implementation of the trust model
* [simulations](simulations) are simulations used to evaluate the model
* [slips](slips) is the Slips module that uses Fides
* [tests](tests) are the unit tests that verify that Fides works
* [trust model design](https://github.com/stratosphereips/fides/blob/master/doc/design.md) is the documentation of the design of fides trust model


## How to

The project needs to use the same Python as Slips does, thus we use Python 3.8, use [conda.yml](conda.yml) to set up the project.
See [Makefile](Makefile) for setup.

## Configuration

See [fides.conf.yml](fides.conf.yml) that is used to parametrize the trust model.

## Related work

* https://github.com/stratosphereips/StratosphereLinuxIPS
* https://github.com/stratosphereips/p2p4slips
* https://github.com/stratosphereips/p2p4slips-experiments
* https://github.com/stratosphereips/p2p4slips-tester
* https://github.com/draliii/StratosphereLinuxIPS/tree/module-p2p
