# SPDX-FileCopyrightText: 2021 Sebastian Garcia <sebastian.garcia@agents.fel.cvut.cz>
# SPDX-License-Identifier: GPL-2.0-only
class Constants:
    LOADED_TI_FILES = "loaded_TI_files_number"
    TI_FILES_INFO = "TI_files_info"
    GIVE_TI = "give_threat_intelligence"
    # all keys starting with IoC_* are used for storing IoCs read from
    # online and offline TI feeds
    IOC_IPS = "IoC_ips"
    IOC_DOMAINS = "IoC_domains"
    IOC_IP_RANGES = "IoC_ip_ranges"
    IOC_ASN = "IoC_ASNs"
    IOC_JA3 = "IoC_JA3"
    IOC_JARM = "IoC_JARM"
    IOC_SSL = "IoC_SSL"
    LABELED_AS_MALICIOUS = "labeled_as_malicious"
    # used to cache url info by the virustotal module only
    VT_CACHED_URL_INFO = "virustotal_cached_url_info"
    # used for Kalipso
    DOMAINS_INFO = "DomainsInfo"
    IPS_INFO = "IPsInfo"
    PROCESSED_FLOWS = "processed_flows_so_far"
    MALICIOUS_PROFILES = "malicious_profiles"
    FLOWS_CAUSING_EVIDENCE = "flows_causing_evidence"
    PROCESSED_EVIDENCE = "processed_evidence"
    NUMBER_OF_EVIDENCE = "number_of_evidence"
    WHITELISTED_EVIDENCE = "whitelisted_evidence"
    SRCIPS_SEEN_IN_CONN_LOG = "srcips_seen_in_connlog"
    PASSIVE_DNS = "passiveDNS"
    # called for every ip in kalipso timeline
    DNS_RESOLUTION = "DNSresolution"
    DOMAINS_RESOLVED = "DomainsResolved"
    CACHED_ASN = "cached_asn"
    PIDS = "PIDs"
    MAC = "MAC"
    MODIFIED_TIMEWINDOWS = "ModifiedTW"
    ORG_INFO = "OrgInfo"
    ACCUMULATED_THREAT_LEVELS = "accumulated_threat_levels"
    TRANCO_WHITELISTED_DOMAINS = "tranco_whitelisted_domains"
    WHITELIST = "whitelist"
    GROWING_ZEEK_DIR = "growing_zeek_dir"
    DHCP_SERVERS = "DHCP_servers"
    LABELS = "labels"
    MSGS_PUBLISHED_AT_RUNTIME = "msgs_published_at_runtime"
    ZEEK_FILES = "zeekfiles"
    DEFAULT_GATEWAY = "default_gateway"
    IS_CYST_ENABLED = "is_cyst_enabled"
    LOCAL_NETWORK = "local_network"
    ZEEK_PATH = "zeek_path"
    P2P_REPORTS = "p2p_reports"
    ORGANIZATIONS_PORTS = "organization_port"
    SLIPS_START_TIME = "slips_start_time"
    USED_FTP_PORTS = "used_ftp_ports"
    SLIPS_INTERNAL_TIME = "slips_internal_time"
    WARDEN_INFO = "Warden"
    MODE = "mode"
    ANALYSIS = "analysis"
    LOGGED_CONNECTION_ERR = "logged_connection_error"
    P2P_RECEIVED_BLAME_REPORTS = "p2p-received-blame-reports"
    MULTICAST_ADDRESS = "multiAddress"
    PORT_INFO = "portinfo"
    DHCP_FLOWS = "DHCP_flows"
    REDIS_USED_PORT = "port"
    BLOCKED_PROFILES_AND_TWS = "BlockedProfTW"
    PROFILES = "profiles"
    NUMBER_OF_ALERTS = "number_of_alerts"
    KNOWN_FPS = "known_fps"
    WILL_SLIPS_HAVE_MORE_FLOWS = "will_slips_have_more_flows"
    SUBS_WHO_PROCESSED_MSG = "number_of_subscribers_who_processed_this_msg"
    FLOWS_ANALYZED_BY_ALL_MODULES_PER_MIN = "flows_analyzed_per_minute"


class Channels:
    DNS_INFO_CHANGE = "dns_info_change"
    NEW_ALERT = "new_alert"
