"""Tests for the combined player model class."""
import os
import unittest

import requests_mock
import requests_cache
from sportsball.data.combined.combined_player_model import create_combined_player_model
from sportsball.data.player_model import PlayerModel, VERSION
from sportsball.data.species import Species


class TestCombinedPlayerModel(unittest.TestCase):

    def setUp(self):
        self._session = requests_cache.CachedSession(backend="memory")
        self.dir = os.path.dirname(__file__)

    def test_field_goals_attempted(self):
        identifier = "a"
        field_goals_attempted = 10
        with requests_mock.Mocker() as m:
            player_model = PlayerModel(
                identifier="a",
                jersey="35",
                kicks=None,
                fumbles=None,
                fumbles_lost=None,
                field_goals=None,
                field_goals_attempted=field_goals_attempted,
                offensive_rebounds=None,
                assists=None,
                turnovers=None,
                name="James Jones",
                marks=None,
                handballs=None,
                disposals=None,
                goals=None,
                behinds=None,
                hit_outs=None,
                tackles=None,
                rebounds=None,
                insides=None,
                clearances=None,
                clangers=None,
                free_kicks_for=None,
                free_kicks_against=None,
                brownlow_votes=None,
                contested_possessions=None,
                uncontested_possessions=None,
                contested_marks=None,
                marks_inside=None,
                one_percenters=None,
                bounces=None,
                goal_assists=None,
                percentage_played=None,
                birth_date=None,
                age=None,
                species=str(Species.HUMAN),
                handicap_weight=None,
                father=None,
                starting_position=None,
                weight=None,
                birth_address=None,
                owner=None,
                seconds_played=None,
                three_point_field_goals=None,
                three_point_field_goals_attempted=None,
                free_throws=None,
                free_throws_attempted=None,
                defensive_rebounds=None,
                steals=None,
                blocks=None,
                personal_fouls=None,
                points=None,
                game_score=None,
                point_differential=None,
                version=VERSION,
                height=None,
                colleges=[],
                headshot=None,
                forced_fumbles=None,
                fumbles_recovered=None,
                fumbles_recovered_yards=None,
                fumbles_touchdowns=None,
                offensive_two_point_returns=None,
                offensive_fumbles_touchdowns=None,
                defensive_fumbles_touchdowns=None,
                average_gain=None,
                completion_percentage=None,
                completions=None,
                espn_quarterback_rating=None,
                interception_percentage=None,
                interceptions=None,
                long_passing=None,
                misc_yards=None,
                net_passing_yards=None,
                net_total_yards=None,
                passing_attempts=None,
                passing_big_plays=None,
                passing_first_downs=None,
                passing_fumbles=None,
                passing_fumbles_lost=None,
                passing_touchdown_percentage=None,
                passing_touchdowns=None,
                passing_yards=None,
                passing_yards_after_catch=None,
                quarterback_rating=None,
                sacks=None,
                passing_yards_at_catch=None,
                sacks_yards_lost=None,
                net_passing_attempts=None,
                total_offensive_plays=None,
                total_points=None,
                total_touchdowns=None,
                total_yards=None,
                total_yards_from_scrimmage=None,
                two_point_pass=None,
                two_point_pass_attempt=None,
                yards_per_completion=None,
                yards_per_pass_attempt=None,
                net_yards_per_pass_attempt=None,
                long_rushing=None,
                rushing_attempts=None,
                rushing_big_plays=None,
                rushing_first_downs=None,
                rushing_fumbles=None,
                rushing_fumbles_lost=None,
                rushing_touchdowns=None,
                rushing_yards=None,
                stuffs=None,
                stuff_yards_lost=None,
                two_point_rush=None,
                two_point_rush_attempts=None,
                yards_per_rush_attempt=None,
                espn_widereceiver=None,
                long_reception=None,
                receiving_big_plays=None,
                receiving_first_downs=None,
                receiving_fumbles=None,
                receiving_fumbles_lost=None,
                receiving_targets=None,
                receiving_touchdowns=None,
                receiving_yards=None,
                receiving_yards_after_catch=None,
                receiving_yards_at_catch=None,
                receptions=None,
                two_point_receptions=None,
                two_point_reception_attempts=None,
                yards_per_reception=None,
                assist_tackles=None,
                average_interception_yards=None,
                average_sack_yards=None,
                average_stuff_yards=None,
                blocked_field_goal_touchdowns=None,
                blocked_punt_touchdowns=None,
                defensive_touchdowns=None,
                hurries=None,
                kicks_blocked=None,
                long_interception=None,
                misc_touchdowns=None,
                passes_batted_down=None,
                passes_defended=None,
                quarterback_hits=None,
                sacks_assisted=None,
                sacks_unassisted=None,
                sacks_yards=None,
                safeties=None,
                solo_tackles=None,
                stuff_yards=None,
                tackles_for_loss=None,
                tackles_yards_lost=None,
                yards_allowed=None,
                points_allowed=None,
                one_point_safeties_made=None,
                missed_field_goal_return_td=None,
                blocked_punt_ez_rec_td=None,
                interception_touchdowns=None,
                interception_yards=None,
                average_kickoff_return_yards=None,
                average_kickoff_yards=None,
                extra_point_attempts=None,
                extra_point_percentage=None,
                extra_point_blocked=None,
                extra_points_blocked_percentage=None,
                extra_points_made=None,
                fair_catches=None,
                fair_catch_percentage=None,
                field_goal_attempts_max_19_yards=None,
                field_goal_attempts_max_29_yards=None,
                field_goal_attempts_max_39_yards=None,
                field_goal_attempts_max_49_yards=None,
                field_goal_attempts_max_59_yards=None,
                field_goal_attempts_max_99_yards=None,
                field_goal_attempts_above_50_yards=None,
                field_goal_attempt_yards=None,
                field_goals_blocked=None,
                field_goals_blocked_percentage=None,
                field_goals_made=None,
                field_goals_made_max_19_yards=None,
                field_goals_made_max_29_yards=None,
                field_goals_made_max_39_yards=None,
                field_goals_made_max_49_yards=None,
                field_goals_made_max_59_yards=None,
                field_goals_made_max_99_yards=None,
                field_goals_made_above_50_yards=None,
                field_goals_made_yards=None,
                field_goals_missed_yards=None,
                kickoff_out_of_bounds=None,
                kickoff_returns=None,
                kickoff_returns_touchdowns=None,
                kickoff_return_yards=None,
                kickoffs=None,
                kickoff_yards=None,
                long_field_goal_attempt=None,
                long_field_goal_made=None,
                long_kickoff=None,
                total_kicking_points=None,
                touchback_percentage=None,
                touchbacks=None,
                defensive_fumble_returns=None,
                defensive_fumble_return_yards=None,
                fumble_recoveries=None,
                fumble_recovery_yards=None,
                kick_return_fair_catches=None,
                kick_return_fair_catch_percentage=None,
                kick_return_fumbles=None,
                kick_return_fumbles_lost=None,
                kick_returns=None,
                kick_return_touchdowns=None,
                kick_return_yards=None,
                long_kick_return=None,
                long_punt_return=None,
                misc_fumble_returns=None,
                misc_fumble_return_yards=None,
                opposition_fumble_recoveries=None,
                opposition_fumble_recovery_yards=None,
                opposition_special_team_fumble_returns=None,
                opposition_special_team_fumble_return_yards=None,
                punt_return_fair_catches=None,
                punt_return_fair_catch_percentage=None,
                punt_return_fumbles=None,
                punt_return_fumbles_lost=None,
                punt_returns=None,
                punt_returns_started_inside_the_10=None,
                punt_returns_started_inside_the_20=None,
                punt_return_touchdowns=None,
                special_team_fumble_returns=None,
                yards_per_kick_return=None,
                yards_per_punt_return=None,
                yards_per_return=None,
                average_punt_return_yards=None,
                gross_average_punt_yards=None,
                long_punt=None,
                net_average_punt_yards=None,
                punts=None,
                punts_blocked=None,
                punts_blocked_percentage=None,
                punts_inside_10=None,
                punts_inside_10_percentage=None,
                punts_inside_20=None,
                punts_inside_20_percentage=None,
                punts_over_50=None,
                punt_yards=None,
                defensive_points=None,
                misc_points=None,
                return_touchdowns=None,
                total_two_point_conversions=None,
                passing_touchdowns_9_yards=None,
                passing_touchdowns_19_yards=None,
                passing_touchdowns_29_yards=None,
                passing_touchdowns_39_yards=None,
                passing_touchdowns_49_yards=None,
                passing_touchdowns_above_50_yards=None,
                receiving_touchdowns_9_yards=None,
                receiving_touchdowns_19_yards=None,
                receiving_touchdowns_29_yards=None,
                receiving_touchdowns_39_yards=None,
                punt_return_yards=None,
                receiving_touchdowns_49_yards=None,
                receiving_touchdowns_above_50_yards=None,
                rushing_touchdowns_9_yards=None,
                rushing_touchdowns_19_yards=None,
                rushing_touchdowns_29_yards=None,
                rushing_touchdowns_39_yards=None,
                rushing_touchdowns_49_yards=None,
                rushing_touchdowns_above_50_yards=None,
                penalties_in_minutes=None,
                even_strength_goals=None,
                power_play_goals=None,
                short_handed_goals=None,
                game_winning_goals=None,
                even_strength_assists=None,
                power_play_assists=None,
                short_handed_assists=None,
                shots_on_goal=None,
                shooting_percentage=None,
                shifts=None,
                time_on_ice=None,
                decision=None,
                goals_against=None,
                shots_against=None,
                saves=None,
                save_percentage=None,
                shutouts=None,
                individual_corsi_for_events=None,
                on_shot_ice_for_events=None,
                on_shot_ice_against_events=None,
                corsi_for_percentage=None,
                relative_corsi_for_percentage=None,
                offensive_zone_starts=None,
                defensive_zone_starts=None,
                offensive_zone_start_percentage=None,
                hits=None,
                true_shooting_percentage=None,
                at_bats=None,
                runs_scored=None,
                runs_batted_in=None,
                bases_on_balls=None,
                strikeouts=None,
                plate_appearances=None,
                hits_at_bats=None,
                obp=None,
                slg=None,
                ops=None,
                pitches=None,
                strikes=None,
                win_probability_added=None,
                average_leverage_index=None,
                wpa_plus=None,
                wpa_minus=None,
                cwpa=None,
                acli=None,
                re24=None,
                putouts=None,
                innings_pitched=None,
                earned_runs=None,
                home_runs=None,
                era=None,
                batters_faced=None,
                strikes_by_contact=None,
                strikes_swinging=None,
                strikes_looking=None,
                ground_balls=None,
                fly_balls=None,
                line_drives=None,
                inherited_runners=None,
                inherited_scores=None,
                effective_field_goal_percentage=None,
            )
            players_ffill = {}
            combined_player_model = create_combined_player_model(
                player_models=[player_model],
                identifier=identifier,
                player_ffill=players_ffill,
            )
            self.assertEqual(combined_player_model.field_goals_attempted, field_goals_attempted)
