# Generated by Django 5.0.13 on 2025-04-17 01:02

import uuid

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import pgtrigger.compiler
import pgtrigger.migrations
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ChatIdentity",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("avatar", models.ImageField(blank=True, null=True, upload_to="chat-identities")),
                ("chat_intro_title", models.CharField(blank=True, max_length=255, null=True)),
                ("chat_intro_subtitle", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "chat_fab_text",
                    models.CharField(
                        blank=True,
                        help_text="The Floating Action Button (FAB) text that will be displayed in the hover state of the Chat FAB.",
                        max_length=255,
                        null=True,
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
            ],
            options={
                "verbose_name_plural": "Chat Identities",
            },
        ),
        migrations.CreateModel(
            name="ChatMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        choices=[
                            ("user", "User"),
                            ("assistant", "Assistant"),
                            ("system", "System"),
                        ],
                        max_length=10,
                    ),
                ),
                ("content", models.TextField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChatPrePromptedQuestion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        help_text="Title of the pre-prompted question, shown in the dropdown for users to select.",
                        max_length=255,
                    ),
                ),
                (
                    "prompt",
                    models.TextField(
                        help_text="Text shown in the user input when a pre-prompt is selected. This is the prompt that will be sent to the LLM.",
                        max_length=400,
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        help_text="Order in which the pre-prompted question will be shown in the dropdown from top to bottom."
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
            ],
            options={
                "verbose_name": "Chat Pre-Prompted Question",
                "verbose_name_plural": "Chat Pre-Prompted Questions",
                "ordering": ["order"],
            },
        ),
        migrations.CreateModel(
            name="ChatSession",
            fields=[
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
            ],
            options={
                "get_latest_by": "created",
            },
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="chatidentity",
            trigger=pgtrigger.compiler.Trigger(
                name="ensure_single_active_chat_identity",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func="\n                BEGIN\n                    IF NEW.is_active THEN\n                        UPDATE baseapp_ai_langkit_chats_chatidentity SET is_active = FALSE WHERE id <> NEW.id AND is_active = TRUE;\n                    END IF;\n                    RETURN NEW;\n                END;\n                ",
                    hash="cc34f7852b1fe75adf225625d516f20cb64d33bf",
                    operation="UPDATE OR INSERT",
                    pgid="pgtrigger_ensure_single_active_chat_identity_c9213",
                    table="baseapp_ai_langkit_chats_chatidentity",
                    when="BEFORE",
                ),
            ),
        ),
        migrations.AddField(
            model_name="chatsession",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="chat_sessions",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="chatmessage",
            name="session",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="messages",
                to="baseapp_ai_langkit_chats.chatsession",
            ),
        ),
    ]
