# Generated by Django 5.0.11 on 2025-03-10 22:31

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="LLMRunner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="LLMRunnerNode",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("node", models.CharField(max_length=255)),
                (
                    "runner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nodes",
                        to="baseapp_ai_langkit_runners.llmrunner",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="LLMRunnerNodeStateModifier",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("index", models.IntegerField()),
                (
                    "state_modifier",
                    models.TextField(
                        blank=True,
                        help_text="The state modifier that will be used to modify the state.",
                        null=True,
                    ),
                ),
                (
                    "runner_node",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="state_modifiers",
                        to="baseapp_ai_langkit_runners.llmrunnernode",
                    ),
                ),
            ],
            options={
                "verbose_name": "State modifier",
                "verbose_name_plural": "State modifiers",
                "ordering": ["index"],
                "unique_together": {("runner_node", "index")},
            },
        ),
        migrations.CreateModel(
            name="LLMRunnerNodeUsagePrompt",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "usage_prompt",
                    models.TextField(
                        blank=True,
                        help_text="The prompt that will be used to explain the LLM orchestrator of how to use the node.",
                        null=True,
                    ),
                ),
                (
                    "runner_node",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usage_prompt",
                        to="baseapp_ai_langkit_runners.llmrunnernode",
                    ),
                ),
            ],
            options={
                "verbose_name": "Usage prompt",
                "verbose_name_plural": "Usage prompts",
                "unique_together": {("runner_node", "usage_prompt")},
            },
        ),
    ]
