# Generated by Django 5.0.14 on 2025-04-25 12:31

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("baseapp_ai_langkit_chats", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SlackAIChat",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("celery_task_id", models.UUIDField(blank=True, null=True)),
                (
                    "chat_session",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_chat",
                        to="baseapp_ai_langkit_chats.chatsession",
                    ),
                ),
            ],
            options={
                "verbose_name": "Slack AI Chat",
                "verbose_name_plural": "Slack AI Chats",
            },
        ),
        migrations.CreateModel(
            name="SlackEvent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("team_id", models.CharField(max_length=21)),
                ("event_ts", models.CharField(max_length=21)),
                ("event_type", models.CharField(max_length=50)),
                ("data", models.JSONField(default=None)),
            ],
            options={
                "unique_together": {("team_id", "event_ts", "event_type")},
            },
        ),
        migrations.CreateModel(
            name="SlackAIChatMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "output_response_output_data",
                    models.JSONField(blank=True, default=None, null=True),
                ),
                (
                    "slack_chat",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_chat_messages",
                        to="baseapp_ai_langkit_slack.slackaichat",
                    ),
                ),
                (
                    "output_slack_event",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_ai_chat_message_from_output_slack_event",
                        to="baseapp_ai_langkit_slack.slackevent",
                    ),
                ),
                (
                    "user_message_slack_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_ai_chat_messages_from_user_message",
                        to="baseapp_ai_langkit_slack.slackevent",
                    ),
                ),
            ],
            options={
                "verbose_name": "Slack AI Chat Message",
                "verbose_name_plural": "Slack AI Chat Messages",
            },
        ),
        migrations.AddField(
            model_name="slackaichat",
            name="slack_event",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="slack_chat",
                to="baseapp_ai_langkit_slack.slackevent",
            ),
        ),
        migrations.CreateModel(
            name="SlackEventStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("running", "Running"),
                            ("success", "Success"),
                            ("success_with_warnings", "Success with warnings"),
                            ("failed", "Failed"),
                        ],
                        default="pending",
                        max_length=21,
                    ),
                ),
                ("status_message", models.TextField(blank=True, default=None, null=True)),
                (
                    "slack_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="event_statuses",
                        to="baseapp_ai_langkit_slack.slackevent",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SlackAIChatMessageReaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("reaction", models.CharField(max_length=64)),
                (
                    "slack_chat_message",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reactions",
                        to="baseapp_ai_langkit_slack.slackaichatmessage",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_ai_chat_message_reactions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "slack_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_ai_chat_message_reactions",
                        to="baseapp_ai_langkit_slack.slackevent",
                    ),
                ),
            ],
            options={
                "verbose_name": "Slack AI Chat Message Reaction",
                "verbose_name_plural": "Slack AI Chat Message Reactions",
                "unique_together": {("user", "slack_chat_message", "reaction")},
            },
        ),
    ]
