# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr


from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ContentDispositionInlineApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def preview_organization_data_file(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], data_id : Annotated[StrictInt, Field(..., description="Data ID")], file_name : Annotated[StrictStr, Field(..., description="File name")], **kwargs) -> str:  # noqa: E501
        """Preview file

        Preview a single file from a data item (same as downloadOrganizationDataFile but w/ content-disposition inline).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param data_id: Data ID (required)
        :type data_id: int
        :param file_name: File name (required)
        :type file_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._preview_organization_data_file_with_http_info(organization_id, data_id, file_name, **kwargs)  # noqa: E501

    @validate_arguments
    def _preview_organization_data_file_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], data_id : Annotated[StrictInt, Field(..., description="Data ID")], file_name : Annotated[StrictStr, Field(..., description="File name")], **kwargs):  # noqa: E501
        """Preview file 

        Preview a single file from a data item (same as downloadOrganizationDataFile but w/ content-disposition inline).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param data_id: Data ID (required)
        :type data_id: int
        :param file_name: File name (required)
        :type file_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'data_id',
            'file_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preview_organization_data_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['data_id']:
            _path_params['dataId'] = _params['data_id']

        # process the query parameters
        _query_params = []
        if _params.get('file_name') is not None:  # noqa: E501
            _query_params.append(('fileName', _params['file_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/data/{dataId}/files/preview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def view_dataset_file(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dataset : Annotated[StrictStr, Field(..., description="Dataset name")], path : Annotated[StrictStr, Field(..., description="Path to file in portal")], **kwargs) -> str:  # noqa: E501
        """View file from dataset

        View a file that's located in a dataset (requires JWT auth).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dataset: Dataset name (required)
        :type dataset: str
        :param path: Path to file in portal (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._view_dataset_file_with_http_info(organization_id, dataset, path, **kwargs)  # noqa: E501

    @validate_arguments
    def _view_dataset_file_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dataset : Annotated[StrictStr, Field(..., description="Dataset name")], path : Annotated[StrictStr, Field(..., description="Path to file in portal")], **kwargs):  # noqa: E501
        """View file from dataset 

        View a file that's located in a dataset (requires JWT auth).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dataset: Dataset name (required)
        :type dataset: str
        :param path: Path to file in portal (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dataset',
            'path'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_dataset_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dataset']:
            _path_params['dataset'] = _params['dataset']

        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dataset/{dataset}/files/view', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def view_portal_file(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID")], path : Annotated[StrictStr, Field(..., description="Path to file in portal")], **kwargs) -> str:  # noqa: E501
        """View file from portal

        View a file that's located in an upload portal (requires JWT auth).

        :param portal_id: Portal ID (required)
        :type portal_id: int
        :param path: Path to file in portal (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._view_portal_file_with_http_info(portal_id, path, **kwargs)  # noqa: E501

    @validate_arguments
    def _view_portal_file_with_http_info(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID")], path : Annotated[StrictStr, Field(..., description="Path to file in portal")], **kwargs):  # noqa: E501
        """View file from portal 

        View a file that's located in an upload portal (requires JWT auth).

        :param portal_id: Portal ID (required)
        :type portal_id: int
        :param path: Path to file in portal (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'portal_id',
            'path'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_portal_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['portal_id']:
            _path_params['portalId'] = _params['portal_id']

        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/portals/{portalId}/files/view', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
