# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.autotune_dsp_request import AutotuneDspRequest
from edgeimpulse_api.models.build_on_device_model_request import BuildOnDeviceModelRequest
from edgeimpulse_api.models.build_organization_on_device_model_request import BuildOrganizationOnDeviceModelRequest
from edgeimpulse_api.models.calculate_data_quality_metrics_request import CalculateDataQualityMetricsRequest
from edgeimpulse_api.models.deploy_pretrained_model_request import DeployPretrainedModelRequest
from edgeimpulse_api.models.export_keras_block_data_request import ExportKerasBlockDataRequest
from edgeimpulse_api.models.export_original_data_request import ExportOriginalDataRequest
from edgeimpulse_api.models.export_wav_data_request import ExportWavDataRequest
from edgeimpulse_api.models.generate_features_request import GenerateFeaturesRequest
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_job_response import GetJobResponse
from edgeimpulse_api.models.job_summary_response import JobSummaryResponse
from edgeimpulse_api.models.list_jobs_response import ListJobsResponse
from edgeimpulse_api.models.log_stdout_response import LogStdoutResponse
from edgeimpulse_api.models.profile_tf_lite_request import ProfileTfLiteRequest
from edgeimpulse_api.models.profile_tf_lite_response import ProfileTfLiteResponse
from edgeimpulse_api.models.project_version_request import ProjectVersionRequest
from edgeimpulse_api.models.restore_project_from_public_request import RestoreProjectFromPublicRequest
from edgeimpulse_api.models.restore_project_request import RestoreProjectRequest
from edgeimpulse_api.models.set_keras_parameter_request import SetKerasParameterRequest
from edgeimpulse_api.models.start_job_response import StartJobResponse
from edgeimpulse_api.models.start_performance_calibration_request import StartPerformanceCalibrationRequest
from edgeimpulse_api.models.start_training_request_anomaly import StartTrainingRequestAnomaly
from edgeimpulse_api.models.update_job_request import UpdateJobRequest

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class JobsApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def autotune_dsp_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], autotune_dsp_request : AutotuneDspRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Autotune DSP parameters

        Autotune DSP block parameters. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param autotune_dsp_request: (required)
        :type autotune_dsp_request: AutotuneDspRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._autotune_dsp_job_with_http_info(project_id, autotune_dsp_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _autotune_dsp_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], autotune_dsp_request : AutotuneDspRequest, **kwargs):  # noqa: E501
        """Autotune DSP parameters 

        Autotune DSP block parameters. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param autotune_dsp_request: (required)
        :type autotune_dsp_request: AutotuneDspRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'autotune_dsp_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method autotune_dsp_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['autotune_dsp_request']:
            _body_params = _params['autotune_dsp_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/autotune-dsp', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def build_on_device_model_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], build_on_device_model_request : BuildOnDeviceModelRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Build on-device model

        Generate code to run the impulse on an embedded device. When this step is complete use `downloadBuild` to download the artefacts.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param build_on_device_model_request: (required)
        :type build_on_device_model_request: BuildOnDeviceModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._build_on_device_model_job_with_http_info(project_id, type, build_on_device_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _build_on_device_model_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], build_on_device_model_request : BuildOnDeviceModelRequest, **kwargs):  # noqa: E501
        """Build on-device model 

        Generate code to run the impulse on an embedded device. When this step is complete use `downloadBuild` to download the artefacts.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param build_on_device_model_request: (required)
        :type build_on_device_model_request: BuildOnDeviceModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'type',
            'build_on_device_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_on_device_model_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['build_on_device_model_request']:
            _body_params = _params['build_on_device_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/build-ondevice-model', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def build_organization_on_device_model_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], build_organization_on_device_model_request : BuildOrganizationOnDeviceModelRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Build organizational on-device model

        Generate code to run the impulse on an embedded device using an organizational deployment block. When this step is complete use `downloadBuild` to download the artefacts.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param build_organization_on_device_model_request: (required)
        :type build_organization_on_device_model_request: BuildOrganizationOnDeviceModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._build_organization_on_device_model_job_with_http_info(project_id, build_organization_on_device_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _build_organization_on_device_model_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], build_organization_on_device_model_request : BuildOrganizationOnDeviceModelRequest, **kwargs):  # noqa: E501
        """Build organizational on-device model 

        Generate code to run the impulse on an embedded device using an organizational deployment block. When this step is complete use `downloadBuild` to download the artefacts.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param build_organization_on_device_model_request: (required)
        :type build_organization_on_device_model_request: BuildOrganizationOnDeviceModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'build_organization_on_device_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_organization_on_device_model_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['build_organization_on_device_model_request']:
            _body_params = _params['build_organization_on_device_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/build-ondevice-model/organization', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def calculate_data_quality_metrics(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], calculate_data_quality_metrics_request : CalculateDataQualityMetricsRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Calculate data quality metrics

        Calculate data quality metrics for the dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param calculate_data_quality_metrics_request: (required)
        :type calculate_data_quality_metrics_request: CalculateDataQualityMetricsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._calculate_data_quality_metrics_with_http_info(project_id, calculate_data_quality_metrics_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _calculate_data_quality_metrics_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], calculate_data_quality_metrics_request : CalculateDataQualityMetricsRequest, **kwargs):  # noqa: E501
        """Calculate data quality metrics 

        Calculate data quality metrics for the dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param calculate_data_quality_metrics_request: (required)
        :type calculate_data_quality_metrics_request: CalculateDataQualityMetricsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'calculate_data_quality_metrics_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_data_quality_metrics" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['calculate_data_quality_metrics_request']:
            _body_params = _params['calculate_data_quality_metrics_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/data-quality-metrics', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def cancel_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Cancel job

        Cancel a running job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._cancel_job_with_http_info(project_id, job_id, force_cancel, **kwargs)  # noqa: E501

    @validate_arguments
    def _cancel_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs):  # noqa: E501
        """Cancel job 

        Cancel a running job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id',
            'force_cancel'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('force_cancel') is not None:  # noqa: E501
            _query_params.append(('forceCancel', _params['force_cancel']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/{jobId}/cancel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_jobs_logs(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> str:  # noqa: E501
        """Download logs

        Download the logs for a job (as a text file).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_jobs_logs_with_http_info(project_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_jobs_logs_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Download logs 

        Download the logs for a job (as a text file).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/{jobId}/stdout/download', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_keras_block(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Export Keras block

        Export the training pipeline of a Keras block. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_keras_block_with_http_info(project_id, learn_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_keras_block_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Export Keras block 

        Export the training pipeline of a Keras block. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_keras_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/train/keras/{learnId}/export', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_keras_block_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], export_keras_block_data_request : Optional[ExportKerasBlockDataRequest] = None, **kwargs) -> StartJobResponse:  # noqa: E501
        """Export Keras block data

        Export the data of a Keras block (already split in train/validate data). Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param export_keras_block_data_request:
        :type export_keras_block_data_request: ExportKerasBlockDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_keras_block_data_with_http_info(project_id, learn_id, export_keras_block_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_keras_block_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], export_keras_block_data_request : Optional[ExportKerasBlockDataRequest] = None, **kwargs):  # noqa: E501
        """Export Keras block data 

        Export the data of a Keras block (already split in train/validate data). Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param export_keras_block_data_request:
        :type export_keras_block_data_request: ExportKerasBlockDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'export_keras_block_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_keras_block_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['export_keras_block_data_request']:
            _body_params = _params['export_keras_block_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/train/keras/{learnId}/data', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def generate_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Generate data explorer features

        Generate features for the data explorer

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._generate_data_explorer_features_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _generate_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Generate data explorer features 

        Generate features for the data explorer

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/data-explorer-features', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def generate_features_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], generate_features_request : GenerateFeaturesRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Generate features

        Take the raw training set and generate features from them. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param generate_features_request: (required)
        :type generate_features_request: GenerateFeaturesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._generate_features_job_with_http_info(project_id, generate_features_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _generate_features_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], generate_features_request : GenerateFeaturesRequest, **kwargs):  # noqa: E501
        """Generate features 

        Take the raw training set and generate features from them. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param generate_features_request: (required)
        :type generate_features_request: GenerateFeaturesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'generate_features_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_features_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['generate_features_request']:
            _body_params = _params['generate_features_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/generate-features', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_job_status(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> GetJobResponse:  # noqa: E501
        """Get job status

        Get the status for a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_job_status_with_http_info(project_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_job_status_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get job status 

        Get the status for a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/{jobId}/status', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_jobs_logs(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> LogStdoutResponse:  # noqa: E501
        """Get logs

        Get the logs for a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LogStdoutResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_jobs_logs_with_http_info(project_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_jobs_logs_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Get logs 

        Get the logs for a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LogStdoutResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "LogStdoutResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/{jobId}/stdout', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_jobs_summary(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[datetime, Field(..., description="Start date")], end_date : Annotated[datetime, Field(..., description="End date")], **kwargs) -> JobSummaryResponse:  # noqa: E501
        """Job summary

        Get a summary of jobs, grouped by key. Used to report to users how much compute they've used.

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date (required)
        :type start_date: datetime
        :param end_date: End date (required)
        :type end_date: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobSummaryResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_jobs_summary_with_http_info(project_id, start_date, end_date, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_jobs_summary_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[datetime, Field(..., description="Start date")], end_date : Annotated[datetime, Field(..., description="End date")], **kwargs):  # noqa: E501
        """Job summary 

        Get a summary of jobs, grouped by key. Used to report to users how much compute they've used.

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date (required)
        :type start_date: datetime
        :param end_date: End date (required)
        :type end_date: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobSummaryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'start_date',
            'end_date'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "JobSummaryResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/summary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_profile_tflite_job_result(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> ProfileTfLiteResponse:  # noqa: E501
        """Get TFLite profile result (GET)

        Get the results from a job started from startProfileTfliteJob (via a GET request).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProfileTfLiteResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_profile_tflite_job_result_with_http_info(project_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_profile_tflite_job_result_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get TFLite profile result (GET) 

        Get the results from a job started from startProfileTfliteJob (via a GET request).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProfileTfLiteResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_profile_tflite_job_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ProfileTfLiteResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/profile-tflite/{jobId}/result', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_profile_tflite_job_result_via_post_request(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> ProfileTfLiteResponse:  # noqa: E501
        """Get TFLite profile result (POST)

        Get the results from a job started from startProfileTfliteJob (via a POST request).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProfileTfLiteResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_profile_tflite_job_result_via_post_request_with_http_info(project_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_profile_tflite_job_result_via_post_request_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get TFLite profile result (POST) 

        Get the results from a job started from startProfileTfliteJob (via a POST request).

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProfileTfLiteResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_profile_tflite_job_result_via_post_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ProfileTfLiteResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/profile-tflite/{jobId}/result', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_active_jobs(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List active jobs

        Get all active jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_active_jobs_with_http_info(project_id, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_active_jobs_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List active jobs 

        Get all active jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_all_jobs(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List all jobs

        Get all jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_all_jobs_with_http_info(project_id, start_date, end_date, limit, offset, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_all_jobs_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List all jobs 

        Get all jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_finished_jobs(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List finished jobs

        Get all finished jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_finished_jobs_with_http_info(project_id, start_date, end_date, limit, offset, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_finished_jobs_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List finished jobs 

        Get all finished jobs for this project

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_finished_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/history', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def optimize_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], set_keras_parameter_request : SetKerasParameterRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Optimize model

        Evaluates optimal model architecture

        :param project_id: Project ID (required)
        :type project_id: int
        :param set_keras_parameter_request: (required)
        :type set_keras_parameter_request: SetKerasParameterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._optimize_job_with_http_info(project_id, set_keras_parameter_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _optimize_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], set_keras_parameter_request : SetKerasParameterRequest, **kwargs):  # noqa: E501
        """Optimize model 

        Evaluates optimal model architecture

        :param project_id: Project ID (required)
        :type project_id: int
        :param set_keras_parameter_request: (required)
        :type set_keras_parameter_request: SetKerasParameterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'set_keras_parameter_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method optimize_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_keras_parameter_request']:
            _body_params = _params['set_keras_parameter_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/optimize', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_tuner_primary_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], trial_id : Annotated[StrictStr, Field(..., description="trial ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Sets EON tuner primary model

        Sets EON tuner primary model

        :param project_id: Project ID (required)
        :type project_id: int
        :param trial_id: trial ID (required)
        :type trial_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_tuner_primary_job_with_http_info(project_id, trial_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_tuner_primary_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], trial_id : Annotated[StrictStr, Field(..., description="trial ID")], **kwargs):  # noqa: E501
        """Sets EON tuner primary model 

        Sets EON tuner primary model

        :param project_id: Project ID (required)
        :type project_id: int
        :param trial_id: trial ID (required)
        :type trial_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'trial_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_tuner_primary_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('trial_id') is not None:  # noqa: E501
            _query_params.append(('trialId', _params['trial_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/set-tuner-primary-job', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_classify_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Classify

        Classifies all items in the testing dataset against the current impulse. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_classify_job_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_classify_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Classify 

        Classifies all items in the testing dataset against the current impulse. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_classify_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/classify', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_deploy_pretrained_model_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], deploy_pretrained_model_request : DeployPretrainedModelRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Deploy pretrained model

        Takes in a TFLite file and builds the model and SDK. Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param deploy_pretrained_model_request: (required)
        :type deploy_pretrained_model_request: DeployPretrainedModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_deploy_pretrained_model_job_with_http_info(project_id, deploy_pretrained_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_deploy_pretrained_model_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], deploy_pretrained_model_request : DeployPretrainedModelRequest, **kwargs):  # noqa: E501
        """Deploy pretrained model 

        Takes in a TFLite file and builds the model and SDK. Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param deploy_pretrained_model_request: (required)
        :type deploy_pretrained_model_request: DeployPretrainedModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'deploy_pretrained_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_deploy_pretrained_model_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['deploy_pretrained_model_request']:
            _body_params = _params['deploy_pretrained_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/deploy-pretrained-model', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_evaluate_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Evaluate

        Evaluates every variant of the current impulse. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_evaluate_job_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_evaluate_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Evaluate 

        Evaluates every variant of the current impulse. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_evaluate_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/evaluate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_keywords_noise_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Add keywords and noise

        Add keywords and noise data to a project (for getting started guide)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_keywords_noise_job_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_keywords_noise_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Add keywords and noise 

        Add keywords and noise data to a project (for getting started guide)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_keywords_noise_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/keywords-noise', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_make_version_public_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], version_id : Annotated[StrictInt, Field(..., description="Version ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Make a version public

        Make a version of a project public. This makes all data and state available (read-only) on a public URL, and allows users to clone this project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param version_id: Version ID (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_make_version_public_job_with_http_info(project_id, version_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_make_version_public_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], version_id : Annotated[StrictInt, Field(..., description="Version ID")], **kwargs):  # noqa: E501
        """Make a version public 

        Make a version of a project public. This makes all data and state available (read-only) on a public URL, and allows users to clone this project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param version_id: Version ID (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'version_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_make_version_public_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['version_id']:
            _path_params['versionId'] = _params['version_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/versions/{versionId}/make-public', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_original_export_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], export_original_data_request : ExportOriginalDataRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Export original data

        Export all the data in the project as it was uploaded to Edge Impulse.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param export_original_data_request: (required)
        :type export_original_data_request: ExportOriginalDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_original_export_job_with_http_info(project_id, export_original_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_original_export_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], export_original_data_request : ExportOriginalDataRequest, **kwargs):  # noqa: E501
        """Export original data 

        Export all the data in the project as it was uploaded to Edge Impulse.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param export_original_data_request: (required)
        :type export_original_data_request: ExportOriginalDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'export_original_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_original_export_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['export_original_data_request']:
            _body_params = _params['export_original_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/export/original', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_performance_calibration_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_performance_calibration_request : StartPerformanceCalibrationRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Performance Calibration

        Simulates real world usage and returns performance metrics.

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_performance_calibration_request: (required)
        :type start_performance_calibration_request: StartPerformanceCalibrationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_performance_calibration_job_with_http_info(project_id, start_performance_calibration_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_performance_calibration_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_performance_calibration_request : StartPerformanceCalibrationRequest, **kwargs):  # noqa: E501
        """Performance Calibration 

        Simulates real world usage and returns performance metrics.

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_performance_calibration_request: (required)
        :type start_performance_calibration_request: StartPerformanceCalibrationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'start_performance_calibration_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_performance_calibration_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['start_performance_calibration_request']:
            _body_params = _params['start_performance_calibration_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/performance-calibration', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_profile_tflite_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], profile_tf_lite_request : ProfileTfLiteRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Profile TFLite model

        Takes in a TFLite model and returns the latency, RAM and ROM used for this model. Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param profile_tf_lite_request: (required)
        :type profile_tf_lite_request: ProfileTfLiteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_profile_tflite_job_with_http_info(project_id, profile_tf_lite_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_profile_tflite_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], profile_tf_lite_request : ProfileTfLiteRequest, **kwargs):  # noqa: E501
        """Profile TFLite model 

        Takes in a TFLite model and returns the latency, RAM and ROM used for this model. Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param profile_tf_lite_request: (required)
        :type profile_tf_lite_request: ProfileTfLiteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'profile_tf_lite_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_profile_tflite_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['profile_tf_lite_request']:
            _body_params = _params['profile_tf_lite_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/profile-tflite', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_restore_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], restore_project_request : RestoreProjectRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Restore project to version

        Restore a project to a certain version. This can only applied to a project without data, and will overwrite your impulse and all settings.

        :param project_id: Project ID (required)
        :type project_id: int
        :param restore_project_request: (required)
        :type restore_project_request: RestoreProjectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_restore_job_with_http_info(project_id, restore_project_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_restore_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], restore_project_request : RestoreProjectRequest, **kwargs):  # noqa: E501
        """Restore project to version 

        Restore a project to a certain version. This can only applied to a project without data, and will overwrite your impulse and all settings.

        :param project_id: Project ID (required)
        :type project_id: int
        :param restore_project_request: (required)
        :type restore_project_request: RestoreProjectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'restore_project_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_restore_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['restore_project_request']:
            _body_params = _params['restore_project_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/restore', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_restore_job_from_public(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], restore_project_from_public_request : RestoreProjectFromPublicRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Restore project to public version

        Restore a project to a certain public version. This can only applied to a project without data, and will overwrite your impulse and all settings.

        :param project_id: Project ID (required)
        :type project_id: int
        :param restore_project_from_public_request: (required)
        :type restore_project_from_public_request: RestoreProjectFromPublicRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_restore_job_from_public_with_http_info(project_id, restore_project_from_public_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_restore_job_from_public_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], restore_project_from_public_request : RestoreProjectFromPublicRequest, **kwargs):  # noqa: E501
        """Restore project to public version 

        Restore a project to a certain public version. This can only applied to a project without data, and will overwrite your impulse and all settings.

        :param project_id: Project ID (required)
        :type project_id: int
        :param restore_project_from_public_request: (required)
        :type restore_project_from_public_request: RestoreProjectFromPublicRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'restore_project_from_public_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_restore_job_from_public" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['restore_project_from_public_request']:
            _body_params = _params['restore_project_from_public_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/restore/from-public', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_retrain_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Retrain

        Retrains the current impulse with the last known parameters. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_retrain_job_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_retrain_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Retrain 

        Retrains the current impulse with the last known parameters. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_retrain_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/retrain', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_version_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], project_version_request : ProjectVersionRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Version project

        Create a new version of the project. This stores all data and configuration offsite. If you have access to the enterprise version of Edge Impulse you can store your data in your own storage buckets (only through JWT token authentication).

        :param project_id: Project ID (required)
        :type project_id: int
        :param project_version_request: (required)
        :type project_version_request: ProjectVersionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_version_job_with_http_info(project_id, project_version_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_version_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], project_version_request : ProjectVersionRequest, **kwargs):  # noqa: E501
        """Version project 

        Create a new version of the project. This stores all data and configuration offsite. If you have access to the enterprise version of Edge Impulse you can store your data in your own storage buckets (only through JWT token authentication).

        :param project_id: Project ID (required)
        :type project_id: int
        :param project_version_request: (required)
        :type project_version_request: ProjectVersionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'project_version_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_version_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['project_version_request']:
            _body_params = _params['project_version_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/version', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_wav_export_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], export_wav_data_request : ExportWavDataRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Export data as WAV

        Export all the data in the project in WAV format.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param export_wav_data_request: (required)
        :type export_wav_data_request: ExportWavDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_wav_export_job_with_http_info(project_id, export_wav_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_wav_export_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], export_wav_data_request : ExportWavDataRequest, **kwargs):  # noqa: E501
        """Export data as WAV 

        Export all the data in the project in WAV format.  Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param export_wav_data_request: (required)
        :type export_wav_data_request: ExportWavDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'export_wav_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_wav_export_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['export_wav_data_request']:
            _body_params = _params['export_wav_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/export/wav', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def train_anomaly_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], start_training_request_anomaly : StartTrainingRequestAnomaly, **kwargs) -> StartJobResponse:  # noqa: E501
        """Train model (Anomaly)

        Take the output from a DSP block and train an anomaly detection model using K-means or GMM. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param start_training_request_anomaly: (required)
        :type start_training_request_anomaly: StartTrainingRequestAnomaly
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._train_anomaly_job_with_http_info(project_id, learn_id, start_training_request_anomaly, **kwargs)  # noqa: E501

    @validate_arguments
    def _train_anomaly_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], start_training_request_anomaly : StartTrainingRequestAnomaly, **kwargs):  # noqa: E501
        """Train model (Anomaly) 

        Take the output from a DSP block and train an anomaly detection model using K-means or GMM. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param start_training_request_anomaly: (required)
        :type start_training_request_anomaly: StartTrainingRequestAnomaly
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'start_training_request_anomaly'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method train_anomaly_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['start_training_request_anomaly']:
            _body_params = _params['start_training_request_anomaly']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/train/anomaly/{learnId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def train_keras_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], set_keras_parameter_request : SetKerasParameterRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Train model (Keras)

        Take the output from a DSP block and train a neural network using Keras. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param set_keras_parameter_request: (required)
        :type set_keras_parameter_request: SetKerasParameterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._train_keras_job_with_http_info(project_id, learn_id, set_keras_parameter_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _train_keras_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], set_keras_parameter_request : SetKerasParameterRequest, **kwargs):  # noqa: E501
        """Train model (Keras) 

        Take the output from a DSP block and train a neural network using Keras. Updates are streamed over the websocket API.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param set_keras_parameter_request: (required)
        :type set_keras_parameter_request: SetKerasParameterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'set_keras_parameter_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method train_keras_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_keras_parameter_request']:
            _body_params = _params['set_keras_parameter_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/train/keras/{learnId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_job(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], update_job_request : UpdateJobRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update job

        Update a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param update_job_request: (required)
        :type update_job_request: UpdateJobRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_job_with_http_info(project_id, job_id, update_job_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_job_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], update_job_request : UpdateJobRequest, **kwargs):  # noqa: E501
        """Update job 

        Update a job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param update_job_request: (required)
        :type update_job_request: UpdateJobRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id',
            'update_job_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_job_request']:
            _body_params = _params['update_job_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/{jobId}/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
