# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.add_organization_api_key_request import AddOrganizationApiKeyRequest
from edgeimpulse_api.models.add_organization_deploy_block_response import AddOrganizationDeployBlockResponse
from edgeimpulse_api.models.add_organization_dsp_block_request import AddOrganizationDspBlockRequest
from edgeimpulse_api.models.add_organization_dsp_block_response import AddOrganizationDspBlockResponse
from edgeimpulse_api.models.add_organization_secret_request import AddOrganizationSecretRequest
from edgeimpulse_api.models.add_organization_secret_response import AddOrganizationSecretResponse
from edgeimpulse_api.models.add_organization_transfer_learning_block_request import AddOrganizationTransferLearningBlockRequest
from edgeimpulse_api.models.add_organization_transfer_learning_block_response import AddOrganizationTransferLearningBlockResponse
from edgeimpulse_api.models.add_organization_transformation_block_request import AddOrganizationTransformationBlockRequest
from edgeimpulse_api.models.add_organization_transformation_block_response import AddOrganizationTransformationBlockResponse
from edgeimpulse_api.models.create_organization_request import CreateOrganizationRequest
from edgeimpulse_api.models.create_organization_response import CreateOrganizationResponse
from edgeimpulse_api.models.create_pipeline_response import CreatePipelineResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_job_response import GetJobResponse
from edgeimpulse_api.models.get_organization_pipelines_response import GetOrganizationPipelinesResponse
from edgeimpulse_api.models.list_jobs_response import ListJobsResponse
from edgeimpulse_api.models.list_organization_api_keys_response import ListOrganizationApiKeysResponse
from edgeimpulse_api.models.list_organization_deploy_blocks_response import ListOrganizationDeployBlocksResponse
from edgeimpulse_api.models.list_organization_dsp_blocks_response import ListOrganizationDspBlocksResponse
from edgeimpulse_api.models.list_organization_pipelines_response import ListOrganizationPipelinesResponse
from edgeimpulse_api.models.list_organization_projects_response import ListOrganizationProjectsResponse
from edgeimpulse_api.models.list_organization_secrets_response import ListOrganizationSecretsResponse
from edgeimpulse_api.models.list_organization_transfer_learning_blocks_response import ListOrganizationTransferLearningBlocksResponse
from edgeimpulse_api.models.list_organization_transformation_blocks_response import ListOrganizationTransformationBlocksResponse
from edgeimpulse_api.models.log_stdout_response import LogStdoutResponse
from edgeimpulse_api.models.organization_info_response import OrganizationInfoResponse
from edgeimpulse_api.models.organization_update_pipeline_body import OrganizationUpdatePipelineBody
from edgeimpulse_api.models.run_organization_pipeline_response import RunOrganizationPipelineResponse
from edgeimpulse_api.models.socket_token_response import SocketTokenResponse
from edgeimpulse_api.models.start_job_response import StartJobResponse
from edgeimpulse_api.models.update_organization_dsp_block_request import UpdateOrganizationDspBlockRequest
from edgeimpulse_api.models.update_organization_transfer_learning_block_request import UpdateOrganizationTransferLearningBlockRequest
from edgeimpulse_api.models.update_organization_transformation_block_request import UpdateOrganizationTransformationBlockRequest
from edgeimpulse_api.models.verify_organization_bucket_request import VerifyOrganizationBucketRequest
from edgeimpulse_api.models.verify_organization_bucket_response import VerifyOrganizationBucketResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrganizationAllowDeveloperProfileApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_organization_api_key(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_api_key_request : AddOrganizationApiKeyRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Add API key

        Add an API key.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_api_key_request: (required)
        :type add_organization_api_key_request: AddOrganizationApiKeyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_api_key_with_http_info(organization_id, add_organization_api_key_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_api_key_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_api_key_request : AddOrganizationApiKeyRequest, **kwargs):  # noqa: E501
        """Add API key 

        Add an API key.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_api_key_request: (required)
        :type add_organization_api_key_request: AddOrganizationApiKeyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_api_key_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_api_key" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_api_key_request']:
            _body_params = _params['add_organization_api_key_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/apikeys', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], name : StrictStr, docker_container : StrictStr, description : StrictStr, cli_arguments : StrictStr, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs) -> AddOrganizationDeployBlockResponse:  # noqa: E501
        """Add deploy block

        Adds a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param name: (required)
        :type name: str
        :param docker_container: (required)
        :type docker_container: str
        :param description: (required)
        :type description: str
        :param cli_arguments: (required)
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationDeployBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_deploy_block_with_http_info(organization_id, name, docker_container, description, cli_arguments, requests_cpu, requests_memory, limits_cpu, limits_memory, photo, integrate_url, privileged, mount_learn_block, supports_eon_compiler, show_optimizations, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], name : StrictStr, docker_container : StrictStr, description : StrictStr, cli_arguments : StrictStr, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """Add deploy block 

        Adds a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param name: (required)
        :type name: str
        :param docker_container: (required)
        :type docker_container: str
        :param description: (required)
        :type description: str
        :param cli_arguments: (required)
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationDeployBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'name',
            'docker_container',
            'description',
            'cli_arguments',
            'requests_cpu',
            'requests_memory',
            'limits_cpu',
            'limits_memory',
            'photo',
            'integrate_url',
            'privileged',
            'mount_learn_block',
            'supports_eon_compiler',
            'show_optimizations',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['docker_container']:
            _form_params.append(('dockerContainer', _params['docker_container']))
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['cli_arguments']:
            _form_params.append(('cliArguments', _params['cli_arguments']))
        if _params['requests_cpu']:
            _form_params.append(('requestsCpu', _params['requests_cpu']))
        if _params['requests_memory']:
            _form_params.append(('requestsMemory', _params['requests_memory']))
        if _params['limits_cpu']:
            _form_params.append(('limitsCpu', _params['limits_cpu']))
        if _params['limits_memory']:
            _form_params.append(('limitsMemory', _params['limits_memory']))
        if _params['photo']:
            _files['photo'] = _params['photo']
        if _params['integrate_url']:
            _form_params.append(('integrateUrl', _params['integrate_url']))
        if _params['privileged']:
            _form_params.append(('privileged', _params['privileged']))
        if _params['mount_learn_block']:
            _form_params.append(('mountLearnBlock', _params['mount_learn_block']))
        if _params['supports_eon_compiler']:
            _form_params.append(('supportsEonCompiler', _params['supports_eon_compiler']))
        if _params['show_optimizations']:
            _form_params.append(('showOptimizations', _params['show_optimizations']))
        if _params['category']:
            _form_params.append(('category', _params['category']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationDeployBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_dsp_block_request : AddOrganizationDspBlockRequest, **kwargs) -> AddOrganizationDspBlockResponse:  # noqa: E501
        """Add dsp block

        Adds a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_dsp_block_request: (required)
        :type add_organization_dsp_block_request: AddOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationDspBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_dsp_block_with_http_info(organization_id, add_organization_dsp_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_dsp_block_request : AddOrganizationDspBlockRequest, **kwargs):  # noqa: E501
        """Add dsp block 

        Adds a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_dsp_block_request: (required)
        :type add_organization_dsp_block_request: AddOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationDspBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_dsp_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_dsp_block_request']:
            _body_params = _params['add_organization_dsp_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationDspBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_secret(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_secret_request : AddOrganizationSecretRequest, **kwargs) -> AddOrganizationSecretResponse:  # noqa: E501
        """Add secret

        Adds a secret.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_secret_request: (required)
        :type add_organization_secret_request: AddOrganizationSecretRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationSecretResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_secret_with_http_info(organization_id, add_organization_secret_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_secret_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_secret_request : AddOrganizationSecretRequest, **kwargs):  # noqa: E501
        """Add secret 

        Adds a secret.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_secret_request: (required)
        :type add_organization_secret_request: AddOrganizationSecretRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationSecretResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_secret_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_secret" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_secret_request']:
            _body_params = _params['add_organization_secret_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationSecretResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transfer_learning_block_request : AddOrganizationTransferLearningBlockRequest, **kwargs) -> AddOrganizationTransferLearningBlockResponse:  # noqa: E501
        """Add transfer learning block

        Adds a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transfer_learning_block_request: (required)
        :type add_organization_transfer_learning_block_request: AddOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationTransferLearningBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_transfer_learning_block_with_http_info(organization_id, add_organization_transfer_learning_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transfer_learning_block_request : AddOrganizationTransferLearningBlockRequest, **kwargs):  # noqa: E501
        """Add transfer learning block 

        Adds a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transfer_learning_block_request: (required)
        :type add_organization_transfer_learning_block_request: AddOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationTransferLearningBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_transfer_learning_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_transfer_learning_block_request']:
            _body_params = _params['add_organization_transfer_learning_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationTransferLearningBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transformation_block_request : AddOrganizationTransformationBlockRequest, **kwargs) -> AddOrganizationTransformationBlockResponse:  # noqa: E501
        """Add transformation block

        Adds a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transformation_block_request: (required)
        :type add_organization_transformation_block_request: AddOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationTransformationBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_transformation_block_with_http_info(organization_id, add_organization_transformation_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transformation_block_request : AddOrganizationTransformationBlockRequest, **kwargs):  # noqa: E501
        """Add transformation block 

        Adds a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transformation_block_request: (required)
        :type add_organization_transformation_block_request: AddOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationTransformationBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_transformation_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_transformation_block_request']:
            _body_params = _params['add_organization_transformation_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationTransformationBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def cancel_organization_job(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Cancel job

        Cancel a running job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._cancel_organization_job_with_http_info(organization_id, job_id, force_cancel, **kwargs)  # noqa: E501

    @validate_arguments
    def _cancel_organization_job_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs):  # noqa: E501
        """Cancel job 

        Cancel a running job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'force_cancel'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_organization_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('force_cancel') is not None:  # noqa: E501
            _query_params.append(('forceCancel', _params['force_cancel']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/cancel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_organization(self, create_organization_request : CreateOrganizationRequest, **kwargs) -> CreateOrganizationResponse:  # noqa: E501
        """Create new organization

        Create a new organization. This is an internal API.

        :param create_organization_request: (required)
        :type create_organization_request: CreateOrganizationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateOrganizationResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._create_organization_with_http_info(create_organization_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _create_organization_with_http_info(self, create_organization_request : CreateOrganizationRequest, **kwargs):  # noqa: E501
        """Create new organization 

        Create a new organization. This is an internal API.

        :param create_organization_request: (required)
        :type create_organization_request: CreateOrganizationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateOrganizationResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_organization_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['create_organization_request']:
            _body_params = _params['create_organization_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CreateOrganizationResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/create', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_organization_pipeline(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], organization_update_pipeline_body : OrganizationUpdatePipelineBody, **kwargs) -> CreatePipelineResponse:  # noqa: E501
        """Create pipeline

        Create an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param organization_update_pipeline_body: (required)
        :type organization_update_pipeline_body: OrganizationUpdatePipelineBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatePipelineResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._create_organization_pipeline_with_http_info(organization_id, organization_update_pipeline_body, **kwargs)  # noqa: E501

    @validate_arguments
    def _create_organization_pipeline_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], organization_update_pipeline_body : OrganizationUpdatePipelineBody, **kwargs):  # noqa: E501
        """Create pipeline 

        Create an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param organization_update_pipeline_body: (required)
        :type organization_update_pipeline_body: OrganizationUpdatePipelineBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatePipelineResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'organization_update_pipeline_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization_pipeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['organization_update_pipeline_body']:
            _body_params = _params['organization_update_pipeline_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CreatePipelineResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete deploy block

        Deletes a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_deploy_block_with_http_info(organization_id, deploy_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs):  # noqa: E501
        """Delete deploy block 

        Deletes a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete dsp block

        Deletes a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Delete dsp block 

        Deletes a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_pipeline(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete pipeline

        Delete an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_pipeline_with_http_info(organization_id, pipeline_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_pipeline_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], **kwargs):  # noqa: E501
        """Delete pipeline 

        Delete an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'pipeline_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_pipeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['pipeline_id']:
            _path_params['pipelineId'] = _params['pipeline_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines/{pipelineId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_secret(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], secret_id : Annotated[StrictInt, Field(..., description="Secret ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete transfer learning block

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param secret_id: Secret ID (required)
        :type secret_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_secret_with_http_info(organization_id, secret_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_secret_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], secret_id : Annotated[StrictInt, Field(..., description="Secret ID")], **kwargs):  # noqa: E501
        """Delete transfer learning block 

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param secret_id: Secret ID (required)
        :type secret_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'secret_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_secret" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['secret_id']:
            _path_params['secretId'] = _params['secret_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets/{secretId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete transfer learning block

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs):  # noqa: E501
        """Delete transfer learning block 

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete transformation block

        Deletes a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_transformation_block_with_http_info(organization_id, transformation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs):  # noqa: E501
        """Delete transformation block 

        Deletes a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_organization_jobs_logs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> str:  # noqa: E501
        """Download logs

        Download the logs for a job (as a text file).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_organization_jobs_logs_with_http_info(organization_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_organization_jobs_logs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Download logs 

        Download the logs for a job (as a text file).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_organization_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/stdout/download', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> OrganizationInfoResponse:  # noqa: E501
        """Organization information

        List all information about this organization.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrganizationInfoResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_info_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_info_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Organization information 

        List all information about this organization.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrganizationInfoResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "OrganizationInfoResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_job_status(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> GetJobResponse:  # noqa: E501
        """Get job status

        Get the status for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_job_status_with_http_info(organization_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_job_status_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get job status 

        Get the status for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_job_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetJobResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/status', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_jobs_logs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> LogStdoutResponse:  # noqa: E501
        """Get logs

        Get the logs for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LogStdoutResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_jobs_logs_with_http_info(organization_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_jobs_logs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Get logs 

        Get the logs for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LogStdoutResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "LogStdoutResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/stdout', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_pipeline(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], **kwargs) -> GetOrganizationPipelinesResponse:  # noqa: E501
        """Get pipeline

        Retrieve an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationPipelinesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_pipeline_with_http_info(organization_id, pipeline_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_pipeline_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], **kwargs):  # noqa: E501
        """Get pipeline 

        Retrieve an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationPipelinesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'pipeline_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_pipeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['pipeline_id']:
            _path_params['pipelineId'] = _params['pipeline_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationPipelinesResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines/{pipelineId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_socket_token(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> SocketTokenResponse:  # noqa: E501
        """Get socket token for an organization

        Get a token to authenticate with the web socket interface.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SocketTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_socket_token_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_socket_token_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get socket token for an organization 

        Get a token to authenticate with the web socket interface.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SocketTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_socket_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SocketTokenResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/socket-token', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_active_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List active jobs

        Get all active jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_active_organization_jobs_with_http_info(organization_id, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_active_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List active jobs 

        Get all active jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_all_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_pipeline_transform_jobs : Annotated[Optional[StrictBool], Field(description="Whether to exclude pipeline / transformation jobs")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List all jobs

        Get all jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_pipeline_transform_jobs: Whether to exclude pipeline / transformation jobs
        :type exclude_pipeline_transform_jobs: bool
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_all_organization_jobs_with_http_info(organization_id, start_date, end_date, limit, offset, exclude_pipeline_transform_jobs, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_all_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_pipeline_transform_jobs : Annotated[Optional[StrictBool], Field(description="Whether to exclude pipeline / transformation jobs")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List all jobs 

        Get all jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_pipeline_transform_jobs: Whether to exclude pipeline / transformation jobs
        :type exclude_pipeline_transform_jobs: bool
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'exclude_pipeline_transform_jobs',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('exclude_pipeline_transform_jobs') is not None:  # noqa: E501
            _query_params.append(('excludePipelineTransformJobs', _params['exclude_pipeline_transform_jobs']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_archived_organization_pipelines(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], project_id : Annotated[Optional[StrictInt], Field(description="If set, filters on pipelines which are attached to this project.")] = None, **kwargs) -> ListOrganizationPipelinesResponse:  # noqa: E501
        """List archived pipelines

        Retrieve all archived organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param project_id: If set, filters on pipelines which are attached to this project.
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationPipelinesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_archived_organization_pipelines_with_http_info(organization_id, project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_archived_organization_pipelines_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], project_id : Annotated[Optional[StrictInt], Field(description="If set, filters on pipelines which are attached to this project.")] = None, **kwargs):  # noqa: E501
        """List archived pipelines 

        Retrieve all archived organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param project_id: If set, filters on pipelines which are attached to this project.
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationPipelinesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_archived_organization_pipelines" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('project_id') is not None:  # noqa: E501
            _query_params.append(('projectId', _params['project_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationPipelinesResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines/archived', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_finished_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List finished jobs

        Get all finished jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_finished_organization_jobs_with_http_info(organization_id, start_date, end_date, limit, offset, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_finished_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List finished jobs 

        Get all finished jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_finished_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/history', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_api_keys(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationApiKeysResponse:  # noqa: E501
        """Get API keys

        Retrieve all API keys. This does **not** return the full API key, but only a portion (for security purposes).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationApiKeysResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_api_keys_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_api_keys_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get API keys 

        Retrieve all API keys. This does **not** return the full API key, but only a portion (for security purposes).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationApiKeysResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_api_keys" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationApiKeysResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/apikeys', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_deploy_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationDeployBlocksResponse:  # noqa: E501
        """Get deploy blocks

        Retrieve all deploy blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationDeployBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_deploy_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_deploy_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get deploy blocks 

        Retrieve all deploy blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationDeployBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_deploy_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationDeployBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_dsp_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationDspBlocksResponse:  # noqa: E501
        """Get dsp blocks

        Retrieve all dsp blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationDspBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_dsp_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_dsp_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get dsp blocks 

        Retrieve all dsp blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationDspBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_dsp_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationDspBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_pipelines(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], project_id : Annotated[Optional[StrictInt], Field(description="If set, filters on pipelines which are attached to this project.")] = None, **kwargs) -> ListOrganizationPipelinesResponse:  # noqa: E501
        """List pipelines

        Retrieve all organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param project_id: If set, filters on pipelines which are attached to this project.
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationPipelinesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_pipelines_with_http_info(organization_id, project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_pipelines_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], project_id : Annotated[Optional[StrictInt], Field(description="If set, filters on pipelines which are attached to this project.")] = None, **kwargs):  # noqa: E501
        """List pipelines 

        Retrieve all organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param project_id: If set, filters on pipelines which are attached to this project.
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationPipelinesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_pipelines" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('project_id') is not None:  # noqa: E501
            _query_params.append(('projectId', _params['project_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationPipelinesResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_projects(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationProjectsResponse:  # noqa: E501
        """Get projects

        Retrieve all projects for the organization.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationProjectsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_projects_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_projects_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get projects 

        Retrieve all projects for the organization.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationProjectsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_projects" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationProjectsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/projects', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_secrets(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationSecretsResponse:  # noqa: E501
        """Get secrets

        Retrieve all secrets.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationSecretsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_secrets_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_secrets_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get secrets 

        Retrieve all secrets.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationSecretsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_secrets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationSecretsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_transfer_learning_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationTransferLearningBlocksResponse:  # noqa: E501
        """Get transfer learning blocks

        Retrieve all transfer learning blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationTransferLearningBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_transfer_learning_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_transfer_learning_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get transfer learning blocks 

        Retrieve all transfer learning blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationTransferLearningBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_transfer_learning_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationTransferLearningBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_transformation_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationTransformationBlocksResponse:  # noqa: E501
        """Get transformation blocks

        Retrieve all transformation blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationTransformationBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_transformation_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_transformation_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get transformation blocks 

        Retrieve all transformation blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationTransformationBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_transformation_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationTransformationBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retry_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Retry connection to dsp block

        Retry launch a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._retry_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _retry_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Retry connection to dsp block 

        Retry launch a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}/retry', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retry_organization_upload(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], create_project_id : Annotated[StrictInt, Field(..., description="Create project job ID.")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Retry transformation upload job

        Retry the upload job from a transformation job. Only jobs that have failed can be retried.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param create_project_id: Create project job ID. (required)
        :type create_project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._retry_organization_upload_with_http_info(organization_id, create_project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _retry_organization_upload_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], create_project_id : Annotated[StrictInt, Field(..., description="Create project job ID.")], **kwargs):  # noqa: E501
        """Retry transformation upload job 

        Retry the upload job from a transformation job. Only jobs that have failed can be retried.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param create_project_id: Create project job ID. (required)
        :type create_project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'create_project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_organization_upload" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['create_project_id']:
            _path_params['createProjectId'] = _params['create_project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/create-project/{createProjectId}/upload/retry', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def revoke_organization_api_key(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], api_key_id : Annotated[StrictInt, Field(..., description="API key ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Revoke API key

        Revoke an API key.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param api_key_id: API key ID (required)
        :type api_key_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._revoke_organization_api_key_with_http_info(organization_id, api_key_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _revoke_organization_api_key_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], api_key_id : Annotated[StrictInt, Field(..., description="API key ID")], **kwargs):  # noqa: E501
        """Revoke API key 

        Revoke an API key.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param api_key_id: API key ID (required)
        :type api_key_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'api_key_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_organization_api_key" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['api_key_id']:
            _path_params['apiKeyId'] = _params['api_key_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/apikeys/{apiKeyId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_organization_pipeline(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], ignore_last_successful_run : Annotated[Optional[StrictBool], Field(description="If set then `EI_LAST_SUCCESSFUL_RUN` is not set. You can use this to re-run a pipeline from scratch.")] = None, **kwargs) -> RunOrganizationPipelineResponse:  # noqa: E501
        """Run pipelines

        Run an organizational pipeline

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param ignore_last_successful_run: If set then `EI_LAST_SUCCESSFUL_RUN` is not set. You can use this to re-run a pipeline from scratch.
        :type ignore_last_successful_run: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunOrganizationPipelineResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._run_organization_pipeline_with_http_info(organization_id, pipeline_id, ignore_last_successful_run, **kwargs)  # noqa: E501

    @validate_arguments
    def _run_organization_pipeline_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], ignore_last_successful_run : Annotated[Optional[StrictBool], Field(description="If set then `EI_LAST_SUCCESSFUL_RUN` is not set. You can use this to re-run a pipeline from scratch.")] = None, **kwargs):  # noqa: E501
        """Run pipelines 

        Run an organizational pipeline

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param ignore_last_successful_run: If set then `EI_LAST_SUCCESSFUL_RUN` is not set. You can use this to re-run a pipeline from scratch.
        :type ignore_last_successful_run: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunOrganizationPipelineResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'pipeline_id',
            'ignore_last_successful_run'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_organization_pipeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['pipeline_id']:
            _path_params['pipelineId'] = _params['pipeline_id']

        # process the query parameters
        _query_params = []
        if _params.get('ignore_last_successful_run') is not None:  # noqa: E501
            _query_params.append(('ignoreLastSuccessfulRun', _params['ignore_last_successful_run']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "RunOrganizationPipelineResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines/{pipelineId}/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], name : Optional[StrictStr] = None, docker_container : Optional[StrictStr] = None, description : Optional[StrictStr] = None, cli_arguments : Optional[StrictStr] = None, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update deploy block

        Updates a deploy block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param name:
        :type name: str
        :param docker_container:
        :type docker_container: str
        :param description:
        :type description: str
        :param cli_arguments:
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_deploy_block_with_http_info(organization_id, deploy_id, name, docker_container, description, cli_arguments, requests_cpu, requests_memory, limits_cpu, limits_memory, photo, integrate_url, privileged, mount_learn_block, supports_eon_compiler, show_optimizations, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], name : Optional[StrictStr] = None, docker_container : Optional[StrictStr] = None, description : Optional[StrictStr] = None, cli_arguments : Optional[StrictStr] = None, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """Update deploy block 

        Updates a deploy block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param name:
        :type name: str
        :param docker_container:
        :type docker_container: str
        :param description:
        :type description: str
        :param cli_arguments:
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id',
            'name',
            'docker_container',
            'description',
            'cli_arguments',
            'requests_cpu',
            'requests_memory',
            'limits_cpu',
            'limits_memory',
            'photo',
            'integrate_url',
            'privileged',
            'mount_learn_block',
            'supports_eon_compiler',
            'show_optimizations',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['docker_container']:
            _form_params.append(('dockerContainer', _params['docker_container']))
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['cli_arguments']:
            _form_params.append(('cliArguments', _params['cli_arguments']))
        if _params['requests_cpu']:
            _form_params.append(('requestsCpu', _params['requests_cpu']))
        if _params['requests_memory']:
            _form_params.append(('requestsMemory', _params['requests_memory']))
        if _params['limits_cpu']:
            _form_params.append(('limitsCpu', _params['limits_cpu']))
        if _params['limits_memory']:
            _form_params.append(('limitsMemory', _params['limits_memory']))
        if _params['photo']:
            _files['photo'] = _params['photo']
        if _params['integrate_url']:
            _form_params.append(('integrateUrl', _params['integrate_url']))
        if _params['privileged']:
            _form_params.append(('privileged', _params['privileged']))
        if _params['mount_learn_block']:
            _form_params.append(('mountLearnBlock', _params['mount_learn_block']))
        if _params['supports_eon_compiler']:
            _form_params.append(('supportsEonCompiler', _params['supports_eon_compiler']))
        if _params['show_optimizations']:
            _form_params.append(('showOptimizations', _params['show_optimizations']))
        if _params['category']:
            _form_params.append(('category', _params['category']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], update_organization_dsp_block_request : UpdateOrganizationDspBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update dsp block

        Updates a dsp block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param update_organization_dsp_block_request: (required)
        :type update_organization_dsp_block_request: UpdateOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_dsp_block_with_http_info(organization_id, dsp_id, update_organization_dsp_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], update_organization_dsp_block_request : UpdateOrganizationDspBlockRequest, **kwargs):  # noqa: E501
        """Update dsp block 

        Updates a dsp block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param update_organization_dsp_block_request: (required)
        :type update_organization_dsp_block_request: UpdateOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id',
            'update_organization_dsp_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_dsp_block_request']:
            _body_params = _params['update_organization_dsp_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_pipeline(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], organization_update_pipeline_body : OrganizationUpdatePipelineBody, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update pipeline

        Update an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param organization_update_pipeline_body: (required)
        :type organization_update_pipeline_body: OrganizationUpdatePipelineBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_pipeline_with_http_info(organization_id, pipeline_id, organization_update_pipeline_body, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_pipeline_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], pipeline_id : Annotated[StrictInt, Field(..., description="Pipeline ID")], organization_update_pipeline_body : OrganizationUpdatePipelineBody, **kwargs):  # noqa: E501
        """Update pipeline 

        Update an organizational pipelines

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param pipeline_id: Pipeline ID (required)
        :type pipeline_id: int
        :param organization_update_pipeline_body: (required)
        :type organization_update_pipeline_body: OrganizationUpdatePipelineBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'pipeline_id',
            'organization_update_pipeline_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_pipeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['pipeline_id']:
            _path_params['pipelineId'] = _params['pipeline_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['organization_update_pipeline_body']:
            _body_params = _params['organization_update_pipeline_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/pipelines/{pipelineId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], update_organization_transfer_learning_block_request : UpdateOrganizationTransferLearningBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update transfer learning block

        Updates a transfer learning block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param update_organization_transfer_learning_block_request: (required)
        :type update_organization_transfer_learning_block_request: UpdateOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, update_organization_transfer_learning_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], update_organization_transfer_learning_block_request : UpdateOrganizationTransferLearningBlockRequest, **kwargs):  # noqa: E501
        """Update transfer learning block 

        Updates a transfer learning block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param update_organization_transfer_learning_block_request: (required)
        :type update_organization_transfer_learning_block_request: UpdateOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id',
            'update_organization_transfer_learning_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_transfer_learning_block_request']:
            _body_params = _params['update_organization_transfer_learning_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], update_organization_transformation_block_request : UpdateOrganizationTransformationBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update transformation block

        Updates a transformation block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param update_organization_transformation_block_request: (required)
        :type update_organization_transformation_block_request: UpdateOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_transformation_block_with_http_info(organization_id, transformation_id, update_organization_transformation_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], update_organization_transformation_block_request : UpdateOrganizationTransformationBlockRequest, **kwargs):  # noqa: E501
        """Update transformation block 

        Updates a transformation block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param update_organization_transformation_block_request: (required)
        :type update_organization_transformation_block_request: UpdateOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id',
            'update_organization_transformation_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_transformation_block_request']:
            _body_params = _params['update_organization_transformation_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_custom_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], tar : StrictStr, type : StrictStr, block_id : StrictInt, **kwargs) -> StartJobResponse:  # noqa: E501
        """Upload a custom block

        Upload a zip file containing a custom transformation or deployment block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param tar: (required)
        :type tar: str
        :param type: (required)
        :type type: str
        :param block_id: (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._upload_custom_block_with_http_info(organization_id, tar, type, block_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _upload_custom_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], tar : StrictStr, type : StrictStr, block_id : StrictInt, **kwargs):  # noqa: E501
        """Upload a custom block 

        Upload a zip file containing a custom transformation or deployment block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param tar: (required)
        :type tar: str
        :param type: (required)
        :type type: str
        :param block_id: (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'tar',
            'type',
            'block_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_custom_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['tar']:
            _files['tar'] = _params['tar']
        if _params['type']:
            _form_params.append(('type', _params['type']))
        if _params['block_id']:
            _form_params.append(('blockId', _params['block_id']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/custom-block', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def verify_organization_bucket(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], verify_organization_bucket_request : VerifyOrganizationBucketRequest, **kwargs) -> VerifyOrganizationBucketResponse:  # noqa: E501
        """Verify bucket connectivity

        Verify whether we can reach a bucket before adding it.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param verify_organization_bucket_request: (required)
        :type verify_organization_bucket_request: VerifyOrganizationBucketRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VerifyOrganizationBucketResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._verify_organization_bucket_with_http_info(organization_id, verify_organization_bucket_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _verify_organization_bucket_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], verify_organization_bucket_request : VerifyOrganizationBucketRequest, **kwargs):  # noqa: E501
        """Verify bucket connectivity 

        Verify whether we can reach a bucket before adding it.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param verify_organization_bucket_request: (required)
        :type verify_organization_bucket_request: VerifyOrganizationBucketRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VerifyOrganizationBucketResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'verify_organization_bucket_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_organization_bucket" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['verify_organization_bucket_request']:
            _body_params = _params['verify_organization_bucket_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "VerifyOrganizationBucketResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/buckets/verify', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
