# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_job_response import GetJobResponse
from edgeimpulse_api.models.list_jobs_response import ListJobsResponse
from edgeimpulse_api.models.log_stdout_response import LogStdoutResponse
from edgeimpulse_api.models.socket_token_response import SocketTokenResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrganizationJobsApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def cancel_organization_job(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Cancel job

        Cancel a running job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._cancel_organization_job_with_http_info(organization_id, job_id, force_cancel, **kwargs)  # noqa: E501

    @validate_arguments
    def _cancel_organization_job_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], force_cancel : Annotated[Optional[StrictStr], Field(description="If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.")] = None, **kwargs):  # noqa: E501
        """Cancel job 

        Cancel a running job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param force_cancel: If set to 'true', we won't wait for the job cluster to cancel the job, and will mark the job as finished.
        :type force_cancel: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'force_cancel'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_organization_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('force_cancel') is not None:  # noqa: E501
            _query_params.append(('forceCancel', _params['force_cancel']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/cancel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_organization_jobs_logs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> str:  # noqa: E501
        """Download logs

        Download the logs for a job (as a text file).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_organization_jobs_logs_with_http_info(organization_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_organization_jobs_logs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Download logs 

        Download the logs for a job (as a text file).

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_organization_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/stdout/download', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_job_status(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> GetJobResponse:  # noqa: E501
        """Get job status

        Get the status for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_job_status_with_http_info(organization_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_job_status_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get job status 

        Get the status for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_job_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetJobResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/status', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_jobs_logs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs) -> LogStdoutResponse:  # noqa: E501
        """Get logs

        Get the logs for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LogStdoutResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_jobs_logs_with_http_info(organization_id, job_id, limit, log_level, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_jobs_logs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, log_level : Annotated[Optional[StrictStr], Field(description="Log level (error, warn, info, debug)")] = None, **kwargs):  # noqa: E501
        """Get logs 

        Get the logs for a job.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param log_level: Log level (error, warn, info, debug)
        :type log_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LogStdoutResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'job_id',
            'limit',
            'log_level'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_jobs_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('log_level') is not None:  # noqa: E501
            _query_params.append(('logLevel', _params['log_level']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "LogStdoutResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/{jobId}/stdout', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_socket_token(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> SocketTokenResponse:  # noqa: E501
        """Get socket token for an organization

        Get a token to authenticate with the web socket interface.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SocketTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_socket_token_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_socket_token_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get socket token for an organization 

        Get a token to authenticate with the web socket interface.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SocketTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_socket_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SocketTokenResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/socket-token', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_active_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List active jobs

        Get all active jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_active_organization_jobs_with_http_info(organization_id, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_active_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List active jobs 

        Get all active jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_all_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_pipeline_transform_jobs : Annotated[Optional[StrictBool], Field(description="Whether to exclude pipeline / transformation jobs")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List all jobs

        Get all jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_pipeline_transform_jobs: Whether to exclude pipeline / transformation jobs
        :type exclude_pipeline_transform_jobs: bool
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_all_organization_jobs_with_http_info(organization_id, start_date, end_date, limit, offset, exclude_pipeline_transform_jobs, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_all_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_pipeline_transform_jobs : Annotated[Optional[StrictBool], Field(description="Whether to exclude pipeline / transformation jobs")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List all jobs 

        Get all jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_pipeline_transform_jobs: Whether to exclude pipeline / transformation jobs
        :type exclude_pipeline_transform_jobs: bool
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'exclude_pipeline_transform_jobs',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('exclude_pipeline_transform_jobs') is not None:  # noqa: E501
            _query_params.append(('excludePipelineTransformJobs', _params['exclude_pipeline_transform_jobs']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_finished_organization_jobs(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs) -> ListJobsResponse:  # noqa: E501
        """List finished jobs

        Get all finished jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListJobsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_finished_organization_jobs_with_http_info(organization_id, start_date, end_date, limit, offset, root_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_finished_organization_jobs_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], start_date : Annotated[Optional[datetime], Field(description="Start date")] = None, end_date : Annotated[Optional[datetime], Field(description="End date")] = None, limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, root_only : Annotated[Optional[StrictBool], Field(description="Whether to exclude jobs with a parent ID (so jobs started as part of another job)")] = None, **kwargs):  # noqa: E501
        """List finished jobs 

        Get all finished jobs for this organization

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param start_date: Start date
        :type start_date: datetime
        :param end_date: End date
        :type end_date: datetime
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param root_only: Whether to exclude jobs with a parent ID (so jobs started as part of another job)
        :type root_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListJobsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'start_date',
            'end_date',
            'limit',
            'offset',
            'root_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_finished_organization_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('startDate', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('endDate', _params['end_date']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListJobsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/jobs/history', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
