# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from edgeimpulse_api.models.entitlement_limits import EntitlementLimits

class AdminOrganizationInfoResponseAllOf(BaseModel):
    billable: Optional[StrictBool] = None
    entitlement_limits: Optional[EntitlementLimits] = Field(None, alias="entitlementLimits")
    total_jobs_compute_time: Optional[float] = Field(None, alias="totalJobsComputeTime", description="Total compute time of all organizational jobs since the creation of the organization (including organizational project jobs).")
    jobs_compute_time_current_year: Optional[float] = Field(None, alias="jobsComputeTimeCurrentYear", description="Total compute time of all jobs in the organization in the current year (including organizational project jobs).")
    jobs_compute_time_current_year_since: Optional[datetime] = Field(None, alias="jobsComputeTimeCurrentYearSince", description="The date from which the compute time for the running year is calculated.")
    total_storage: Optional[float] = Field(None, alias="totalStorage", description="Total storage used by the organization.")
    __properties = ["billable", "entitlementLimits", "totalJobsComputeTime", "jobsComputeTimeCurrentYear", "jobsComputeTimeCurrentYearSince", "totalStorage"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AdminOrganizationInfoResponseAllOf:
        """Create an instance of AdminOrganizationInfoResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of entitlement_limits
        if self.entitlement_limits:
            _dict['entitlementLimits'] = self.entitlement_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminOrganizationInfoResponseAllOf:
        """Create an instance of AdminOrganizationInfoResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminOrganizationInfoResponseAllOf.construct(**obj)

        _obj = AdminOrganizationInfoResponseAllOf.construct(**{
            "billable": obj.get("billable"),
            "entitlement_limits": EntitlementLimits.from_dict(obj.get("entitlementLimits")) if obj.get("entitlementLimits") is not None else None,
            "total_jobs_compute_time": obj.get("totalJobsComputeTime"),
            "jobs_compute_time_current_year": obj.get("jobsComputeTimeCurrentYear"),
            "jobs_compute_time_current_year_since": obj.get("jobsComputeTimeCurrentYearSince"),
            "total_storage": obj.get("totalStorage")
        })
        return _obj

