# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class CreateEnterpriseTrialUserRequest(BaseModel):
    email: StrictStr = Field(..., description="Email of the user. Only business email addresses are allowed. Emails with free domains like gmail.com or yahoo.com are not allowed.")
    organization_name: Optional[StrictStr] = Field(None, alias="organizationName", description="Name of the trial organization. All enterprise features are tied to an organization. This organization will be deleted after the trial ends. If no organization name is provided, the user's name will be used.")
    expiration_date: Optional[datetime] = Field(None, alias="expirationDate", description="Expiration date of the trial. The trial will be set as expired after this date. There will be a grace period of 30 days after a trial expires before fully deleting the trial organization. This field is ignored if the trial is requested by a non-admin user, defaulting to 14 days trial.")
    notes: Optional[StrictStr] = Field(None, description="Notes about the trial. Free form text. This field is ignored if the trial is requested by a non-admin user.")
    use_case: Optional[StrictStr] = Field(None, alias="useCase", description="Use case of the trial.")
    user_has_ml_models_in_production: Optional[StrictStr] = Field(None, alias="userHasMLModelsInProduction", description="Whether the user has ML models in production.")
    company_name: Optional[StrictStr] = Field(None, alias="companyName", description="Name of the company requesting the trial.")
    company_size: Optional[StrictStr] = Field(None, alias="companySize", description="Size of the company requesting the trial. This is a range of number of employees.")
    country: Optional[StrictStr] = Field(None, description="Country of the company requesting the trial.")
    state_or_province: Optional[StrictStr] = Field(None, alias="stateOrProvince", description="State or province of the company requesting the trial.")
    name: StrictStr = Field(..., description="Name of the user.")
    username: StrictStr = Field(..., description="Username, minimum 4 and maximum 30 characters. May contain alphanumeric characters, hyphens, underscores and dots. Validated according to `^(?=.{4,30}$)(?![_.])(?!.*[_.]{2})[a-zA-Z0-9._-]+(?<![_.])$`.")
    privacy_policy: StrictBool = Field(..., alias="privacyPolicy", description="Whether the user has accepted the terms of service and privacy policy.")
    password: Optional[StrictStr] = Field(None, description="Password of the user. Minimum length 8 characters.")
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle", description="Job title of the user.")
    __properties = ["email", "organizationName", "expirationDate", "notes", "useCase", "userHasMLModelsInProduction", "companyName", "companySize", "country", "stateOrProvince", "name", "username", "privacyPolicy", "password", "jobTitle"]

    @validator('user_has_ml_models_in_production')
    def user_has_ml_models_in_production_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('yes', 'no', 'no, but we will soon'):
            raise ValueError("must validate the enum values ('yes', 'no', 'no, but we will soon')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateEnterpriseTrialUserRequest:
        """Create an instance of CreateEnterpriseTrialUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateEnterpriseTrialUserRequest:
        """Create an instance of CreateEnterpriseTrialUserRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateEnterpriseTrialUserRequest.construct(**obj)

        _obj = CreateEnterpriseTrialUserRequest.construct(**{
            "email": obj.get("email"),
            "organization_name": obj.get("organizationName"),
            "expiration_date": obj.get("expirationDate"),
            "notes": obj.get("notes"),
            "use_case": obj.get("useCase"),
            "user_has_ml_models_in_production": obj.get("userHasMLModelsInProduction"),
            "company_name": obj.get("companyName"),
            "company_size": obj.get("companySize"),
            "country": obj.get("country"),
            "state_or_province": obj.get("stateOrProvince"),
            "name": obj.get("name"),
            "username": obj.get("username"),
            "privacy_policy": obj.get("privacyPolicy"),
            "password": obj.get("password"),
            "job_title": obj.get("jobTitle")
        })
        return _obj

