# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from edgeimpulse_api.models.model_prediction import ModelPrediction

class DataExplorerPredictionsResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    predictions: List[ModelPrediction] = ...
    labels: List[StrictStr] = ...
    classification_type: StrictStr = Field(..., alias="classificationType")
    __properties = ["success", "error", "predictions", "labels", "classificationType"]

    @validator('classification_type')
    def classification_type_validate_enum(cls, v):
        if v not in ('classification', 'regression'):
            raise ValueError("must validate the enum values ('classification', 'regression')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataExplorerPredictionsResponse:
        """Create an instance of DataExplorerPredictionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in predictions (list)
        _items = []
        if self.predictions:
            for _item in self.predictions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['predictions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataExplorerPredictionsResponse:
        """Create an instance of DataExplorerPredictionsResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DataExplorerPredictionsResponse.construct(**obj)

        _obj = DataExplorerPredictionsResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "predictions": [ModelPrediction.from_dict(_item) for _item in obj.get("predictions")] if obj.get("predictions") is not None else None,
            "labels": obj.get("labels"),
            "classification_type": obj.get("classificationType")
        })
        return _obj

