# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class EnterpriseTrial(BaseModel):
    id: StrictInt = Field(..., description="Unique identifier of the trial.")
    user_id: Optional[StrictInt] = Field(None, alias="userId", description="ID of the user who created the trial.")
    organization_id: Optional[StrictInt] = Field(None, alias="organizationId", description="ID of the organization created for the trial.")
    created: datetime = Field(..., description="Date when the trial was created. Trials start immediately on creation.")
    expiration_date: datetime = Field(..., alias="expirationDate", description="Expiration date of the trial. The trial will be set as expired after this date. There will be a grace period of 30 days after a trial expires before fully deleting the trial organization. This field is ignored if the trial is requested by a non-admin user, defaulting to 14 days trial.")
    notes: Optional[StrictStr] = Field(None, description="Notes about the trial. Free form text. This field is ignored if the trial is requested by a non-admin user.")
    expired_date: Optional[datetime] = Field(..., alias="expiredDate", description="Date when the trial actually expired. This is set when the trial is expired by the system.")
    deleted_date: Optional[datetime] = Field(..., alias="deletedDate", description="Date when the trial was deleted. This is set when the trial is fully  deleted by the system.")
    upgraded_date: Optional[datetime] = Field(..., alias="upgradedDate", description="Date when the trial was upgraded to a full enterprise account.")
    __properties = ["id", "userId", "organizationId", "created", "expirationDate", "notes", "expiredDate", "deletedDate", "upgradedDate"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EnterpriseTrial:
        """Create an instance of EnterpriseTrial from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if expired_date (nullable) is None
        if self.expired_date is None:
            _dict['expiredDate'] = None

        # set to None if deleted_date (nullable) is None
        if self.deleted_date is None:
            _dict['deletedDate'] = None

        # set to None if upgraded_date (nullable) is None
        if self.upgraded_date is None:
            _dict['upgradedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EnterpriseTrial:
        """Create an instance of EnterpriseTrial from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EnterpriseTrial.construct(**obj)

        _obj = EnterpriseTrial.construct(**{
            "id": obj.get("id"),
            "user_id": obj.get("userId"),
            "organization_id": obj.get("organizationId"),
            "created": obj.get("created"),
            "expiration_date": obj.get("expirationDate"),
            "notes": obj.get("notes"),
            "expired_date": obj.get("expiredDate"),
            "deleted_date": obj.get("deletedDate"),
            "upgraded_date": obj.get("upgradedDate")
        })
        return _obj

