# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.get_last_deployment_build_response_all_of_last_build import GetLastDeploymentBuildResponseAllOfLastBuild

class GetLastDeploymentBuildResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    has_build: StrictBool = Field(..., alias="hasBuild", description="Does the deployment build still exist? (Builds are deleted if they are no longer valid for the project)")
    last_build: Optional[GetLastDeploymentBuildResponseAllOfLastBuild] = Field(None, alias="lastBuild")
    __properties = ["success", "error", "hasBuild", "lastBuild"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetLastDeploymentBuildResponse:
        """Create an instance of GetLastDeploymentBuildResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of last_build
        if self.last_build:
            _dict['lastBuild'] = self.last_build.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetLastDeploymentBuildResponse:
        """Create an instance of GetLastDeploymentBuildResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetLastDeploymentBuildResponse.construct(**obj)

        _obj = GetLastDeploymentBuildResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "has_build": obj.get("hasBuild"),
            "last_build": GetLastDeploymentBuildResponseAllOfLastBuild.from_dict(obj.get("lastBuild")) if obj.get("lastBuild") is not None else None
        })
        return _obj

