# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class ModelPrediction(BaseModel):
    sample_id: StrictInt = Field(..., alias="sampleId")
    start_ms: float = Field(..., alias="startMs")
    end_ms: float = Field(..., alias="endMs")
    prediction: StrictStr = ...
    prediction_correct: Optional[StrictBool] = Field(None, alias="predictionCorrect")
    f1_score: Optional[float] = Field(None, alias="f1Score", description="Only set for object detection projects")
    __properties = ["sampleId", "startMs", "endMs", "prediction", "predictionCorrect", "f1Score"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModelPrediction:
        """Create an instance of ModelPrediction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModelPrediction:
        """Create an instance of ModelPrediction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ModelPrediction.construct(**obj)

        _obj = ModelPrediction.construct(**{
            "sample_id": obj.get("sampleId"),
            "start_ms": obj.get("startMs"),
            "end_ms": obj.get("endMs"),
            "prediction": obj.get("prediction"),
            "prediction_correct": obj.get("predictionCorrect"),
            "f1_score": obj.get("f1Score")
        })
        return _obj

