# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.optimize_config import OptimizeConfig
from edgeimpulse_api.models.optimize_state_response_all_of_status import OptimizeStateResponseAllOfStatus
from edgeimpulse_api.models.optimize_state_response_all_of_workers import OptimizeStateResponseAllOfWorkers
from edgeimpulse_api.models.tuner_trial import TunerTrial

class OptimizeStateResponseAllOf(BaseModel):
    config: OptimizeConfig = ...
    status: OptimizeStateResponseAllOfStatus = ...
    active_tuner_job_id: Optional[StrictInt] = Field(None, alias="activeTunerJobId")
    trials: List[TunerTrial] = ...
    project_data_type: Optional[StrictStr] = Field(None, alias="projectDataType")
    job_error: Optional[StrictStr] = Field(None, alias="jobError")
    workers: List[OptimizeStateResponseAllOfWorkers] = ...
    __properties = ["config", "status", "activeTunerJobId", "trials", "projectDataType", "jobError", "workers"]

    @validator('project_data_type')
    def project_data_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('audio', 'image', 'motion', 'other'):
            raise ValueError("must validate the enum values ('audio', 'image', 'motion', 'other')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OptimizeStateResponseAllOf:
        """Create an instance of OptimizeStateResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in trials (list)
        _items = []
        if self.trials:
            for _item in self.trials:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trials'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in workers (list)
        _items = []
        if self.workers:
            for _item in self.workers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OptimizeStateResponseAllOf:
        """Create an instance of OptimizeStateResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OptimizeStateResponseAllOf.construct(**obj)

        _obj = OptimizeStateResponseAllOf.construct(**{
            "config": OptimizeConfig.from_dict(obj.get("config")) if obj.get("config") is not None else None,
            "status": OptimizeStateResponseAllOfStatus.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "active_tuner_job_id": obj.get("activeTunerJobId"),
            "trials": [TunerTrial.from_dict(_item) for _item in obj.get("trials")] if obj.get("trials") is not None else None,
            "project_data_type": obj.get("projectDataType"),
            "job_error": obj.get("jobError"),
            "workers": [OptimizeStateResponseAllOfWorkers.from_dict(_item) for _item in obj.get("workers")] if obj.get("workers") is not None else None
        })
        return _obj

