# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictInt

class OrganizationMetricsResponseAllOfMetrics(BaseModel):
    total_jobs_compute_time: float = Field(..., alias="totalJobsComputeTime", description="Total compute time of all organizational jobs since the creation of the organization (including organizational project jobs).")
    jobs_compute_time_current_year: float = Field(..., alias="jobsComputeTimeCurrentYear", description="Total compute time of all jobs in the organization in the current year (including organizational project jobs).")
    jobs_compute_time_current_year_since: datetime = Field(..., alias="jobsComputeTimeCurrentYearSince", description="The date from which the compute time for the running year is calculated.")
    total_storage: float = Field(..., alias="totalStorage", description="Total storage used by the organization.")
    project_count: StrictInt = Field(..., alias="projectCount", description="Total number of projects owned by the organization.")
    user_count: StrictInt = Field(..., alias="userCount", description="Total number of users in the organization.")
    __properties = ["totalJobsComputeTime", "jobsComputeTimeCurrentYear", "jobsComputeTimeCurrentYearSince", "totalStorage", "projectCount", "userCount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationMetricsResponseAllOfMetrics:
        """Create an instance of OrganizationMetricsResponseAllOfMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationMetricsResponseAllOfMetrics:
        """Create an instance of OrganizationMetricsResponseAllOfMetrics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationMetricsResponseAllOfMetrics.construct(**obj)

        _obj = OrganizationMetricsResponseAllOfMetrics.construct(**{
            "total_jobs_compute_time": obj.get("totalJobsComputeTime"),
            "jobs_compute_time_current_year": obj.get("jobsComputeTimeCurrentYear"),
            "jobs_compute_time_current_year_since": obj.get("jobsComputeTimeCurrentYearSince"),
            "total_storage": obj.get("totalStorage"),
            "project_count": obj.get("projectCount"),
            "user_count": obj.get("userCount")
        })
        return _obj

