# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.organization_pipeline_feeding_into_dataset import OrganizationPipelineFeedingIntoDataset
from edgeimpulse_api.models.organization_pipeline_feeding_into_project import OrganizationPipelineFeedingIntoProject
from edgeimpulse_api.models.organization_pipeline_run import OrganizationPipelineRun
from edgeimpulse_api.models.organization_pipeline_step import OrganizationPipelineStep

class OrganizationPipeline(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    description: StrictStr = ...
    interval_str: Optional[StrictStr] = Field(None, alias="intervalStr", description="15m for every 15 minutes, 2h for every 2 hours, 1d for every 1 day")
    steps: List[OrganizationPipelineStep] = ...
    next_run: Optional[datetime] = Field(None, alias="nextRun")
    created: datetime = ...
    current_run: Optional[OrganizationPipelineRun] = Field(None, alias="currentRun")
    last_run: Optional[OrganizationPipelineRun] = Field(None, alias="lastRun")
    feeding_into_dataset: Optional[OrganizationPipelineFeedingIntoDataset] = Field(None, alias="feedingIntoDataset")
    feeding_into_project: Optional[OrganizationPipelineFeedingIntoProject] = Field(None, alias="feedingIntoProject")
    email_recipient_uids: List[StrictInt] = Field(..., alias="emailRecipientUids")
    last_run_start_error: Optional[StrictStr] = Field(None, alias="lastRunStartError")
    notification_webhook: Optional[StrictStr] = Field(None, alias="notificationWebhook")
    when_to_email: StrictStr = Field(..., alias="whenToEmail")
    __properties = ["id", "name", "description", "intervalStr", "steps", "nextRun", "created", "currentRun", "lastRun", "feedingIntoDataset", "feedingIntoProject", "emailRecipientUids", "lastRunStartError", "notificationWebhook", "whenToEmail"]

    @validator('when_to_email')
    def when_to_email_validate_enum(cls, v):
        if v not in ('always', 'on_new_data', 'never'):
            raise ValueError("must validate the enum values ('always', 'on_new_data', 'never')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationPipeline:
        """Create an instance of OrganizationPipeline from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of current_run
        if self.current_run:
            _dict['currentRun'] = self.current_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_run
        if self.last_run:
            _dict['lastRun'] = self.last_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of feeding_into_dataset
        if self.feeding_into_dataset:
            _dict['feedingIntoDataset'] = self.feeding_into_dataset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of feeding_into_project
        if self.feeding_into_project:
            _dict['feedingIntoProject'] = self.feeding_into_project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationPipeline:
        """Create an instance of OrganizationPipeline from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationPipeline.construct(**obj)

        _obj = OrganizationPipeline.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "interval_str": obj.get("intervalStr"),
            "steps": [OrganizationPipelineStep.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "next_run": obj.get("nextRun"),
            "created": obj.get("created"),
            "current_run": OrganizationPipelineRun.from_dict(obj.get("currentRun")) if obj.get("currentRun") is not None else None,
            "last_run": OrganizationPipelineRun.from_dict(obj.get("lastRun")) if obj.get("lastRun") is not None else None,
            "feeding_into_dataset": OrganizationPipelineFeedingIntoDataset.from_dict(obj.get("feedingIntoDataset")) if obj.get("feedingIntoDataset") is not None else None,
            "feeding_into_project": OrganizationPipelineFeedingIntoProject.from_dict(obj.get("feedingIntoProject")) if obj.get("feedingIntoProject") is not None else None,
            "email_recipient_uids": obj.get("emailRecipientUids"),
            "last_run_start_error": obj.get("lastRunStartError"),
            "notification_webhook": obj.get("notificationWebhook"),
            "when_to_email": obj.get("whenToEmail")
        })
        return _obj

