# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.image_input_scaling import ImageInputScaling
from edgeimpulse_api.models.object_detection_last_layer import ObjectDetectionLastLayer
from edgeimpulse_api.models.organization_transfer_learning_operates_on import OrganizationTransferLearningOperatesOn

class OrganizationTransferLearningBlock(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    docker_container: StrictStr = Field(..., alias="dockerContainer")
    docker_container_managed_by_edge_impulse: StrictBool = Field(..., alias="dockerContainerManagedByEdgeImpulse")
    created: datetime = ...
    description: StrictStr = ...
    user_id: Optional[StrictInt] = Field(None, alias="userId")
    user_name: Optional[StrictStr] = Field(None, alias="userName")
    operates_on: OrganizationTransferLearningOperatesOn = Field(..., alias="operatesOn")
    object_detection_last_layer: Optional[ObjectDetectionLastLayer] = Field(None, alias="objectDetectionLastLayer")
    implementation_version: StrictInt = Field(..., alias="implementationVersion")
    is_public: StrictBool = Field(..., alias="isPublic", description="Whether this block is publicly available to Edge Impulse users (if false, then only for members of the owning organization)")
    is_public_for_devices: List[StrictStr] = Field(..., alias="isPublicForDevices", description="If `isPublic` is true, the list of devices (from latencyDevices) for which this model can be shown.")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl", description="URL to the source code of this custom learn block.")
    parameters: List[Dict[str, Any]] = Field(..., description="List of parameters, spec'ed according to https://docs.edgeimpulse.com/docs/tips-and-tricks/adding-parameters-to-custom-blocks")
    image_input_scaling: Optional[ImageInputScaling] = Field(None, alias="imageInputScaling")
    ind_requires_gpu: StrictBool = Field(..., alias="indRequiresGpu", description="If set, requires this block to be scheduled on GPU.")
    __properties = ["id", "name", "dockerContainer", "dockerContainerManagedByEdgeImpulse", "created", "description", "userId", "userName", "operatesOn", "objectDetectionLastLayer", "implementationVersion", "isPublic", "isPublicForDevices", "repositoryUrl", "parameters", "imageInputScaling", "indRequiresGpu"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationTransferLearningBlock:
        """Create an instance of OrganizationTransferLearningBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationTransferLearningBlock:
        """Create an instance of OrganizationTransferLearningBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationTransferLearningBlock.construct(**obj)

        _obj = OrganizationTransferLearningBlock.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "docker_container": obj.get("dockerContainer"),
            "docker_container_managed_by_edge_impulse": obj.get("dockerContainerManagedByEdgeImpulse"),
            "created": obj.get("created"),
            "description": obj.get("description"),
            "user_id": obj.get("userId"),
            "user_name": obj.get("userName"),
            "operates_on": obj.get("operatesOn"),
            "object_detection_last_layer": obj.get("objectDetectionLastLayer"),
            "implementation_version": obj.get("implementationVersion"),
            "is_public": obj.get("isPublic"),
            "is_public_for_devices": obj.get("isPublicForDevices"),
            "repository_url": obj.get("repositoryUrl"),
            "parameters": obj.get("parameters"),
            "image_input_scaling": obj.get("imageInputScaling"),
            "ind_requires_gpu": obj.get("indRequiresGpu")
        })
        return _obj

