# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.organization_member_role import OrganizationMemberRole
from edgeimpulse_api.models.permission import Permission
from edgeimpulse_api.models.staff_info import StaffInfo

class OrganizationUser(BaseModel):
    id: StrictInt = ...
    username: StrictStr = ...
    name: StrictStr = ...
    email: StrictStr = ...
    photo: Optional[StrictStr] = None
    created: datetime = ...
    last_seen: Optional[datetime] = Field(None, alias="lastSeen")
    staff_info: StaffInfo = Field(..., alias="staffInfo")
    pending: StrictBool = ...
    last_tos_acceptance_date: Optional[datetime] = Field(None, alias="lastTosAcceptanceDate")
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle")
    permissions: Optional[List[Permission]] = Field(None, description="List of permissions the user has")
    company_name: Optional[StrictStr] = Field(None, alias="companyName")
    activated: StrictBool = Field(..., description="Whether the user has activated their account or not.")
    added: datetime = ...
    role: OrganizationMemberRole = ...
    project_count: StrictInt = Field(..., alias="projectCount")
    datasets: List[StrictStr] = ...
    __properties = ["id", "username", "name", "email", "photo", "created", "lastSeen", "staffInfo", "pending", "lastTosAcceptanceDate", "jobTitle", "permissions", "companyName", "activated", "added", "role", "projectCount", "datasets"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationUser:
        """Create an instance of OrganizationUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of staff_info
        if self.staff_info:
            _dict['staffInfo'] = self.staff_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationUser:
        """Create an instance of OrganizationUser from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationUser.construct(**obj)

        _obj = OrganizationUser.construct(**{
            "id": obj.get("id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "photo": obj.get("photo"),
            "created": obj.get("created"),
            "last_seen": obj.get("lastSeen"),
            "staff_info": StaffInfo.from_dict(obj.get("staffInfo")) if obj.get("staffInfo") is not None else None,
            "pending": obj.get("pending"),
            "last_tos_acceptance_date": obj.get("lastTosAcceptanceDate"),
            "job_title": obj.get("jobTitle"),
            "permissions": obj.get("permissions"),
            "company_name": obj.get("companyName"),
            "activated": obj.get("activated"),
            "added": obj.get("added"),
            "role": obj.get("role"),
            "project_count": obj.get("projectCount"),
            "datasets": obj.get("datasets")
        })
        return _obj

