# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.project_collaborator import ProjectCollaborator

class Project(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    description: StrictStr = ...
    created: datetime = ...
    owner: StrictStr = Field(..., description="User or organization that owns the project")
    last_accessed: Optional[datetime] = Field(None, alias="lastAccessed")
    logo: Optional[StrictStr] = Field(None, description="Custom logo for this project (not available for all projects)")
    owner_user_id: Optional[StrictInt] = Field(None, alias="ownerUserId")
    owner_organization_id: Optional[StrictInt] = Field(None, alias="ownerOrganizationId")
    owner_avatar: Optional[StrictStr] = Field(None, alias="ownerAvatar", description="URL of the project owner avatar, if any.")
    owner_is_developer_profile: StrictBool = Field(..., alias="ownerIsDeveloperProfile")
    collaborators: List[ProjectCollaborator] = ...
    labeling_method: StrictStr = Field(..., alias="labelingMethod")
    metadata: Dict[str, Any] = Field(..., description="Metadata about the project")
    data_explorer_screenshot: Optional[StrictStr] = Field(None, alias="dataExplorerScreenshot")
    is_enterprise_project: StrictBool = Field(..., alias="isEnterpriseProject", description="Whether this is an enterprise project")
    whitelabel_id: Optional[StrictInt] = Field(..., alias="whitelabelId", description="Unique identifier of the white label this project belongs to, if any.")
    tags: Optional[List[StrictStr]] = Field(None, description="List of project tags")
    category: Optional[StrictStr] = Field(None, description="Project category")
    license: Optional[StrictStr] = Field(None, description="Public project license, if any.")
    tier: StrictStr = ...
    has_public_version: StrictBool = Field(..., alias="hasPublicVersion", description="Whether this project has been published or not.")
    __properties = ["id", "name", "description", "created", "owner", "lastAccessed", "logo", "ownerUserId", "ownerOrganizationId", "ownerAvatar", "ownerIsDeveloperProfile", "collaborators", "labelingMethod", "metadata", "dataExplorerScreenshot", "isEnterpriseProject", "whitelabelId", "tags", "category", "license", "tier", "hasPublicVersion"]

    @validator('labeling_method')
    def labeling_method_validate_enum(cls, v):
        if v not in ('single_label', 'object_detection'):
            raise ValueError("must validate the enum values ('single_label', 'object_detection')")
        return v

    @validator('tier')
    def tier_validate_enum(cls, v):
        if v not in ('free', 'pro', 'enterprise'):
            raise ValueError("must validate the enum values ('free', 'pro', 'enterprise')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Project:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in collaborators (list)
        _items = []
        if self.collaborators:
            for _item in self.collaborators:
                if _item:
                    _items.append(_item.to_dict())
            _dict['collaborators'] = _items
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Project:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Project.construct(**obj)

        _obj = Project.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "owner": obj.get("owner"),
            "last_accessed": obj.get("lastAccessed"),
            "logo": obj.get("logo"),
            "owner_user_id": obj.get("ownerUserId"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "owner_avatar": obj.get("ownerAvatar"),
            "owner_is_developer_profile": obj.get("ownerIsDeveloperProfile"),
            "collaborators": [ProjectCollaborator.from_dict(_item) for _item in obj.get("collaborators")] if obj.get("collaborators") is not None else None,
            "labeling_method": obj.get("labelingMethod"),
            "metadata": obj.get("metadata"),
            "data_explorer_screenshot": obj.get("dataExplorerScreenshot"),
            "is_enterprise_project": obj.get("isEnterpriseProject"),
            "whitelabel_id": obj.get("whitelabelId"),
            "tags": obj.get("tags"),
            "category": obj.get("category"),
            "license": obj.get("license"),
            "tier": obj.get("tier"),
            "has_public_version": obj.get("hasPublicVersion")
        })
        return _obj

