# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class ProjectInfoResponseAllOfAcquisitionSettings(BaseModel):
    interval_ms: float = Field(..., alias="intervalMs", description="Interval during the last acquisition, or the recommended interval based on the data set.")
    length_ms: StrictInt = Field(..., alias="lengthMs", description="Length of the last acquisition, or a recommended interval based on the data set.")
    sensor: Optional[StrictStr] = Field(None, description="Sensor that was used during the last acquisition.")
    label: Optional[StrictStr] = Field(None, description="Label that was used during the last acquisition.")
    segment_length: Optional[float] = Field(None, alias="segmentLength", description="Length of the last sample segment after segmenting a larger sample.")
    segment_shift: StrictBool = Field(..., alias="segmentShift", description="Whether to auto-shift segments")
    __properties = ["intervalMs", "lengthMs", "sensor", "label", "segmentLength", "segmentShift"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectInfoResponseAllOfAcquisitionSettings:
        """Create an instance of ProjectInfoResponseAllOfAcquisitionSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectInfoResponseAllOfAcquisitionSettings:
        """Create an instance of ProjectInfoResponseAllOfAcquisitionSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProjectInfoResponseAllOfAcquisitionSettings.construct(**obj)

        _obj = ProjectInfoResponseAllOfAcquisitionSettings.construct(**{
            "interval_ms": obj.get("intervalMs"),
            "length_ms": obj.get("lengthMs"),
            "sensor": obj.get("sensor"),
            "label": obj.get("label"),
            "segment_length": obj.get("segmentLength"),
            "segment_shift": obj.get("segmentShift")
        })
        return _obj

