# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr

class StructuredClassifyResult(BaseModel):
    boxes: Optional[List[List[float]]] = Field(None, description="For object detection. An array of bounding box arrays, (x, y, width, height), one per detection in the image.")
    labels: Optional[List[StrictStr]] = Field(None, description="For object detection. An array of labels, one per detection in the image.")
    scores: Optional[List[float]] = Field(None, description="For object detection. An array of probability scores, one per detection in the image.")
    m_ap: Optional[float] = Field(None, alias="mAP", description="For object detection. A score that indicates accuracy compared to the ground truth, if available.")
    f1: Optional[float] = Field(None, description="For FOMO. A score that combines the precision and recall of a classifier into a single metric, if available.")
    precision: Optional[float] = Field(None, description="A measure of how many of the positive predictions made are correct (true positives).")
    recall: Optional[float] = Field(None, description="A measure of how many of the positive cases the classifier correctly predicted, over all the positive cases.")
    debug_info_json: Optional[StrictStr] = Field(None, alias="debugInfoJson", description="Debug info in JSON format")
    __properties = ["boxes", "labels", "scores", "mAP", "f1", "precision", "recall", "debugInfoJson"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StructuredClassifyResult:
        """Create an instance of StructuredClassifyResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StructuredClassifyResult:
        """Create an instance of StructuredClassifyResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StructuredClassifyResult.construct(**obj)

        _obj = StructuredClassifyResult.construct(**{
            "boxes": obj.get("boxes"),
            "labels": obj.get("labels"),
            "scores": obj.get("scores"),
            "m_ap": obj.get("mAP"),
            "f1": obj.get("f1"),
            "precision": obj.get("precision"),
            "recall": obj.get("recall"),
            "debug_info_json": obj.get("debugInfoJson")
        })
        return _obj

