# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.tuner_trial_blocks_inner import TunerTrialBlocksInner
from edgeimpulse_api.models.tuner_trial_dsp_job_id import TunerTrialDspJobId

class TunerTrial(BaseModel):
    id: StrictStr = ...
    status: StrictStr = ...
    last_completed_epoch: Optional[datetime] = Field(None, alias="lastCompletedEpoch")
    last_completed_training: Optional[datetime] = Field(None, alias="lastCompletedTraining")
    retries: Optional[StrictInt] = None
    current_epoch: Optional[StrictInt] = Field(None, alias="currentEpoch")
    worker_id: Optional[StrictStr] = Field(None, alias="workerId")
    blocks: Optional[List[TunerTrialBlocksInner]] = None
    impulse: Optional[Dict[str, Any]] = None
    experiment: Optional[StrictStr] = None
    original_trial_id: Optional[StrictStr] = None
    model: Optional[Dict[str, Any]] = None
    dsp_job_id: Optional[TunerTrialDspJobId] = Field(None, alias="dspJobId")
    learn_job_id: Optional[float] = Field(None, alias="learnJobId")
    __properties = ["id", "status", "lastCompletedEpoch", "lastCompletedTraining", "retries", "currentEpoch", "workerId", "blocks", "impulse", "experiment", "original_trial_id", "model", "dspJobId", "learnJobId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TunerTrial:
        """Create an instance of TunerTrial from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in blocks (list)
        _items = []
        if self.blocks:
            for _item in self.blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['blocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of dsp_job_id
        if self.dsp_job_id:
            _dict['dspJobId'] = self.dsp_job_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TunerTrial:
        """Create an instance of TunerTrial from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TunerTrial.construct(**obj)

        _obj = TunerTrial.construct(**{
            "id": obj.get("id"),
            "status": obj.get("status"),
            "last_completed_epoch": obj.get("lastCompletedEpoch"),
            "last_completed_training": obj.get("lastCompletedTraining"),
            "retries": obj.get("retries"),
            "current_epoch": obj.get("currentEpoch"),
            "worker_id": obj.get("workerId"),
            "blocks": [TunerTrialBlocksInner.from_dict(_item) for _item in obj.get("blocks")] if obj.get("blocks") is not None else None,
            "impulse": obj.get("impulse"),
            "experiment": obj.get("experiment"),
            "original_trial_id": obj.get("original_trial_id"),
            "model": obj.get("model"),
            "dsp_job_id": TunerTrialDspJobId.from_dict(obj.get("dspJobId")) if obj.get("dspJobId") is not None else None,
            "learn_job_id": obj.get("learnJobId")
        })
        return _obj

