# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, validator
from edgeimpulse_api.models.update_organization_dataset_request_bucket import UpdateOrganizationDatasetRequestBucket

class UpdateOrganizationDatasetRequest(BaseModel):
    dataset: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]] = None
    category: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    bucket: Optional[UpdateOrganizationDatasetRequestBucket] = None
    __properties = ["dataset", "tags", "category", "type", "bucket"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('clinical', 'files'):
            raise ValueError("must validate the enum values ('clinical', 'files')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateOrganizationDatasetRequest:
        """Create an instance of UpdateOrganizationDatasetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of bucket
        if self.bucket:
            _dict['bucket'] = self.bucket.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateOrganizationDatasetRequest:
        """Create an instance of UpdateOrganizationDatasetRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UpdateOrganizationDatasetRequest.construct(**obj)

        _obj = UpdateOrganizationDatasetRequest.construct(**{
            "dataset": obj.get("dataset"),
            "tags": obj.get("tags"),
            "category": obj.get("category"),
            "type": obj.get("type"),
            "bucket": UpdateOrganizationDatasetRequestBucket.from_dict(obj.get("bucket")) if obj.get("bucket") is not None else None
        })
        return _obj

