# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class UserOrganization(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    logo: Optional[StrictStr] = None
    is_developer_profile: StrictBool = Field(..., alias="isDeveloperProfile")
    whitelabel_id: Optional[StrictInt] = Field(..., alias="whitelabelId", description="Unique identifier of the white label this project belongs to, if any.")
    is_admin: StrictBool = Field(..., alias="isAdmin", description="Whether the user is admin of this organization or not.")
    created: datetime = Field(..., description="When the organization was created.")
    trial_id: Optional[float] = Field(..., alias="trialId", description="Unique identifier of the trial this organization belongs to, if any.")
    trial_expired_date: Optional[datetime] = Field(..., alias="trialExpiredDate", description="Date when the trial expired, if any. A expired trial has a grace period of 30 days before it's associated organization is deleted.")
    trial_upgraded_date: Optional[datetime] = Field(..., alias="trialUpgradedDate", description="Date when the trial was upgraded to a full enterprise account, if any.")
    __properties = ["id", "name", "logo", "isDeveloperProfile", "whitelabelId", "isAdmin", "created", "trialId", "trialExpiredDate", "trialUpgradedDate"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserOrganization:
        """Create an instance of UserOrganization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        # set to None if trial_id (nullable) is None
        if self.trial_id is None:
            _dict['trialId'] = None

        # set to None if trial_expired_date (nullable) is None
        if self.trial_expired_date is None:
            _dict['trialExpiredDate'] = None

        # set to None if trial_upgraded_date (nullable) is None
        if self.trial_upgraded_date is None:
            _dict['trialUpgradedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserOrganization:
        """Create an instance of UserOrganization from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UserOrganization.construct(**obj)

        _obj = UserOrganization.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "logo": obj.get("logo"),
            "is_developer_profile": obj.get("isDeveloperProfile"),
            "whitelabel_id": obj.get("whitelabelId"),
            "is_admin": obj.get("isAdmin"),
            "created": obj.get("created"),
            "trial_id": obj.get("trialId"),
            "trial_expired_date": obj.get("trialExpiredDate"),
            "trial_upgraded_date": obj.get("trialUpgradedDate")
        })
        return _obj

