# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventStreamArgs', 'EventStream']

@pulumi.input_type
class EventStreamArgs:
    def __init__(__self__, *,
                 destination_type: pulumi.Input[_builtins.str],
                 subscriptions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 eventbridge_configuration: Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_configuration: Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']] = None):
        """
        The set of arguments for constructing a EventStream resource.
        :param pulumi.Input[_builtins.str] destination_type: The type of event stream destination (either 'eventbridge' or 'webhook').
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of event types this stream is subscribed to.
        :param pulumi.Input['EventStreamEventbridgeConfigurationArgs'] eventbridge_configuration: Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        :param pulumi.Input[_builtins.str] name: The name of the event stream.
        :param pulumi.Input['EventStreamWebhookConfigurationArgs'] webhook_configuration: Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "subscriptions", subscriptions)
        if eventbridge_configuration is not None:
            pulumi.set(__self__, "eventbridge_configuration", eventbridge_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if webhook_configuration is not None:
            pulumi.set(__self__, "webhook_configuration", webhook_configuration)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of event stream destination (either 'eventbridge' or 'webhook').
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of event types this stream is subscribed to.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subscriptions", value)

    @_builtins.property
    @pulumi.getter(name="eventbridgeConfiguration")
    def eventbridge_configuration(self) -> Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']]:
        """
        Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        """
        return pulumi.get(self, "eventbridge_configuration")

    @eventbridge_configuration.setter
    def eventbridge_configuration(self, value: Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']]):
        pulumi.set(self, "eventbridge_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']]:
        """
        Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        return pulumi.get(self, "webhook_configuration")

    @webhook_configuration.setter
    def webhook_configuration(self, value: Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']]):
        pulumi.set(self, "webhook_configuration", value)


@pulumi.input_type
class _EventStreamState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventbridge_configuration: Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_configuration: Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering EventStream resources.
        :param pulumi.Input[_builtins.str] created_at: The ISO 8601 timestamp when the stream was created.
        :param pulumi.Input[_builtins.str] destination_type: The type of event stream destination (either 'eventbridge' or 'webhook').
        :param pulumi.Input['EventStreamEventbridgeConfigurationArgs'] eventbridge_configuration: Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        :param pulumi.Input[_builtins.str] name: The name of the event stream.
        :param pulumi.Input[_builtins.str] status: The current status of the event stream.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of event types this stream is subscribed to.
        :param pulumi.Input[_builtins.str] updated_at: The ISO 8601 timestamp when the stream was last updated.
        :param pulumi.Input['EventStreamWebhookConfigurationArgs'] webhook_configuration: Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if eventbridge_configuration is not None:
            pulumi.set(__self__, "eventbridge_configuration", eventbridge_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if webhook_configuration is not None:
            pulumi.set(__self__, "webhook_configuration", webhook_configuration)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timestamp when the stream was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of event stream destination (either 'eventbridge' or 'webhook').
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter(name="eventbridgeConfiguration")
    def eventbridge_configuration(self) -> Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']]:
        """
        Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        """
        return pulumi.get(self, "eventbridge_configuration")

    @eventbridge_configuration.setter
    def eventbridge_configuration(self, value: Optional[pulumi.Input['EventStreamEventbridgeConfigurationArgs']]):
        pulumi.set(self, "eventbridge_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the event stream.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of event types this stream is subscribed to.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subscriptions", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timestamp when the stream was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']]:
        """
        Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        return pulumi.get(self, "webhook_configuration")

    @webhook_configuration.setter
    def webhook_configuration(self, value: Optional[pulumi.Input['EventStreamWebhookConfigurationArgs']]):
        pulumi.set(self, "webhook_configuration", value)


@pulumi.type_token("auth0:index/eventStream:EventStream")
class EventStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventbridge_configuration: Optional[pulumi.Input[Union['EventStreamEventbridgeConfigurationArgs', 'EventStreamEventbridgeConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 webhook_configuration: Optional[pulumi.Input[Union['EventStreamWebhookConfigurationArgs', 'EventStreamWebhookConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Allows you to manage Auth0 Event Streams.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Creates an event stream of type eventbridge
        my_event_stream_event_bridge = auth0.EventStream("my_event_stream_event_bridge",
            name="my-eventbridge",
            destination_type="eventbridge",
            subscriptions=[
                "user.created",
                "user.updated",
            ],
            eventbridge_configuration={
                "aws_account_id": "242849305777",
                "aws_region": "us-east-1",
            })
        # Creates an event stream of type webhook
        my_event_stream_webhook = auth0.EventStream("my_event_stream_webhook",
            name="my-webhook",
            destination_type="webhook",
            subscriptions=[
                "user.created",
                "user.updated",
            ],
            webhook_configuration={
                "webhook_endpoint": "https://eof28wtn4v4506o.m.pipedream.net",
                "webhook_authorization": {
                    "method": "bearer",
                    "token": "123456789",
                },
            })
        ```

        ## Import

        This resource can be imported by specifying the Event Stream ID.

        Example:

        ```sh
        $ pulumi import auth0:index/eventStream:EventStream my_stream "est_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_type: The type of event stream destination (either 'eventbridge' or 'webhook').
        :param pulumi.Input[Union['EventStreamEventbridgeConfigurationArgs', 'EventStreamEventbridgeConfigurationArgsDict']] eventbridge_configuration: Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        :param pulumi.Input[_builtins.str] name: The name of the event stream.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of event types this stream is subscribed to.
        :param pulumi.Input[Union['EventStreamWebhookConfigurationArgs', 'EventStreamWebhookConfigurationArgsDict']] webhook_configuration: Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to manage Auth0 Event Streams.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Creates an event stream of type eventbridge
        my_event_stream_event_bridge = auth0.EventStream("my_event_stream_event_bridge",
            name="my-eventbridge",
            destination_type="eventbridge",
            subscriptions=[
                "user.created",
                "user.updated",
            ],
            eventbridge_configuration={
                "aws_account_id": "242849305777",
                "aws_region": "us-east-1",
            })
        # Creates an event stream of type webhook
        my_event_stream_webhook = auth0.EventStream("my_event_stream_webhook",
            name="my-webhook",
            destination_type="webhook",
            subscriptions=[
                "user.created",
                "user.updated",
            ],
            webhook_configuration={
                "webhook_endpoint": "https://eof28wtn4v4506o.m.pipedream.net",
                "webhook_authorization": {
                    "method": "bearer",
                    "token": "123456789",
                },
            })
        ```

        ## Import

        This resource can be imported by specifying the Event Stream ID.

        Example:

        ```sh
        $ pulumi import auth0:index/eventStream:EventStream my_stream "est_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param EventStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventbridge_configuration: Optional[pulumi.Input[Union['EventStreamEventbridgeConfigurationArgs', 'EventStreamEventbridgeConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 webhook_configuration: Optional[pulumi.Input[Union['EventStreamWebhookConfigurationArgs', 'EventStreamWebhookConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventStreamArgs.__new__(EventStreamArgs)

            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            __props__.__dict__["eventbridge_configuration"] = eventbridge_configuration
            __props__.__dict__["name"] = name
            if subscriptions is None and not opts.urn:
                raise TypeError("Missing required property 'subscriptions'")
            __props__.__dict__["subscriptions"] = subscriptions
            __props__.__dict__["webhook_configuration"] = webhook_configuration
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(EventStream, __self__).__init__(
            'auth0:index/eventStream:EventStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            eventbridge_configuration: Optional[pulumi.Input[Union['EventStreamEventbridgeConfigurationArgs', 'EventStreamEventbridgeConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            webhook_configuration: Optional[pulumi.Input[Union['EventStreamWebhookConfigurationArgs', 'EventStreamWebhookConfigurationArgsDict']]] = None) -> 'EventStream':
        """
        Get an existing EventStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The ISO 8601 timestamp when the stream was created.
        :param pulumi.Input[_builtins.str] destination_type: The type of event stream destination (either 'eventbridge' or 'webhook').
        :param pulumi.Input[Union['EventStreamEventbridgeConfigurationArgs', 'EventStreamEventbridgeConfigurationArgsDict']] eventbridge_configuration: Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        :param pulumi.Input[_builtins.str] name: The name of the event stream.
        :param pulumi.Input[_builtins.str] status: The current status of the event stream.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of event types this stream is subscribed to.
        :param pulumi.Input[_builtins.str] updated_at: The ISO 8601 timestamp when the stream was last updated.
        :param pulumi.Input[Union['EventStreamWebhookConfigurationArgs', 'EventStreamWebhookConfigurationArgsDict']] webhook_configuration: Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventStreamState.__new__(_EventStreamState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["eventbridge_configuration"] = eventbridge_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["subscriptions"] = subscriptions
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["webhook_configuration"] = webhook_configuration
        return EventStream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO 8601 timestamp when the stream was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of event stream destination (either 'eventbridge' or 'webhook').
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="eventbridgeConfiguration")
    def eventbridge_configuration(self) -> pulumi.Output[Optional['outputs.EventStreamEventbridgeConfiguration']]:
        """
        Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        """
        return pulumi.get(self, "eventbridge_configuration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the event stream.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of event types this stream is subscribed to.
        """
        return pulumi.get(self, "subscriptions")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO 8601 timestamp when the stream was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> pulumi.Output[Optional['outputs.EventStreamWebhookConfiguration']]:
        """
        Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        return pulumi.get(self, "webhook_configuration")

