# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetClientGrantsResult',
    'AwaitableGetClientGrantsResult',
    'get_client_grants',
    'get_client_grants_output',
]

@pulumi.output_type
class GetClientGrantsResult:
    """
    A collection of values returned by getClientGrants.
    """
    def __init__(__self__, audience=None, client_grants=None, client_id=None, id=None):
        if audience and not isinstance(audience, str):
            raise TypeError("Expected argument 'audience' to be a str")
        pulumi.set(__self__, "audience", audience)
        if client_grants and not isinstance(client_grants, list):
            raise TypeError("Expected argument 'client_grants' to be a list")
        pulumi.set(__self__, "client_grants", client_grants)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[_builtins.str]:
        """
        The audience to filter by.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter(name="clientGrants")
    def client_grants(self) -> Sequence['outputs.GetClientGrantsClientGrantResult']:
        """
        List of client grants matching the criteria.
        """
        return pulumi.get(self, "client_grants")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The ID of the client to filter by.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetClientGrantsResult(GetClientGrantsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientGrantsResult(
            audience=self.audience,
            client_grants=self.client_grants,
            client_id=self.client_id,
            id=self.id)


def get_client_grants(audience: Optional[_builtins.str] = None,
                      client_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientGrantsResult:
    """
    Data source to retrieve a client grants based on client_id and/or audience


    :param _builtins.str audience: The audience to filter by.
    :param _builtins.str client_id: The ID of the client to filter by.
    """
    __args__ = dict()
    __args__['audience'] = audience
    __args__['clientId'] = client_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getClientGrants:getClientGrants', __args__, opts=opts, typ=GetClientGrantsResult).value

    return AwaitableGetClientGrantsResult(
        audience=pulumi.get(__ret__, 'audience'),
        client_grants=pulumi.get(__ret__, 'client_grants'),
        client_id=pulumi.get(__ret__, 'client_id'),
        id=pulumi.get(__ret__, 'id'))
def get_client_grants_output(audience: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             client_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClientGrantsResult]:
    """
    Data source to retrieve a client grants based on client_id and/or audience


    :param _builtins.str audience: The audience to filter by.
    :param _builtins.str client_id: The ID of the client to filter by.
    """
    __args__ = dict()
    __args__['audience'] = audience
    __args__['clientId'] = client_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getClientGrants:getClientGrants', __args__, opts=opts, typ=GetClientGrantsResult)
    return __ret__.apply(lambda __response__: GetClientGrantsResult(
        audience=pulumi.get(__response__, 'audience'),
        client_grants=pulumi.get(__response__, 'client_grants'),
        client_id=pulumi.get(__response__, 'client_id'),
        id=pulumi.get(__response__, 'id')))
