# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationDiscoveryDomainArgs', 'OrganizationDiscoveryDomain']

@pulumi.input_type
class OrganizationDiscoveryDomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationDiscoveryDomain resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for organization discovery.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] status: Verification status. Must be either 'pending' or 'verified'.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name for organization discovery.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Verification status. Must be either 'pending' or 'verified'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _OrganizationDiscoveryDomainState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_host: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_txt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationDiscoveryDomain resources.
        :param pulumi.Input[_builtins.str] domain: The domain name for organization discovery.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] status: Verification status. Must be either 'pending' or 'verified'.
        :param pulumi.Input[_builtins.str] verification_host: The full domain where the TXT record should be added.
        :param pulumi.Input[_builtins.str] verification_txt: TXT record value for domain verification.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if verification_host is not None:
            pulumi.set(__self__, "verification_host", verification_host)
        if verification_txt is not None:
            pulumi.set(__self__, "verification_txt", verification_txt)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name for organization discovery.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Verification status. Must be either 'pending' or 'verified'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="verificationHost")
    def verification_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full domain where the TXT record should be added.
        """
        return pulumi.get(self, "verification_host")

    @verification_host.setter
    def verification_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verification_host", value)

    @_builtins.property
    @pulumi.getter(name="verificationTxt")
    def verification_txt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TXT record value for domain verification.
        """
        return pulumi.get(self, "verification_txt")

    @verification_txt.setter
    def verification_txt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verification_txt", value)


@pulumi.type_token("auth0:index/organizationDiscoveryDomain:OrganizationDiscoveryDomain")
class OrganizationDiscoveryDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage organization discovery domains for Home Realm Discovery. These domains help automatically route users to the correct organization based on their email domain.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for organization discovery.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] status: Verification status. Must be either 'pending' or 'verified'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationDiscoveryDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage organization discovery domains for Home Realm Discovery. These domains help automatically route users to the correct organization based on their email domain.

        :param str resource_name: The name of the resource.
        :param OrganizationDiscoveryDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationDiscoveryDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationDiscoveryDomainArgs.__new__(OrganizationDiscoveryDomainArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["verification_host"] = None
            __props__.__dict__["verification_txt"] = None
        super(OrganizationDiscoveryDomain, __self__).__init__(
            'auth0:index/organizationDiscoveryDomain:OrganizationDiscoveryDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            verification_host: Optional[pulumi.Input[_builtins.str]] = None,
            verification_txt: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationDiscoveryDomain':
        """
        Get an existing OrganizationDiscoveryDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for organization discovery.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] status: Verification status. Must be either 'pending' or 'verified'.
        :param pulumi.Input[_builtins.str] verification_host: The full domain where the TXT record should be added.
        :param pulumi.Input[_builtins.str] verification_txt: TXT record value for domain verification.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationDiscoveryDomainState.__new__(_OrganizationDiscoveryDomainState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["status"] = status
        __props__.__dict__["verification_host"] = verification_host
        __props__.__dict__["verification_txt"] = verification_txt
        return OrganizationDiscoveryDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name for organization discovery.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Verification status. Must be either 'pending' or 'verified'.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="verificationHost")
    def verification_host(self) -> pulumi.Output[_builtins.str]:
        """
        The full domain where the TXT record should be added.
        """
        return pulumi.get(self, "verification_host")

    @_builtins.property
    @pulumi.getter(name="verificationTxt")
    def verification_txt(self) -> pulumi.Output[_builtins.str]:
        """
        TXT record value for domain verification.
        """
        return pulumi.get(self, "verification_txt")

