# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationDiscoveryDomainsArgs', 'OrganizationDiscoveryDomains']

@pulumi.input_type
class OrganizationDiscoveryDomainsArgs:
    def __init__(__self__, *,
                 discovery_domains: pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]],
                 organization_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationDiscoveryDomains resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]] discovery_domains: Discovery domains that are configured for the organization.
        :param pulumi.Input[_builtins.str] organization_id: ID of the organization on which to manage the discovery domains.
        """
        pulumi.set(__self__, "discovery_domains", discovery_domains)
        pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter(name="discoveryDomains")
    def discovery_domains(self) -> pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]]:
        """
        Discovery domains that are configured for the organization.
        """
        return pulumi.get(self, "discovery_domains")

    @discovery_domains.setter
    def discovery_domains(self, value: pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]]):
        pulumi.set(self, "discovery_domains", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the organization on which to manage the discovery domains.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)


@pulumi.input_type
class _OrganizationDiscoveryDomainsState:
    def __init__(__self__, *,
                 discovery_domains: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationDiscoveryDomains resources.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]] discovery_domains: Discovery domains that are configured for the organization.
        :param pulumi.Input[_builtins.str] organization_id: ID of the organization on which to manage the discovery domains.
        """
        if discovery_domains is not None:
            pulumi.set(__self__, "discovery_domains", discovery_domains)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter(name="discoveryDomains")
    def discovery_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]]]:
        """
        Discovery domains that are configured for the organization.
        """
        return pulumi.get(self, "discovery_domains")

    @discovery_domains.setter
    def discovery_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationDiscoveryDomainsDiscoveryDomainArgs']]]]):
        pulumi.set(self, "discovery_domains", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the organization on which to manage the discovery domains.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)


@pulumi.type_token("auth0:index/organizationDiscoveryDomains:OrganizationDiscoveryDomains")
class OrganizationDiscoveryDomains(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 discovery_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationDiscoveryDomainsDiscoveryDomainArgs', 'OrganizationDiscoveryDomainsDiscoveryDomainArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can manage discovery domains on an organization.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationDiscoveryDomainsDiscoveryDomainArgs', 'OrganizationDiscoveryDomainsDiscoveryDomainArgsDict']]]] discovery_domains: Discovery domains that are configured for the organization.
        :param pulumi.Input[_builtins.str] organization_id: ID of the organization on which to manage the discovery domains.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationDiscoveryDomainsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage discovery domains on an organization.

        :param str resource_name: The name of the resource.
        :param OrganizationDiscoveryDomainsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationDiscoveryDomainsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 discovery_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationDiscoveryDomainsDiscoveryDomainArgs', 'OrganizationDiscoveryDomainsDiscoveryDomainArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationDiscoveryDomainsArgs.__new__(OrganizationDiscoveryDomainsArgs)

            if discovery_domains is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_domains'")
            __props__.__dict__["discovery_domains"] = discovery_domains
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
        super(OrganizationDiscoveryDomains, __self__).__init__(
            'auth0:index/organizationDiscoveryDomains:OrganizationDiscoveryDomains',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            discovery_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationDiscoveryDomainsDiscoveryDomainArgs', 'OrganizationDiscoveryDomainsDiscoveryDomainArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationDiscoveryDomains':
        """
        Get an existing OrganizationDiscoveryDomains resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationDiscoveryDomainsDiscoveryDomainArgs', 'OrganizationDiscoveryDomainsDiscoveryDomainArgsDict']]]] discovery_domains: Discovery domains that are configured for the organization.
        :param pulumi.Input[_builtins.str] organization_id: ID of the organization on which to manage the discovery domains.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationDiscoveryDomainsState.__new__(_OrganizationDiscoveryDomainsState)

        __props__.__dict__["discovery_domains"] = discovery_domains
        __props__.__dict__["organization_id"] = organization_id
        return OrganizationDiscoveryDomains(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="discoveryDomains")
    def discovery_domains(self) -> pulumi.Output[Sequence['outputs.OrganizationDiscoveryDomainsDiscoveryDomain']]:
        """
        Discovery domains that are configured for the organization.
        """
        return pulumi.get(self, "discovery_domains")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the organization on which to manage the discovery domains.
        """
        return pulumi.get(self, "organization_id")

