# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 cli_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_assertion_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_assertion_signing_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 debug: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_credentials: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] api_token: Your Auth0 [management api access token](https://auth0.com/docs/security/tokens/access-tokens/management-api-access-tokens). It can also be sourced from the `AUTH0_API_TOKEN` environment variable. It can be used instead of `client_id` + `client_secret`. If both are specified, `api_token` will be used over `client_id` + `client_secret` fields.
        :param pulumi.Input[_builtins.str] audience: Your Auth0 audience when using a custom domain. It can also be sourced from the `AUTH0_AUDIENCE` environment variable.
        :param pulumi.Input[_builtins.bool] cli_login: While toggled on, the API token gets fetched from the keyring for the given domain
        :param pulumi.Input[_builtins.str] client_assertion_private_key: The private key used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_PRIVATE_KEY` environment variable.
        :param pulumi.Input[_builtins.str] client_assertion_signing_alg: The algorithm used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_SIGNING_ALG` environment variable.
        :param pulumi.Input[_builtins.str] client_id: Your Auth0 client ID. It can also be sourced from the `AUTH0_CLIENT_ID` environment variable.
        :param pulumi.Input[_builtins.str] client_secret: Your Auth0 client secret. It can also be sourced from the `AUTH0_CLIENT_SECRET` environment variable.
        :param pulumi.Input[_builtins.str] custom_domain_header: When specified, this header is added to requests targeting a set of pre-defined whitelisted URLs Global setting overrides all resource specific `custom_domain_header` value
        :param pulumi.Input[_builtins.bool] debug: Enables HTTP request and response logging when TF_LOG=DEBUG is set. It can also be sourced from the `AUTH0_DEBUG` environment variable.
        :param pulumi.Input[_builtins.str] domain: Your Auth0 domain name. It can also be sourced from the `AUTH0_DOMAIN` environment variable.
        """
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if cli_login is not None:
            pulumi.set(__self__, "cli_login", cli_login)
        if client_assertion_private_key is not None:
            pulumi.set(__self__, "client_assertion_private_key", client_assertion_private_key)
        if client_assertion_signing_alg is not None:
            pulumi.set(__self__, "client_assertion_signing_alg", client_assertion_signing_alg)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom_domain_header is not None:
            pulumi.set(__self__, "custom_domain_header", custom_domain_header)
        if debug is None:
            debug = _utilities.get_env_bool('AUTH0_DEBUG')
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if dynamic_credentials is not None:
            pulumi.set(__self__, "dynamic_credentials", dynamic_credentials)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Auth0 [management api access token](https://auth0.com/docs/security/tokens/access-tokens/management-api-access-tokens). It can also be sourced from the `AUTH0_API_TOKEN` environment variable. It can be used instead of `client_id` + `client_secret`. If both are specified, `api_token` will be used over `client_id` + `client_secret` fields.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_token", value)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Auth0 audience when using a custom domain. It can also be sourced from the `AUTH0_AUDIENCE` environment variable.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="cliLogin")
    def cli_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        While toggled on, the API token gets fetched from the keyring for the given domain
        """
        return pulumi.get(self, "cli_login")

    @cli_login.setter
    def cli_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cli_login", value)

    @_builtins.property
    @pulumi.getter(name="clientAssertionPrivateKey")
    def client_assertion_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "client_assertion_private_key")

    @client_assertion_private_key.setter
    def client_assertion_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_assertion_private_key", value)

    @_builtins.property
    @pulumi.getter(name="clientAssertionSigningAlg")
    def client_assertion_signing_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_SIGNING_ALG` environment variable.
        """
        return pulumi.get(self, "client_assertion_signing_alg")

    @client_assertion_signing_alg.setter
    def client_assertion_signing_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_assertion_signing_alg", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Auth0 client ID. It can also be sourced from the `AUTH0_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Auth0 client secret. It can also be sourced from the `AUTH0_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="customDomainHeader")
    def custom_domain_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When specified, this header is added to requests targeting a set of pre-defined whitelisted URLs Global setting overrides all resource specific `custom_domain_header` value
        """
        return pulumi.get(self, "custom_domain_header")

    @custom_domain_header.setter
    def custom_domain_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_header", value)

    @_builtins.property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables HTTP request and response logging when TF_LOG=DEBUG is set. It can also be sourced from the `AUTH0_DEBUG` environment variable.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "debug", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Auth0 domain name. It can also be sourced from the `AUTH0_DOMAIN` environment variable.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="dynamicCredentials")
    def dynamic_credentials(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "dynamic_credentials")

    @dynamic_credentials.setter
    def dynamic_credentials(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_credentials", value)


@pulumi.type_token("pulumi:providers:auth0")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 cli_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_assertion_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_assertion_signing_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 debug: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the auth0 package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_token: Your Auth0 [management api access token](https://auth0.com/docs/security/tokens/access-tokens/management-api-access-tokens). It can also be sourced from the `AUTH0_API_TOKEN` environment variable. It can be used instead of `client_id` + `client_secret`. If both are specified, `api_token` will be used over `client_id` + `client_secret` fields.
        :param pulumi.Input[_builtins.str] audience: Your Auth0 audience when using a custom domain. It can also be sourced from the `AUTH0_AUDIENCE` environment variable.
        :param pulumi.Input[_builtins.bool] cli_login: While toggled on, the API token gets fetched from the keyring for the given domain
        :param pulumi.Input[_builtins.str] client_assertion_private_key: The private key used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_PRIVATE_KEY` environment variable.
        :param pulumi.Input[_builtins.str] client_assertion_signing_alg: The algorithm used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_SIGNING_ALG` environment variable.
        :param pulumi.Input[_builtins.str] client_id: Your Auth0 client ID. It can also be sourced from the `AUTH0_CLIENT_ID` environment variable.
        :param pulumi.Input[_builtins.str] client_secret: Your Auth0 client secret. It can also be sourced from the `AUTH0_CLIENT_SECRET` environment variable.
        :param pulumi.Input[_builtins.str] custom_domain_header: When specified, this header is added to requests targeting a set of pre-defined whitelisted URLs Global setting overrides all resource specific `custom_domain_header` value
        :param pulumi.Input[_builtins.bool] debug: Enables HTTP request and response logging when TF_LOG=DEBUG is set. It can also be sourced from the `AUTH0_DEBUG` environment variable.
        :param pulumi.Input[_builtins.str] domain: Your Auth0 domain name. It can also be sourced from the `AUTH0_DOMAIN` environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the auth0 package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 cli_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_assertion_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_assertion_signing_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 debug: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["api_token"] = api_token
            __props__.__dict__["audience"] = audience
            __props__.__dict__["cli_login"] = pulumi.Output.from_input(cli_login).apply(pulumi.runtime.to_json) if cli_login is not None else None
            __props__.__dict__["client_assertion_private_key"] = client_assertion_private_key
            __props__.__dict__["client_assertion_signing_alg"] = client_assertion_signing_alg
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["custom_domain_header"] = custom_domain_header
            if debug is None:
                debug = _utilities.get_env_bool('AUTH0_DEBUG')
            __props__.__dict__["debug"] = pulumi.Output.from_input(debug).apply(pulumi.runtime.to_json) if debug is not None else None
            __props__.__dict__["domain"] = domain
            __props__.__dict__["dynamic_credentials"] = pulumi.Output.from_input(dynamic_credentials).apply(pulumi.runtime.to_json) if dynamic_credentials is not None else None
        super(Provider, __self__).__init__(
            'auth0',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your Auth0 [management api access token](https://auth0.com/docs/security/tokens/access-tokens/management-api-access-tokens). It can also be sourced from the `AUTH0_API_TOKEN` environment variable. It can be used instead of `client_id` + `client_secret`. If both are specified, `api_token` will be used over `client_id` + `client_secret` fields.
        """
        return pulumi.get(self, "api_token")

    @_builtins.property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your Auth0 audience when using a custom domain. It can also be sourced from the `AUTH0_AUDIENCE` environment variable.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter(name="clientAssertionPrivateKey")
    def client_assertion_private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "client_assertion_private_key")

    @_builtins.property
    @pulumi.getter(name="clientAssertionSigningAlg")
    def client_assertion_signing_alg(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The algorithm used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_SIGNING_ALG` environment variable.
        """
        return pulumi.get(self, "client_assertion_signing_alg")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your Auth0 client ID. It can also be sourced from the `AUTH0_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your Auth0 client secret. It can also be sourced from the `AUTH0_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="customDomainHeader")
    def custom_domain_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When specified, this header is added to requests targeting a set of pre-defined whitelisted URLs Global setting overrides all resource specific `custom_domain_header` value
        """
        return pulumi.get(self, "custom_domain_header")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your Auth0 domain name. It can also be sourced from the `AUTH0_DOMAIN` environment variable.
        """
        return pulumi.get(self, "domain")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:auth0/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

