# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[_builtins.str],
                 app_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 family_name: Optional[pulumi.Input[_builtins.str]] = None,
                 given_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 picture: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_email: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] connection_name: Name of the connection from which the user information was sourced.
        :param pulumi.Input[_builtins.str] app_metadata: Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[_builtins.bool] blocked: Indicates whether the user is blocked or not.
        :param pulumi.Input[_builtins.str] custom_domain_header: Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        :param pulumi.Input[_builtins.str] email: Email address of the user.
        :param pulumi.Input[_builtins.bool] email_verified: Indicates whether the email address has been verified.
        :param pulumi.Input[_builtins.str] family_name: Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] given_name: Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] name: Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] nickname: Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] password: Initial password for this user. Required for non-passwordless connections (SMS and email).
        :param pulumi.Input[_builtins.str] phone_number: Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[_builtins.bool] phone_verified: Indicates whether the phone number has been verified.
        :param pulumi.Input[_builtins.str] picture: Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] user_id: ID of the user.
        :param pulumi.Input[_builtins.str] user_metadata: Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[_builtins.str] username: Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[_builtins.bool] verify_email: Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        if app_metadata is not None:
            pulumi.set(__self__, "app_metadata", app_metadata)
        if blocked is not None:
            pulumi.set(__self__, "blocked", blocked)
        if custom_domain_header is not None:
            pulumi.set(__self__, "custom_domain_header", custom_domain_header)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_verified is not None:
            pulumi.set(__self__, "email_verified", email_verified)
        if family_name is not None:
            pulumi.set(__self__, "family_name", family_name)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if phone_verified is not None:
            pulumi.set(__self__, "phone_verified", phone_verified)
        if picture is not None:
            pulumi.set(__self__, "picture", picture)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_metadata is not None:
            pulumi.set(__self__, "user_metadata", user_metadata)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_email is not None:
            pulumi.set(__self__, "verify_email", verify_email)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the connection from which the user information was sourced.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        """
        return pulumi.get(self, "app_metadata")

    @app_metadata.setter
    def app_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_metadata", value)

    @_builtins.property
    @pulumi.getter
    def blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the user is blocked or not.
        """
        return pulumi.get(self, "blocked")

    @blocked.setter
    def blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "blocked", value)

    @_builtins.property
    @pulumi.getter(name="customDomainHeader")
    def custom_domain_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        """
        return pulumi.get(self, "custom_domain_header")

    @custom_domain_header.setter
    def custom_domain_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_header", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the email address has been verified.
        """
        return pulumi.get(self, "email_verified")

    @email_verified.setter
    def email_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_verified", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial password for this user. Required for non-passwordless connections (SMS and email).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="phoneVerified")
    def phone_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the phone number has been verified.
        """
        return pulumi.get(self, "phone_verified")

    @phone_verified.setter
    def phone_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "phone_verified", value)

    @_builtins.property
    @pulumi.getter
    def picture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "picture")

    @picture.setter
    def picture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "picture", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        """
        return pulumi.get(self, "user_metadata")

    @user_metadata.setter
    def user_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_metadata", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username of the user. Only valid if the connection requires a username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="verifyEmail")
    def verify_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        return pulumi.get(self, "verify_email")

    @verify_email.setter
    def verify_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_email", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 app_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 family_name: Optional[pulumi.Input[_builtins.str]] = None,
                 given_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 picture: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_email: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] app_metadata: Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[_builtins.bool] blocked: Indicates whether the user is blocked or not.
        :param pulumi.Input[_builtins.str] connection_name: Name of the connection from which the user information was sourced.
        :param pulumi.Input[_builtins.str] custom_domain_header: Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        :param pulumi.Input[_builtins.str] email: Email address of the user.
        :param pulumi.Input[_builtins.bool] email_verified: Indicates whether the email address has been verified.
        :param pulumi.Input[_builtins.str] family_name: Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] given_name: Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] name: Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] nickname: Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] password: Initial password for this user. Required for non-passwordless connections (SMS and email).
        :param pulumi.Input[_builtins.str] phone_number: Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[_builtins.bool] phone_verified: Indicates whether the phone number has been verified.
        :param pulumi.Input[_builtins.str] picture: Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] user_id: ID of the user.
        :param pulumi.Input[_builtins.str] user_metadata: Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[_builtins.str] username: Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[_builtins.bool] verify_email: Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        if app_metadata is not None:
            pulumi.set(__self__, "app_metadata", app_metadata)
        if blocked is not None:
            pulumi.set(__self__, "blocked", blocked)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if custom_domain_header is not None:
            pulumi.set(__self__, "custom_domain_header", custom_domain_header)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_verified is not None:
            pulumi.set(__self__, "email_verified", email_verified)
        if family_name is not None:
            pulumi.set(__self__, "family_name", family_name)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if phone_verified is not None:
            pulumi.set(__self__, "phone_verified", phone_verified)
        if picture is not None:
            pulumi.set(__self__, "picture", picture)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_metadata is not None:
            pulumi.set(__self__, "user_metadata", user_metadata)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_email is not None:
            pulumi.set(__self__, "verify_email", verify_email)

    @_builtins.property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        """
        return pulumi.get(self, "app_metadata")

    @app_metadata.setter
    def app_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_metadata", value)

    @_builtins.property
    @pulumi.getter
    def blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the user is blocked or not.
        """
        return pulumi.get(self, "blocked")

    @blocked.setter
    def blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "blocked", value)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection from which the user information was sourced.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="customDomainHeader")
    def custom_domain_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        """
        return pulumi.get(self, "custom_domain_header")

    @custom_domain_header.setter
    def custom_domain_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_header", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the email address has been verified.
        """
        return pulumi.get(self, "email_verified")

    @email_verified.setter
    def email_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_verified", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial password for this user. Required for non-passwordless connections (SMS and email).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="phoneVerified")
    def phone_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the phone number has been verified.
        """
        return pulumi.get(self, "phone_verified")

    @phone_verified.setter
    def phone_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "phone_verified", value)

    @_builtins.property
    @pulumi.getter
    def picture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "picture")

    @picture.setter
    def picture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "picture", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        """
        return pulumi.get(self, "user_metadata")

    @user_metadata.setter
    def user_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_metadata", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username of the user. Only valid if the connection requires a username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="verifyEmail")
    def verify_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        return pulumi.get(self, "verify_email")

    @verify_email.setter
    def verify_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_email", value)


@pulumi.type_token("auth0:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 family_name: Optional[pulumi.Input[_builtins.str]] = None,
                 given_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 picture: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        With this resource, you can manage user identities, including resetting passwords, and creating, provisioning, blocking, and deleting users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        user = auth0.User("user",
            connection_name="Username-Password-Authentication",
            user_id="12345",
            username="unique_username",
            name="Firstname Lastname",
            nickname="some.nickname",
            email="test@test.com",
            email_verified=True,
            password="passpass$12$12",
            picture="https://www.example.com/a-valid-picture-url.jpg")
        # Create a user with custom_domain_header
        auth0_user_with_custom_domain = auth0.User("auth0_user_with_custom_domain",
            connection_name="Username-Password-Authentication",
            username="your_new_user_",
            email="change.username@acceptance.test.com",
            email_verified=True,
            password="MyPass123$",
            custom_domain_header="my-custom.domain.org")
        ```

        ## Import

        This resource can be imported using the user ID.

        Example:

        ```sh
        $ pulumi import auth0:index/user:User user "auth0|111111111111111111111111"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_metadata: Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[_builtins.bool] blocked: Indicates whether the user is blocked or not.
        :param pulumi.Input[_builtins.str] connection_name: Name of the connection from which the user information was sourced.
        :param pulumi.Input[_builtins.str] custom_domain_header: Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        :param pulumi.Input[_builtins.str] email: Email address of the user.
        :param pulumi.Input[_builtins.bool] email_verified: Indicates whether the email address has been verified.
        :param pulumi.Input[_builtins.str] family_name: Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] given_name: Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] name: Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] nickname: Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] password: Initial password for this user. Required for non-passwordless connections (SMS and email).
        :param pulumi.Input[_builtins.str] phone_number: Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[_builtins.bool] phone_verified: Indicates whether the phone number has been verified.
        :param pulumi.Input[_builtins.str] picture: Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] user_id: ID of the user.
        :param pulumi.Input[_builtins.str] user_metadata: Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[_builtins.str] username: Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[_builtins.bool] verify_email: Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage user identities, including resetting passwords, and creating, provisioning, blocking, and deleting users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        user = auth0.User("user",
            connection_name="Username-Password-Authentication",
            user_id="12345",
            username="unique_username",
            name="Firstname Lastname",
            nickname="some.nickname",
            email="test@test.com",
            email_verified=True,
            password="passpass$12$12",
            picture="https://www.example.com/a-valid-picture-url.jpg")
        # Create a user with custom_domain_header
        auth0_user_with_custom_domain = auth0.User("auth0_user_with_custom_domain",
            connection_name="Username-Password-Authentication",
            username="your_new_user_",
            email="change.username@acceptance.test.com",
            email_verified=True,
            password="MyPass123$",
            custom_domain_header="my-custom.domain.org")
        ```

        ## Import

        This resource can be imported using the user ID.

        Example:

        ```sh
        $ pulumi import auth0:index/user:User user "auth0|111111111111111111111111"
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 family_name: Optional[pulumi.Input[_builtins.str]] = None,
                 given_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 picture: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["app_metadata"] = app_metadata
            __props__.__dict__["blocked"] = blocked
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["custom_domain_header"] = custom_domain_header
            __props__.__dict__["email"] = email
            __props__.__dict__["email_verified"] = email_verified
            __props__.__dict__["family_name"] = family_name
            __props__.__dict__["given_name"] = given_name
            __props__.__dict__["name"] = name
            __props__.__dict__["nickname"] = nickname
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["phone_verified"] = phone_verified
            __props__.__dict__["picture"] = picture
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["user_metadata"] = user_metadata
            __props__.__dict__["username"] = username
            __props__.__dict__["verify_email"] = verify_email
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'auth0:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_domain_header: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
            family_name: Optional[pulumi.Input[_builtins.str]] = None,
            given_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nickname: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            phone_verified: Optional[pulumi.Input[_builtins.bool]] = None,
            picture: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            verify_email: Optional[pulumi.Input[_builtins.bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_metadata: Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[_builtins.bool] blocked: Indicates whether the user is blocked or not.
        :param pulumi.Input[_builtins.str] connection_name: Name of the connection from which the user information was sourced.
        :param pulumi.Input[_builtins.str] custom_domain_header: Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        :param pulumi.Input[_builtins.str] email: Email address of the user.
        :param pulumi.Input[_builtins.bool] email_verified: Indicates whether the email address has been verified.
        :param pulumi.Input[_builtins.str] family_name: Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] given_name: Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] name: Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] nickname: Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] password: Initial password for this user. Required for non-passwordless connections (SMS and email).
        :param pulumi.Input[_builtins.str] phone_number: Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[_builtins.bool] phone_verified: Indicates whether the phone number has been verified.
        :param pulumi.Input[_builtins.str] picture: Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        :param pulumi.Input[_builtins.str] user_id: ID of the user.
        :param pulumi.Input[_builtins.str] user_metadata: Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[_builtins.str] username: Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[_builtins.bool] verify_email: Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["app_metadata"] = app_metadata
        __props__.__dict__["blocked"] = blocked
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["custom_domain_header"] = custom_domain_header
        __props__.__dict__["email"] = email
        __props__.__dict__["email_verified"] = email_verified
        __props__.__dict__["family_name"] = family_name
        __props__.__dict__["given_name"] = given_name
        __props__.__dict__["name"] = name
        __props__.__dict__["nickname"] = nickname
        __props__.__dict__["password"] = password
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["phone_verified"] = phone_verified
        __props__.__dict__["picture"] = picture
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_metadata"] = user_metadata
        __props__.__dict__["username"] = username
        __props__.__dict__["verify_email"] = verify_email
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        """
        return pulumi.get(self, "app_metadata")

    @_builtins.property
    @pulumi.getter
    def blocked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the user is blocked or not.
        """
        return pulumi.get(self, "blocked")

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the connection from which the user information was sourced.
        """
        return pulumi.get(self, "connection_name")

    @_builtins.property
    @pulumi.getter(name="customDomainHeader")
    def custom_domain_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the `Auth0-Custom-Domain` header on all requests for this resource. Global setting of provider takes precedence over resource specific param, if both are set.
        """
        return pulumi.get(self, "custom_domain_header")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the email address has been verified.
        """
        return pulumi.get(self, "email_verified")

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Family name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "family_name")

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Given name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "given_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[_builtins.str]:
        """
        Preferred nickname or alias of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "nickname")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Initial password for this user. Required for non-passwordless connections (SMS and email).
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="phoneVerified")
    def phone_verified(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the phone number has been verified.
        """
        return pulumi.get(self, "phone_verified")

    @_builtins.property
    @pulumi.getter
    def picture(self) -> pulumi.Output[_builtins.str]:
        """
        Picture of the user. This value can only be updated if the connection is a database connection (using the Auth0 store), a passwordless connection (email or sms) or has disabled 'Sync user profile attributes at each login'. For more information, see: [Configure Identity Provider Connection for User Profile Updates](https://auth0.com/docs/manage-users/user-accounts/user-profiles/configure-connection-sync-with-auth0).
        """
        return pulumi.get(self, "picture")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        """
        return pulumi.get(self, "user_metadata")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username of the user. Only valid if the connection requires a username.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyEmail")
    def verify_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        return pulumi.get(self, "verify_email")

