"""
    lager.ssh.commands

    SSH into DUTs
"""
import click
import subprocess
import sys
from ..dut_storage import resolve_and_validate_dut


@click.command()
@click.pass_context
@click.option('--dut', required=True, help='DUT or Gateway IP')
def ssh(ctx, dut):
    """
        SSH into a DUT
    """
    # Resolve and validate the DUT (handles both names and IPs)
    resolved_dut = resolve_and_validate_dut(ctx, dut)

    # Build SSH command
    ssh_host = f'lagerdata@{resolved_dut}'

    try:
        # Use subprocess to execute SSH interactively
        # We use os.execvp to replace the current process with SSH
        # This allows full interactivity (shell, etc.)
        import os
        os.execvp('ssh', ['ssh', ssh_host])
    except FileNotFoundError:
        click.secho('Error: SSH client not found. Please ensure SSH is installed.', fg='red', err=True)
        ctx.exit(1)
    except Exception as e:
        click.secho(f'Error connecting to {ssh_host}: {str(e)}', fg='red', err=True)
        ctx.exit(1)
