import os
import json
from pathlib import Path
import click
from ..context import get_default_gateway
from ..python.commands import run_python_internal

def _impl_thermocouple_path() -> str:
    return str(Path(__file__).resolve().parent.parent / "impl" / "thermocouple.py")

@click.command(name="thermocouple", help="Read thermocouple temperature in degrees Celsius (°C)")
@click.pass_context
@click.option("--gateway", required=False, hidden=True, help="ID of gateway")
@click.option("--dut", required=False, help="DUT or Gateway IP")
@click.argument("netname", required=True)
def thermocouple(ctx, gateway, dut, netname):
    from ..dut_storage import get_dut_ip

    # Strip whitespace from netname for better UX
    netname = netname.strip()

    # Check if gateway is a local DUT name first
    if gateway:
        local_ip = get_dut_ip(gateway)
        if local_ip:
            gateway = local_ip
    elif dut:
        local_ip = get_dut_ip(dut)
        if local_ip:
            gateway = local_ip
        else:
            gateway = dut
    else:
        gateway = get_default_gateway(ctx)
    gateway_image = os.environ.get("LAGER_GATEWAY_IMAGE", "python")

    payload = json.dumps({"netname": netname})

    run_python_internal(
        ctx=ctx,
        runnable=_impl_thermocouple_path(),
        gateway=gateway,
        image=gateway_image,
        env=(),
        passenv=(),
        kill=False,
        download=(),
        allow_overwrite=False,
        signum="SIGTERM",
        timeout=None,
        detach=False,
        port=(),
        org=None,
        args=[payload],
    )




# """
#     lager.thermocouple.commands

#     Thermocouple commands
# """

# import click
# from ..context import get_default_gateway
# from ..context import get_impl_path
# from ..python.commands import run_python_internal

# @click.command()
# @click.pass_context
# @click.option('--gateway', required=False, help='ID of gateway to which DUT is connected', hidden=True)
# @click.option('--dut', required=False, help='ID of DUT')
# @click.argument('NET', required=True)
# def thermocouple(ctx, gateway, dut, net):
#     """
#         Read the thermocouple for a net the gateway. Result is in degrees C
#     """
#     gateway = gateway or dut
#     if gateway is None:
#         gateway = get_default_gateway(ctx)

#     run_python_internal(
#         ctx,
#         get_impl_path('thermocouple.py'),
#         dut,
#         image='',
#         env=(),
#         passenv=(),
#         kill=False,
#         download=(),
#         allow_overwrite=False,
#         signum='SIGTERM',
#         timeout=0,
#         detach=False,
#         port=(),
#         org=None,
#         args=(net,),
#     )

