# ruff: noqa: N802, PYI021

from collections.abc import Iterator
from enum import IntEnum
from types import TracebackType
from typing import Any, NamedTuple, Self

import bs4

from .Microsoft.AnalysisServices.AdomdClient import AdomdConnection

class ReaderType:
    """Actually just called Type, but prefix for clarity."""

    def ToString(self) -> str: ...

class ConnectionState(IntEnum):
    OPEN = 1
    CLOSED = 0

class IDataReader:
    @property
    def IsClosed(self) -> bool: ...
    def Close(self) -> None: ...
    def ReadOuterXml(self) -> str: ...
    def GetName(self, idx: int) -> str: ...
    def GetFieldType(self, idx: int) -> ReaderType: ...
    def __getitem__(self, idx: int) -> Any: ...
    def Read(self) -> bool: ...

class AdomdErrorResponseException(BaseException):
    Message: str

class Description(NamedTuple):
    name: str
    type_code: str

class Reader:
    _reader: IDataReader

    # No implementation of __init__ since it shouldn't be called directly.
    def __init__(self, reader: IDataReader) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def read(self) -> bool: ...
    def read_outer_xml(self) -> str: ...
    def column_names(self) -> list[str]: ...
    def descriptions(self) -> list[Description]: ...
    def get_row(self) -> tuple[Any, ...]: ...
    @property
    def field_count(self) -> int: ...
    @property
    def is_closed(self) -> bool: ...
    def close(self) -> None: ...
    def fetch_stream(self) -> Iterator[dict[str, Any]]: ...
    def fetch_one(self) -> dict[str, Any]: ...
    def fetch_one_tuple(self) -> tuple[Any, ...]: ...
    def fetch_many(self, limit: int | None = None) -> list[dict[str, Any]]: ...

class Connection:
    conn: AdomdConnection
    def __init__(self, conn_str: str) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...
    def clone(self) -> Connection: ...
    def close(self) -> None: ...
    def open(self) -> Self: ...
    @property
    def state(self) -> ConnectionState: ...
    def execute_xml(
        self,
        query: str,
        query_name: str | None = None,
    ) -> bs4.BeautifulSoup: ...
    def execute_dax(self, query: str, query_name: str | None = None) -> Reader: ...
    def execute_non_query(self, query: str, query_name: str | None = None) -> Self: ...

def connect(conn_str: str) -> Connection: ...
